/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StringUtil {
    private static final Logger LOG = Log.getLogger(StringUtil.class);
    private static final Trie<String> CHARSETS = new ArrayTrie<String>(256);
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String CRLF = "\r\n";
    @Deprecated
    public static final String __LINE_SEPARATOR = System.lineSeparator();
    public static final String __ISO_8859_1 = "iso-8859-1";
    public static final String __UTF8 = "utf-8";
    public static final String __UTF16 = "utf-16";
    public static final char[] lowercases;

    public static String normalizeCharset(String string) {
        String string2 = CHARSETS.get(string);
        return string2 == null ? string : string2;
    }

    public static String normalizeCharset(String string, int n, int n2) {
        String string2 = CHARSETS.get(string, n, n2);
        return string2 == null ? string.substring(n, n + n2) : string2;
    }

    public static String asciiToLowerCase(String string) {
        char[] cArray = null;
        int n = string.length();
        while (n-- > 0) {
            char c;
            char c2 = string.charAt(n);
            if (c2 > '\u007f' || c2 == (c = lowercases[c2])) continue;
            cArray = string.toCharArray();
            cArray[n] = c;
            break;
        }
        while (n-- > 0) {
            if (cArray[n] > 127) continue;
            cArray[n] = lowercases[cArray[n]];
        }
        return cArray == null ? string : new String(cArray);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        if (string == null || string.length() < string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i))) continue;
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c <= '\u007f') {
                c = lowercases[c];
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        int n;
        if (string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        int n3 = n;
        while (n3-- > 0) {
            char c;
            char c2;
            if ((c2 = string.charAt(--n2)) == (c = string2.charAt(n3))) continue;
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c <= '\u007f') {
                c = lowercases[c];
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = string.indexOf(string2, n);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string3.length());
        do {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
        } while ((n2 = string.indexOf(string2, n = n2 + string2.length())) != -1);
        if (n < string.length()) {
            stringBuilder.append(string.substring(n, string.length()));
        }
        return stringBuilder.toString();
    }

    public static String unquote(String string) {
        return QuotedStringTokenizer.unquote(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuilder stringBuilder, String string, int n, int n2) {
        StringBuilder stringBuilder2 = stringBuilder;
        synchronized (stringBuilder2) {
            int n3 = n + n2;
            for (int i = n; i < n3 && i < string.length(); ++i) {
                stringBuilder.append(string.charAt(i));
            }
        }
    }

    public static void append(StringBuilder stringBuilder, byte by, int n) {
        int n2 = 0xFF & by;
        int n3 = 48 + n2 / n % n;
        if (n3 > 57) {
            n3 = 97 + (n3 - 48 - 10);
        }
        stringBuilder.append((char)n3);
        n3 = 48 + n2 % n;
        if (n3 > 57) {
            n3 = 97 + (n3 - 48 - 10);
        }
        stringBuilder.append((char)n3);
    }

    public static void append2digits(StringBuffer stringBuffer, int n) {
        if (n < 100) {
            stringBuffer.append((char)(n / 10 + 48));
            stringBuffer.append((char)(n % 10 + 48));
        }
    }

    public static void append2digits(StringBuilder stringBuilder, int n) {
        if (n < 100) {
            stringBuilder.append((char)(n / 10 + 48));
            stringBuilder.append((char)(n % 10 + 48));
        }
    }

    public static String nonNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static boolean equals(String string, char[] cArray, int n, int n2) {
        if (string.length() != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[n + i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    public static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUTF8(String string) {
        return __UTF8.equalsIgnoreCase(string) || __UTF8.equalsIgnoreCase(StringUtil.normalizeCharset(string));
    }

    public static String printable(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String printable(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)byArray[i];
            if (Character.isWhitespace(c) || c > ' ' && c < '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("0x");
            TypeUtil.toHex(byArray[i], (Appendable)stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static byte[] getBytes(String string) {
        return string.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static byte[] getUtf8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (Exception exception) {
            LOG.warn(exception);
            return string.getBytes();
        }
    }

    public static String sidBytesToString(byte[] byArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("S-");
        stringBuilder.append(Byte.toString(byArray[0])).append('-');
        StringBuilder stringBuilder2 = new StringBuilder();
        for (n = 2; n <= 7; ++n) {
            stringBuilder2.append(Integer.toHexString(byArray[n] & 0xFF));
        }
        stringBuilder.append(Long.parseLong(stringBuilder2.toString(), 16));
        n = byArray[1];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 4;
            stringBuilder2.setLength(0);
            stringBuilder2.append(String.format("%02X%02X%02X%02X", byArray[11 + n2] & 0xFF, byArray[10 + n2] & 0xFF, byArray[9 + n2] & 0xFF, byArray[8 + n2] & 0xFF));
            stringBuilder.append('-').append(Long.parseLong(stringBuilder2.toString(), 16));
        }
        return stringBuilder.toString();
    }

    public static byte[] sidStringToBytes(String string) {
        int n;
        String[] stringArray = string.split("-");
        int n2 = stringArray.length - 3;
        int n3 = 0;
        byte[] byArray = new byte[8 + 4 * n2];
        byArray[n3++] = (byte)Integer.parseInt(stringArray[1]);
        byArray[n3++] = (byte)n2;
        String string2 = Long.toHexString(Long.parseLong(stringArray[2]));
        while (string2.length() < 12) {
            string2 = "0" + string2;
        }
        for (n = 0; n < string2.length(); n += 2) {
            byArray[n3++] = (byte)Integer.parseInt(string2.substring(n, n + 2), 16);
        }
        for (n = 3; n < stringArray.length; ++n) {
            string2 = Long.toHexString(Long.parseLong(stringArray[n]));
            while (string2.length() < 8) {
                string2 = "0" + string2;
            }
            for (int i = string2.length(); i > 0; i -= 2) {
                byArray[n3++] = (byte)Integer.parseInt(string2.substring(i - 2, i), 16);
            }
        }
        return byArray;
    }

    public static int toInt(String string, int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= ' ') {
                if (!bl) continue;
                break;
            }
            if (c >= '0' && c <= '9') {
                n2 = n2 * 10 + (c - 48);
                bl = true;
                continue;
            }
            if (c != '-' || bl) break;
            bl2 = true;
        }
        if (bl) {
            return bl2 ? -n2 : n2;
        }
        throw new NumberFormatException(string);
    }

    public static long toLong(String string) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= ' ') {
                if (!bl) continue;
                break;
            }
            if (c >= '0' && c <= '9') {
                l = l * 10L + (long)(c - 48);
                bl = true;
                continue;
            }
            if (c != '-' || bl) break;
            bl2 = true;
        }
        if (bl) {
            return bl2 ? -l : l;
        }
        throw new NumberFormatException(string);
    }

    public static String truncate(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String[] arrayFromString(String string) {
        if (string == null) {
            return new String[0];
        }
        if (!string.startsWith("[") || !string.endsWith("]")) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 2) {
            return new String[0];
        }
        return StringUtil.csvSplit(string, 1, string.length() - 2);
    }

    public static String[] csvSplit(String string) {
        if (string == null) {
            return null;
        }
        return StringUtil.csvSplit(string, 0, string.length());
    }

    public static String[] csvSplit(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n < 0 || n2 < 0 || n > string.length()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringUtil.csvSplit(arrayList, string, n, n2);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static List<String> csvSplit(List<String> list, String string, int n, int n2) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        CsvSplitState csvSplitState = CsvSplitState.PRE_DATA;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = -1;
        block13: while (n2 > 0) {
            char c = string.charAt(n++);
            --n2;
            switch (csvSplitState) {
                case PRE_DATA: {
                    if (Character.isWhitespace(c)) continue block13;
                    if ('\"' == c) {
                        csvSplitState = CsvSplitState.QUOTE;
                        continue block13;
                    }
                    if (',' == c) {
                        list.add("");
                        continue block13;
                    }
                    csvSplitState = CsvSplitState.DATA;
                    stringBuilder.append(c);
                    continue block13;
                }
                case DATA: {
                    if (Character.isWhitespace(c)) {
                        n3 = stringBuilder.length();
                        stringBuilder.append(c);
                        csvSplitState = CsvSplitState.WHITE;
                        continue block13;
                    }
                    if (',' == c) {
                        list.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        csvSplitState = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    stringBuilder.append(c);
                    continue block13;
                }
                case WHITE: {
                    if (Character.isWhitespace(c)) {
                        stringBuilder.append(c);
                        continue block13;
                    }
                    if (',' == c) {
                        stringBuilder.setLength(n3);
                        list.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        csvSplitState = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    csvSplitState = CsvSplitState.DATA;
                    stringBuilder.append(c);
                    n3 = -1;
                    continue block13;
                }
                case QUOTE: {
                    if ('\\' == c) {
                        csvSplitState = CsvSplitState.SLOSH;
                        continue block13;
                    }
                    if ('\"' == c) {
                        list.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        csvSplitState = CsvSplitState.POST_DATA;
                        continue block13;
                    }
                    stringBuilder.append(c);
                    continue block13;
                }
                case SLOSH: {
                    stringBuilder.append(c);
                    csvSplitState = CsvSplitState.QUOTE;
                    continue block13;
                }
                case POST_DATA: {
                    if (',' != c) continue block13;
                    csvSplitState = CsvSplitState.PRE_DATA;
                    continue block13;
                }
            }
        }
        switch (csvSplitState) {
            case PRE_DATA: 
            case POST_DATA: {
                break;
            }
            case DATA: 
            case QUOTE: 
            case SLOSH: {
                list.add(stringBuilder.toString());
                break;
            }
            case WHITE: {
                stringBuilder.setLength(n3);
                list.add(stringBuilder.toString());
            }
        }
        return list;
    }

    public static String sanitizeXmlString(String string) {
        int n;
        if (string == null) {
            return null;
        }
        block10: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    break block10;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) break block10;
                    continue block10;
                }
            }
        }
        if (n == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 4 / 3);
        stringBuilder.append(string, 0, n);
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    break;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        stringBuilder.append('?');
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String valueOf(Object object) {
        return object == null ? null : String.valueOf(object);
    }

    static {
        CHARSETS.put(__UTF8, __UTF8);
        CHARSETS.put("utf8", __UTF8);
        CHARSETS.put(__UTF16, __UTF16);
        CHARSETS.put("utf16", __UTF16);
        CHARSETS.put(__ISO_8859_1, __ISO_8859_1);
        CHARSETS.put("iso_8859_1", __ISO_8859_1);
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }

    static enum CsvSplitState {
        PRE_DATA,
        QUOTE,
        SLOSH,
        DATA,
        WHITE,
        POST_DATA;

    }
}

