/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Scanner
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(Scanner.class);
    private static int __scannerId = 0;
    private int _scanInterval;
    private int _scanCount = 0;
    private final List<Listener> _listeners = new ArrayList<Listener>();
    private final Map<String, TimeNSize> _prevScan = new HashMap<String, TimeNSize>();
    private final Map<String, TimeNSize> _currentScan = new HashMap<String, TimeNSize>();
    private FilenameFilter _filter;
    private final List<File> _scanDirs = new ArrayList<File>();
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private boolean _reportDirs = true;
    private Timer _timer;
    private TimerTask _task;
    private int _scanDepth = 0;
    private final Map<String, Notification> _notifications = new HashMap<String, Notification>();

    public synchronized int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int n) {
        this._scanInterval = n;
        this.schedule();
    }

    public void setScanDirs(List<File> list) {
        this._scanDirs.clear();
        this._scanDirs.addAll(list);
    }

    public synchronized void addScanDir(File file) {
        this._scanDirs.add(file);
    }

    public List<File> getScanDirs() {
        return Collections.unmodifiableList(this._scanDirs);
    }

    public void setRecursive(boolean bl) {
        this._scanDepth = bl ? -1 : 0;
    }

    public boolean getRecursive() {
        return this._scanDepth == -1;
    }

    public int getScanDepth() {
        return this._scanDepth;
    }

    public void setScanDepth(int n) {
        this._scanDepth = n;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filter = filenameFilter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean bl) {
        this._reportExisting = bl;
    }

    public boolean getReportExistingFilesOnStartup() {
        return this._reportExisting;
    }

    public void setReportDirs(boolean bl) {
        this._reportDirs = bl;
    }

    public boolean getReportDirs() {
        return this._reportDirs;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    @Override
    public synchronized void doStart() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Scanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer("Scanner-" + __scannerId++, true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1010L * (long)this.getScanInterval(), 1010L * (long)this.getScanInterval());
            }
        }
    }

    @Override
    public synchronized void doStop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public boolean exists(String string) {
        for (File file : this._scanDirs) {
            if (!new File(file, string).exists()) continue;
            return true;
        }
        return false;
    }

    public synchronized void scan() {
        this.reportScanStart(++this._scanCount);
        this.scanFiles();
        this.reportDifferences(this._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
        this.reportScanEnd(this._scanCount);
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanListener)) continue;
                ((ScanListener)listener).scan();
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
            catch (Error error) {
                LOG.warn(error);
            }
        }
    }

    public synchronized void scanFiles() {
        if (this._scanDirs == null) {
            return;
        }
        this._currentScan.clear();
        for (File file : this._scanDirs) {
            if (file == null || !file.exists()) continue;
            try {
                this.scanFile(file.getCanonicalFile(), this._currentScan, 0);
            }
            catch (IOException iOException) {
                LOG.warn("Error scanning files.", iOException);
            }
        }
    }

    public synchronized void reportDifferences(Map<String, TimeNSize> map, Map<String, TimeNSize> map2) {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>(map2.keySet());
        for (Map.Entry<String, TimeNSize> object32 : map.entrySet()) {
            object2 = object32.getKey();
            if (!hashSet.contains(object2)) {
                object = this._notifications.put((String)object2, Notification.ADDED);
                if (object == null) continue;
                switch (object) {
                    case REMOVED: 
                    case CHANGED: {
                        this._notifications.put((String)object2, Notification.CHANGED);
                    }
                }
                continue;
            }
            if (map2.get(object2).equals(map.get(object2)) || (object = this._notifications.put((String)object2, Notification.CHANGED)) == null) continue;
            switch (object) {
                case ADDED: {
                    this._notifications.put((String)object2, Notification.ADDED);
                }
            }
        }
        for (String string : map2.keySet()) {
            if (map.containsKey(string) || (object2 = this._notifications.put(string, Notification.REMOVED)) == null) continue;
            switch (2.$SwitchMap$org$eclipse$jetty$util$Scanner$Notification[((Enum)object2).ordinal()]) {
                case 3: {
                    this._notifications.remove(string);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("scanned " + this._scanDirs + ": " + this._notifications, new Object[0]);
        }
        ArrayList arrayList = new ArrayList();
        Iterator<Map.Entry<String, Notification>> iterator = this._notifications.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (String)object2.getKey();
            if (map2.containsKey(object) ? !map2.get(object).equals(map.get(object)) : map.containsKey(object)) continue;
            Notification notification = (Notification)((Object)object2.getValue());
            iterator.remove();
            arrayList.add(object);
            switch (notification) {
                case ADDED: {
                    this.reportAddition((String)object);
                    break;
                }
                case CHANGED: {
                    this.reportChange((String)object);
                    break;
                }
                case REMOVED: {
                    this.reportRemoval((String)object);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            this.reportBulkChanges(arrayList);
        }
    }

    private void scanFile(File file, Map<String, TimeNSize> map, int n) {
        try {
            File[] fileArray;
            if (!file.exists()) {
                return;
            }
            if (file.isFile() || n > 0 && this._reportDirs && file.isDirectory()) {
                if (this._filter == null || this._filter != null && this._filter.accept(file.getParentFile(), file.getName())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("scan accepted {}", file);
                    }
                    fileArray = file.getCanonicalPath();
                    map.put((String)fileArray, new TimeNSize(file.lastModified(), file.isDirectory() ? 0L : file.length()));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("scan rejected {}", file);
                }
            }
            if (file.isDirectory() && (n < this._scanDepth || this._scanDepth == -1 || this._scanDirs.contains(file))) {
                fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.scanFile(fileArray[i], map, n + 1);
                    }
                } else {
                    LOG.warn("Error listing files in directory {}", file);
                }
            }
        }
        catch (IOException iOException) {
            LOG.warn("Error scanning watched files", iOException);
        }
    }

    private void warn(Object object, String string, Throwable throwable) {
        LOG.warn(object + " failed on '" + string, throwable);
    }

    private void reportAddition(String string) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof DiscreteListener)) continue;
                ((DiscreteListener)listener).fileAdded(string);
            }
            catch (Exception exception) {
                this.warn(listener, string, exception);
            }
            catch (Error error) {
                this.warn(listener, string, error);
            }
        }
    }

    private void reportRemoval(String string) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof DiscreteListener)) continue;
                ((DiscreteListener)listener).fileRemoved(string);
            }
            catch (Exception exception) {
                this.warn(listener, string, exception);
            }
            catch (Error error) {
                this.warn(listener, string, error);
            }
        }
    }

    private void reportChange(String string) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof DiscreteListener)) continue;
                ((DiscreteListener)listener).fileChanged(string);
            }
            catch (Exception exception) {
                this.warn(listener, string, exception);
            }
            catch (Error error) {
                this.warn(listener, string, error);
            }
        }
    }

    private void reportBulkChanges(List<String> list) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof BulkListener)) continue;
                ((BulkListener)listener).filesChanged(list);
            }
            catch (Exception exception) {
                this.warn(listener, list.toString(), exception);
            }
            catch (Error error) {
                this.warn(listener, list.toString(), error);
            }
        }
    }

    private void reportScanStart(int n) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanStarted(n);
            }
            catch (Exception exception) {
                LOG.warn(listener + " failed on scan start for cycle " + n, exception);
            }
        }
    }

    private void reportScanEnd(int n) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanEnded(n);
            }
            catch (Exception exception) {
                LOG.warn(listener + " failed on scan end for cycle " + n, exception);
            }
        }
    }

    public static interface ScanCycleListener
    extends Listener {
        public void scanStarted(int var1);

        public void scanEnded(int var1);
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List<String> var1);
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1);

        public void fileAdded(String var1);

        public void fileRemoved(String var1);
    }

    public static interface ScanListener
    extends Listener {
        public void scan();
    }

    public static interface Listener {
    }

    static class TimeNSize {
        final long _lastModified;
        final long _size;

        public TimeNSize(long l, long l2) {
            this._lastModified = l;
            this._size = l2;
        }

        public int hashCode() {
            return (int)this._lastModified ^ (int)this._size;
        }

        public boolean equals(Object object) {
            if (object instanceof TimeNSize) {
                TimeNSize timeNSize = (TimeNSize)object;
                return timeNSize._lastModified == this._lastModified && timeNSize._size == this._size;
            }
            return false;
        }

        public String toString() {
            return "[lm=" + this._lastModified + ",s=" + this._size + "]";
        }
    }

    public static enum Notification {
        ADDED,
        CHANGED,
        REMOVED;

    }
}

