/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.FilterWriter;
import java.io.Writer;

public class MultiPartWriter
extends FilterWriter {
    private static final String __CRLF = "\r\n";
    private static final String __DASHDASH = "--";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
    private String boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
    private boolean inPart = false;

    public MultiPartWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void close() {
        try {
            if (this.inPart) {
                this.out.write(__CRLF);
            }
            this.out.write(__DASHDASH);
            this.out.write(this.boundary);
            this.out.write(__DASHDASH);
            this.out.write(__CRLF);
            this.inPart = false;
        }
        finally {
            super.close();
        }
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void startPart(String string) {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundary);
        this.out.write(__CRLF);
        this.out.write("Content-Type: ");
        this.out.write(string);
        this.out.write(__CRLF);
        this.out.write(__CRLF);
        this.inPart = true;
    }

    public void endPart() {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = false;
    }

    public void startPart(String string, String[] stringArray) {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundary);
        this.out.write(__CRLF);
        this.out.write("Content-Type: ");
        this.out.write(string);
        this.out.write(__CRLF);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.out.write(stringArray[i]);
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
        this.inPart = true;
    }
}

