/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiMap<V>
extends HashMap<String, List<V>> {
    public MultiMap() {
    }

    public MultiMap(Map<String, List<V>> map) {
        super(map);
    }

    public MultiMap(MultiMap<V> multiMap) {
        super(multiMap);
    }

    public List<V> getValues(String string) {
        List list = (List)super.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public V getValue(String string, int n) {
        List<V> list = this.getValues(string);
        if (list == null) {
            return null;
        }
        if (n == 0 && list.isEmpty()) {
            return null;
        }
        return list.get(n);
    }

    public String getString(String string) {
        List list = (List)this.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (Object e : list) {
            if (e == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(e.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public List<V> put(String string, V v) {
        if (v == null) {
            return super.put(string, null);
        }
        ArrayList<V> arrayList = new ArrayList<V>();
        arrayList.add(v);
        return this.put(string, arrayList);
    }

    public void putAllValues(Map<String, V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<V> putValues(String string, List<V> list) {
        return super.put(string, list);
    }

    @SafeVarargs
    public final List<V> putValues(String string, V ... VArray) {
        ArrayList<V> arrayList = new ArrayList<V>();
        arrayList.addAll(Arrays.asList(VArray));
        return super.put(string, arrayList);
    }

    public void add(String string, V v) {
        ArrayList<V> arrayList = (ArrayList<V>)this.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<V>();
        }
        arrayList.add(v);
        super.put(string, arrayList);
    }

    public void addValues(String string, List<V> list) {
        ArrayList<V> arrayList = (ArrayList<V>)this.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<V>();
        }
        arrayList.addAll(list);
        this.put(string, arrayList);
    }

    public void addValues(String string, V[] VArray) {
        ArrayList<V> arrayList = (ArrayList<V>)this.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<V>();
        }
        arrayList.addAll(Arrays.asList(VArray));
        this.put(string, arrayList);
    }

    public boolean addAllValues(MultiMap<V> multiMap) {
        boolean bl = false;
        if (multiMap == null || multiMap.isEmpty()) {
            return bl;
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            if (this.containsKey(string)) {
                bl = true;
            }
            this.addValues(string, list);
        }
        return bl;
    }

    public boolean removeValue(String string, V v) {
        List list = (List)this.get(string);
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean bl = list.remove(v);
        if (list.isEmpty()) {
            this.remove(string);
        } else {
            this.put(string, list);
        }
        return bl;
    }

    public boolean containsSimpleValue(V v) {
        for (List list : this.values()) {
            if (list.size() != 1 || !list.contains(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Iterator iterator = this.entrySet().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (bl) {
                stringBuilder.append(", ");
            }
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            stringBuilder.append(string);
            stringBuilder.append('=');
            if (list.size() == 1) {
                stringBuilder.append(list.get(0));
            } else {
                stringBuilder.append(list);
            }
            bl = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Map<String, String[]> toStringArrayMap() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(this.size() * 3 / 2){

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('{');
                for (String string : super.keySet()) {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string);
                    stringBuilder.append('=');
                    stringBuilder.append(Arrays.asList((Object[])super.get(string)));
                }
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
        };
        for (Map.Entry entry : this.entrySet()) {
            String[] stringArray = null;
            if (entry.getValue() != null) {
                stringArray = new String[((List)entry.getValue()).size()];
                stringArray = ((List)entry.getValue()).toArray(stringArray);
            }
            hashMap.put((String)entry.getKey(), stringArray);
        }
        return hashMap;
    }
}

