/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiException
extends Exception {
    private List<Throwable> nested;

    public MultiException() {
        super("Multiple exceptions");
    }

    public void add(Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException();
        }
        if (this.nested == null) {
            this.initCause(throwable);
            this.nested = new ArrayList<Throwable>();
        } else {
            this.addSuppressed(throwable);
        }
        if (throwable instanceof MultiException) {
            MultiException multiException = (MultiException)throwable;
            this.nested.addAll(multiException.nested);
        } else {
            this.nested.add(throwable);
        }
    }

    public int size() {
        return this.nested == null ? 0 : this.nested.size();
    }

    public List<Throwable> getThrowables() {
        if (this.nested == null) {
            return Collections.emptyList();
        }
        return this.nested;
    }

    public Throwable getThrowable(int n) {
        return this.nested.get(n);
    }

    public void ifExceptionThrow() {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = this.nested.get(0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
            }
            default: {
                throw this;
            }
        }
    }

    public void ifExceptionThrowRuntime() {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = this.nested.get(0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            default: {
                throw new RuntimeException(this);
            }
        }
    }

    public void ifExceptionThrowMulti() {
        if (this.nested == null) {
            return;
        }
        if (this.nested.size() > 0) {
            throw this;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MultiException.class.getSimpleName());
        if (this.nested == null || this.nested.size() <= 0) {
            stringBuilder.append("[]");
        } else {
            stringBuilder.append(this.nested);
        }
        return stringBuilder.toString();
    }
}

