/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jetty.util.resource.Resource;

public class Loader {
    public static URL getResource(Class<?> clazz, String string) {
        ClassLoader classLoader;
        URL uRL = null;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != null) {
            uRL = classLoader2.getResource(string);
        }
        if (uRL == null && clazz != null && (classLoader = clazz.getClassLoader()) != null && classLoader != classLoader2) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    public static Class loadClass(Class clazz, String string) {
        Class<?> clazz2;
        ClassNotFoundException classNotFoundException;
        block10: {
            ClassLoader classLoader;
            classNotFoundException = null;
            clazz2 = null;
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null) {
                try {
                    clazz2 = classLoader2.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    classNotFoundException = classNotFoundException2;
                }
            }
            if (clazz2 == null && clazz != null && (classLoader = clazz.getClassLoader()) != null && classLoader != classLoader2) {
                try {
                    clazz2 = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    if (classNotFoundException != null) break block10;
                    classNotFoundException = classNotFoundException3;
                }
            }
        }
        if (clazz2 == null) {
            try {
                clazz2 = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException4) {
                if (classNotFoundException != null) {
                    throw classNotFoundException;
                }
                throw classNotFoundException4;
            }
        }
        return clazz2;
    }

    public static ResourceBundle getResourceBundle(Class<?> clazz, String string, boolean bl, Locale locale) {
        ResourceBundle resourceBundle;
        MissingResourceException missingResourceException;
        block12: {
            missingResourceException = null;
            resourceBundle = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            while (resourceBundle == null && classLoader != null) {
                block10: {
                    try {
                        resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
                    }
                    catch (MissingResourceException missingResourceException2) {
                        if (missingResourceException != null) break block10;
                        missingResourceException = missingResourceException2;
                    }
                }
                classLoader = resourceBundle == null && bl ? classLoader.getParent() : null;
            }
            ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
            while (resourceBundle == null && classLoader != null) {
                block11: {
                    try {
                        resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
                    }
                    catch (MissingResourceException missingResourceException3) {
                        if (missingResourceException != null) break block11;
                        missingResourceException = missingResourceException3;
                    }
                }
                classLoader = resourceBundle == null && bl ? classLoader.getParent() : null;
            }
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException4) {
                    if (missingResourceException != null) break block12;
                    missingResourceException = missingResourceException4;
                }
            }
        }
        if (resourceBundle != null) {
            return resourceBundle;
        }
        throw missingResourceException;
    }

    public static String getClassPath(ClassLoader classLoader) {
        StringBuilder stringBuilder = new StringBuilder();
        while (classLoader != null && classLoader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            if (uRLArray != null) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    Resource resource = Resource.newResource(uRLArray[i]);
                    File file = resource.getFile();
                    if (file == null || !file.exists()) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(File.pathSeparatorChar);
                    }
                    stringBuilder.append(file.getAbsolutePath());
                }
            }
            classLoader = classLoader.getParent();
        }
        return stringBuilder.toString();
    }
}

