/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class IntrospectionUtil {
    public static boolean isJavaBeanCompliantSetter(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray, boolean bl, boolean bl2) {
        if (clazz == null) {
            throw new NoSuchMethodException("No class");
        }
        if (string == null || string.trim().equals("")) {
            throw new NoSuchMethodException("No method name");
        }
        Method method = null;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length && method == null; ++i) {
            if (!methodArray[i].getName().equals(string) || !IntrospectionUtil.checkParams(methodArray[i].getParameterTypes(), classArray == null ? new Class[]{} : classArray, bl2)) continue;
            method = methodArray[i];
        }
        if (method != null) {
            return method;
        }
        if (bl) {
            return IntrospectionUtil.findInheritedMethod(clazz.getPackage(), clazz.getSuperclass(), string, classArray, bl2);
        }
        throw new NoSuchMethodException("No such method " + string + " on class " + clazz.getName());
    }

    public static Field findField(Class<?> clazz, String string, Class<?> clazz2, boolean bl, boolean bl2) {
        if (clazz == null) {
            throw new NoSuchFieldException("No class");
        }
        if (string == null) {
            throw new NoSuchFieldException("No field name");
        }
        try {
            Field field = clazz.getDeclaredField(string);
            if (bl2 ? field.getType().equals(clazz2) : field.getType().isAssignableFrom(clazz2)) {
                return field;
            }
            if (bl) {
                return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz.getSuperclass(), string, clazz2, bl2);
            }
            throw new NoSuchFieldException("No field with name " + string + " in class " + clazz.getName() + " of type " + clazz2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz.getSuperclass(), string, clazz2, bl2);
        }
    }

    public static boolean isInheritable(Package package_, Member member) {
        if (package_ == null) {
            return false;
        }
        if (member == null) {
            return false;
        }
        int n = member.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isProtected(n)) {
            return true;
        }
        return !Modifier.isPrivate(n) && package_.equals(member.getDeclaringClass().getPackage());
    }

    public static boolean checkParams(Class<?>[] classArray, Class<?>[] classArray2, boolean bl) {
        int n;
        if (classArray == null) {
            return classArray2 == null;
        }
        if (classArray2 == null) {
            return false;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        if (classArray.length == 0) {
            return true;
        }
        if (bl) {
            for (n = 0; n < classArray.length && classArray[n].equals(classArray2[n]); ++n) {
            }
        } else {
            while (n < classArray.length && classArray[n].isAssignableFrom(classArray2[n])) {
                ++n;
            }
        }
        return n == classArray.length;
    }

    public static boolean isSameSignature(Method method, Method method2) {
        if (method == null) {
            return false;
        }
        if (method2 == null) {
            return false;
        }
        List<Class<Class<?>>> list = Arrays.asList(method.getParameterTypes());
        List<Class<?>> list2 = Arrays.asList(method2.getParameterTypes());
        return method.getName().equals(method2.getName()) && list.containsAll(list2);
    }

    public static boolean isTypeCompatible(Class<?> clazz, Class<?> clazz2, boolean bl) {
        if (clazz == null) {
            return clazz2 == null;
        }
        if (clazz2 == null) {
            return false;
        }
        if (bl) {
            return clazz.equals(clazz2);
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean containsSameMethodSignature(Method method, Class<?> clazz, boolean bl) {
        if (bl && !clazz.getPackage().equals(method.getDeclaringClass().getPackage())) {
            return false;
        }
        boolean bl2 = false;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length && !bl2; ++i) {
            if (!IntrospectionUtil.isSameSignature(method, methodArray[i])) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean containsSameFieldName(Field field, Class<?> clazz, boolean bl) {
        if (bl && !clazz.getPackage().equals(field.getDeclaringClass().getPackage())) {
            return false;
        }
        boolean bl2 = false;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length && !bl2; ++i) {
            if (!fieldArray[i].getName().equals(field.getName())) continue;
            bl2 = true;
        }
        return bl2;
    }

    protected static Method findInheritedMethod(Package package_, Class<?> clazz, String string, Class<?>[] classArray, boolean bl) {
        if (clazz == null) {
            throw new NoSuchMethodException("No class");
        }
        if (string == null) {
            throw new NoSuchMethodException("No method name");
        }
        Method method = null;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length && method == null; ++i) {
            if (!methodArray[i].getName().equals(string) || !IntrospectionUtil.isInheritable(package_, methodArray[i]) || !IntrospectionUtil.checkParams(methodArray[i].getParameterTypes(), classArray, bl)) continue;
            method = methodArray[i];
        }
        if (method != null) {
            return method;
        }
        return IntrospectionUtil.findInheritedMethod(clazz.getPackage(), clazz.getSuperclass(), string, classArray, bl);
    }

    protected static Field findInheritedField(Package package_, Class<?> clazz, String string, Class<?> clazz2, boolean bl) {
        if (clazz == null) {
            throw new NoSuchFieldException("No class");
        }
        if (string == null) {
            throw new NoSuchFieldException("No field name");
        }
        try {
            Field field = clazz.getDeclaredField(string);
            if (IntrospectionUtil.isInheritable(package_, field) && IntrospectionUtil.isTypeCompatible(clazz2, field.getType(), bl)) {
                return field;
            }
            return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz.getSuperclass(), string, clazz2, bl);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz.getSuperclass(), string, clazz2, bl);
        }
    }
}

