/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class IncludeExclude<ITEM> {
    private final Set<ITEM> _includes;
    private final Predicate<ITEM> _includePredicate;
    private final Set<ITEM> _excludes;
    private final Predicate<ITEM> _excludePredicate;

    public IncludeExclude() {
        this(HashSet.class);
    }

    public <SET extends Set<ITEM>> IncludeExclude(Class<SET> clazz) {
        try {
            this._includes = (Set)clazz.newInstance();
            this._excludes = (Set)clazz.newInstance();
            this._includePredicate = this._includes instanceof Predicate ? (Predicate<Object>)((Object)this._includes) : new SetContainsPredicate<ITEM>(this._includes);
            this._excludePredicate = this._excludes instanceof Predicate ? (Predicate<Object>)((Object)this._excludes) : new SetContainsPredicate<ITEM>(this._excludes);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public <SET extends Set<ITEM>> IncludeExclude(Set<ITEM> set, Predicate<ITEM> predicate, Set<ITEM> set2, Predicate<ITEM> predicate2) {
        Objects.requireNonNull(set, "Include Set");
        Objects.requireNonNull(predicate, "Include Predicate");
        Objects.requireNonNull(set2, "Exclude Set");
        Objects.requireNonNull(predicate2, "Exclude Predicate");
        this._includes = set;
        this._includePredicate = predicate;
        this._excludes = set2;
        this._excludePredicate = predicate2;
    }

    public void include(ITEM ITEM) {
        this._includes.add(ITEM);
    }

    public void include(ITEM ... ITEMArray) {
        for (ITEM ITEM : ITEMArray) {
            this._includes.add(ITEM);
        }
    }

    public void exclude(ITEM ITEM) {
        this._excludes.add(ITEM);
    }

    public void exclude(ITEM ... ITEMArray) {
        for (ITEM ITEM : ITEMArray) {
            this._excludes.add(ITEM);
        }
    }

    public boolean matches(ITEM ITEM) {
        if (!this._includes.isEmpty() && !this._includePredicate.test(ITEM)) {
            return false;
        }
        return !this._excludePredicate.test(ITEM);
    }

    public int size() {
        return this._includes.size() + this._excludes.size();
    }

    public Set<ITEM> getIncluded() {
        return this._includes;
    }

    public Set<ITEM> getExcluded() {
        return this._excludes;
    }

    public void clear() {
        this._includes.clear();
        this._excludes.clear();
    }

    public String toString() {
        return String.format("%s@%x{i=%s,ip=%s,e=%s,ep=%s}", this.getClass().getSimpleName(), this.hashCode(), this._includes, this._includePredicate, this._excludes, this._excludePredicate);
    }

    private static class SetContainsPredicate<ITEM>
    implements Predicate<ITEM> {
        private final Set<ITEM> set;

        public SetContainsPredicate(Set<ITEM> set) {
            this.set = set;
        }

        @Override
        public boolean test(ITEM ITEM) {
            return this.set.contains(ITEM);
        }
    }
}

