/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.LazyList;

public class IPAddressMap<TYPE>
extends HashMap<String, TYPE> {
    private final HashMap<String, IPAddrPattern> _patterns = new HashMap();

    public IPAddressMap() {
        super(11);
    }

    public IPAddressMap(int n) {
        super(n);
    }

    @Override
    public TYPE put(String string, TYPE TYPE) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid IP address pattern: " + string);
        }
        String string2 = string.trim();
        if (this._patterns.get(string2) == null) {
            this._patterns.put(string2, new IPAddrPattern(string2));
        }
        return super.put(string2, TYPE);
    }

    @Override
    public TYPE get(Object object) {
        return (TYPE)super.get(object);
    }

    public TYPE match(String string) {
        Map.Entry<String, TYPE> entry = this.getMatch(string);
        return entry == null ? null : (TYPE)entry.getValue();
    }

    public Map.Entry<String, TYPE> getMatch(String string) {
        if (string != null) {
            for (Map.Entry entry : super.entrySet()) {
                if (!this._patterns.get(entry.getKey()).match(string)) continue;
                return entry;
            }
        }
        return null;
    }

    public Object getLazyMatches(String string) {
        if (string == null) {
            return LazyList.getList(super.entrySet());
        }
        Object object = null;
        for (Map.Entry entry : super.entrySet()) {
            if (!this._patterns.get(entry.getKey()).match(string)) continue;
            object = LazyList.add(object, entry);
        }
        return object;
    }

    private static class OctetPattern
    extends BitSet {
        private final BitSet _mask = new BitSet(256);

        public OctetPattern(String string) {
            try {
                if (string != null) {
                    String string2 = string.trim();
                    if (string2.length() == 0) {
                        this._mask.set(0, 255);
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string3 = stringTokenizer.nextToken().trim();
                            if (string3.length() <= 0) continue;
                            if (string3.indexOf(45) < 0) {
                                Integer n = Integer.valueOf(string3);
                                this._mask.set(n);
                                continue;
                            }
                            int n = 0;
                            int n2 = 255;
                            String[] stringArray = string3.split("-", -2);
                            if (stringArray.length != 2) {
                                throw new IllegalArgumentException("Invalid octet spec: " + string);
                            }
                            if (stringArray[0].length() > 0) {
                                n = Integer.parseInt(stringArray[0]);
                            }
                            if (stringArray[1].length() > 0) {
                                n2 = Integer.parseInt(stringArray[1]);
                            }
                            if (n > n2) {
                                throw new IllegalArgumentException("Invalid octet spec: " + string);
                            }
                            this._mask.set(n, n2 + 1);
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid octet spec: " + string, numberFormatException);
            }
        }

        public boolean match(String string) {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid octet: " + string);
            }
            try {
                int n = Integer.parseInt(string);
                return this.match(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid octet: " + string);
            }
        }

        public boolean match(int n) {
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("Invalid octet: " + n);
            }
            return this._mask.get(n);
        }
    }

    private static class IPAddrPattern {
        private final OctetPattern[] _octets = new OctetPattern[4];

        public IPAddrPattern(String string) {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid IP address pattern: " + string);
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                for (int i = 0; i < 4; ++i) {
                    String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken().trim() : "0-255";
                    int n = string2.length();
                    if (n == 0 && stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Invalid IP address pattern: " + string);
                    }
                    this._octets[i] = new OctetPattern(n == 0 ? "0-255" : string2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid IP address pattern: " + string, illegalArgumentException);
            }
        }

        public boolean match(String string) {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid IP address: " + string);
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                boolean bl = true;
                for (int i = 0; i < 4; ++i) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Invalid IP address: " + string);
                    }
                    if (!(bl &= this._octets[i].match(stringTokenizer.nextToken()))) break;
                }
                return bl;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid IP address: " + string, illegalArgumentException);
            }
        }
    }
}

