/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class HttpCookieStore
implements CookieStore {
    private final CookieStore delegate = new CookieManager().getCookieStore();

    @Override
    public void add(URI uRI, HttpCookie httpCookie) {
        this.delegate.add(uRI, httpCookie);
    }

    @Override
    public List<HttpCookie> get(URI uRI) {
        return this.delegate.get(uRI);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.delegate.getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.delegate.getURIs();
    }

    @Override
    public boolean remove(URI uRI, HttpCookie httpCookie) {
        return this.delegate.remove(uRI, httpCookie);
    }

    @Override
    public boolean removeAll() {
        return this.delegate.removeAll();
    }

    public static class Empty
    implements CookieStore {
        @Override
        public void add(URI uRI, HttpCookie httpCookie) {
        }

        @Override
        public List<HttpCookie> get(URI uRI) {
            return Collections.emptyList();
        }

        @Override
        public List<HttpCookie> getCookies() {
            return Collections.emptyList();
        }

        @Override
        public List<URI> getURIs() {
            return Collections.emptyList();
        }

        @Override
        public boolean remove(URI uRI, HttpCookie httpCookie) {
            return false;
        }

        @Override
        public boolean removeAll() {
            return false;
        }
    }
}

