/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DecoratedObjectFactory
implements Iterable<Decorator> {
    private static final Logger LOG = Log.getLogger(DecoratedObjectFactory.class);
    public static final String ATTR = DecoratedObjectFactory.class.getName();
    private List<Decorator> decorators = new ArrayList<Decorator>();

    public void addDecorator(Decorator decorator) {
        LOG.debug("Adding Decorator: {}", decorator);
        this.decorators.add(decorator);
    }

    public void clear() {
        this.decorators.clear();
    }

    public <T> T createInstance(Class<T> clazz) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating Instance: " + clazz, new Object[0]);
        }
        T t = clazz.newInstance();
        return this.decorate(t);
    }

    public <T> T decorate(T t) {
        T t2 = t;
        for (int i = this.decorators.size() - 1; i >= 0; --i) {
            t2 = this.decorators.get(i).decorate(t2);
        }
        return t2;
    }

    public void destroy(Object object) {
        for (Decorator decorator : this.decorators) {
            decorator.destroy(object);
        }
    }

    public List<Decorator> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    @Override
    public Iterator<Decorator> iterator() {
        return this.decorators.iterator();
    }

    public void setDecorators(List<? extends Decorator> list) {
        this.decorators.clear();
        if (list != null) {
            this.decorators.addAll(list);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName()).append("[decorators=");
        stringBuilder.append(Integer.toString(this.decorators.size()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

