/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateCache {
    public static final String DEFAULT_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private final String _formatString;
    private final String _tzFormatString;
    private final SimpleDateFormat _tzFormat;
    private final Locale _locale;
    private volatile Tick _tick;

    public DateCache() {
        this(DEFAULT_FORMAT);
    }

    public DateCache(String string) {
        this(string, null, TimeZone.getDefault());
    }

    public DateCache(String string, Locale locale) {
        this(string, locale, TimeZone.getDefault());
    }

    public DateCache(String string, Locale locale, String string2) {
        this(string, locale, TimeZone.getTimeZone(string2));
    }

    public DateCache(String string, Locale locale, TimeZone timeZone) {
        this._formatString = string;
        this._locale = locale;
        int n = this._formatString.indexOf("ZZZ");
        if (n >= 0) {
            String string2 = this._formatString.substring(0, n);
            String string3 = this._formatString.substring(n + 3);
            int n2 = timeZone.getRawOffset();
            StringBuilder stringBuilder = new StringBuilder(this._formatString.length() + 10);
            stringBuilder.append(string2);
            stringBuilder.append("'");
            if (n2 >= 0) {
                stringBuilder.append('+');
            } else {
                n2 = -n2;
                stringBuilder.append('-');
            }
            int n3 = n2 / 60000;
            int n4 = n3 / 60;
            int n5 = n3 % 60;
            if (n4 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n4);
            if (n5 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n5);
            stringBuilder.append('\'');
            stringBuilder.append(string3);
            this._tzFormatString = stringBuilder.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this._tzFormat = this._locale != null ? new SimpleDateFormat(this._tzFormatString, this._locale) : new SimpleDateFormat(this._tzFormatString);
        this._tzFormat.setTimeZone(timeZone);
        this._tick = null;
    }

    public TimeZone getTimeZone() {
        return this._tzFormat.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        long l = date.getTime() / 1000L;
        Tick tick = this._tick;
        if (tick == null || l != tick._seconds) {
            DateCache dateCache = this;
            synchronized (dateCache) {
                return this._tzFormat.format(date);
            }
        }
        return tick._string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long l) {
        long l2 = l / 1000L;
        Tick tick = this._tick;
        if (tick == null || l2 != tick._seconds) {
            Date date = new Date(l);
            DateCache dateCache = this;
            synchronized (dateCache) {
                return this._tzFormat.format(date);
            }
        }
        return tick._string;
    }

    public String formatNow(long l) {
        long l2 = l / 1000L;
        Tick tick = this._tick;
        if (tick != null && tick._seconds == l2) {
            return tick._string;
        }
        return this.formatTick((long)l)._string;
    }

    public String now() {
        return this.formatNow(System.currentTimeMillis());
    }

    public Tick tick() {
        return this.formatTick(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Tick formatTick(long l) {
        long l2 = l / 1000L;
        DateCache dateCache = this;
        synchronized (dateCache) {
            if (this._tick == null || this._tick._seconds != l2) {
                String string = this._tzFormat.format(new Date(l));
                this._tick = new Tick(l2, string);
                return this._tick;
            }
            return this._tick;
        }
    }

    public String getFormatString() {
        return this._formatString;
    }

    public static class Tick {
        final long _seconds;
        final String _string;

        public Tick(long l, String string) {
            this._seconds = l;
            this._string = string;
        }
    }
}

