/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.Callback;

public class CountingCallback
implements Callback {
    private final Callback callback;
    private final AtomicInteger count;

    public CountingCallback(Callback callback, int n) {
        this.callback = callback;
        this.count = new AtomicInteger(n);
    }

    @Override
    public void succeeded() {
        int n;
        do {
            if ((n = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(n, n - 1));
        if (n == 1) {
            this.callback.succeeded();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        int n;
        do {
            if ((n = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(n, 0));
        this.callback.failed(throwable);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

