/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.eclipse.jetty.util.MemoryUtils;

public class ConcurrentArrayQueue<T>
extends AbstractQueue<T> {
    public static final int DEFAULT_BLOCK_SIZE = 512;
    public static final Object REMOVED_ELEMENT = new Object(){

        public String toString() {
            return "X";
        }
    };
    private static final int HEAD_OFFSET = MemoryUtils.getIntegersPerCacheLine() - 1;
    private static final int TAIL_OFFSET = MemoryUtils.getIntegersPerCacheLine() * 2 - 1;
    private final AtomicReferenceArray<Block<T>> _blocks = new AtomicReferenceArray(TAIL_OFFSET + 1);
    private final int _blockSize;

    public ConcurrentArrayQueue() {
        this(512);
    }

    public ConcurrentArrayQueue(int n) {
        this._blockSize = n;
        Block<T> block = this.newBlock();
        this._blocks.set(HEAD_OFFSET, block);
        this._blocks.set(TAIL_OFFSET, block);
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    protected Block<T> getHeadBlock() {
        return this._blocks.get(HEAD_OFFSET);
    }

    protected Block<T> getTailBlock() {
        return this._blocks.get(TAIL_OFFSET);
    }

    @Override
    public boolean offer(T t) {
        Block<T> block;
        t = Objects.requireNonNull(t);
        Block<T> block2 = block = this.getTailBlock();
        int n = block2.tail();
        while (true) {
            if (n == this.getBlockSize()) {
                Block<T> block3 = block2.next();
                block2 = block3 == null ? (block2.link(block3 = this.newBlock()) ? block3 : block2.next()) : block3;
                n = block2.tail();
                continue;
            }
            if (block2.peek(n) == null) {
                if (block2.store(n, t)) break;
                ++n;
                continue;
            }
            ++n;
        }
        this.updateTailBlock(block, block2);
        return true;
    }

    private void updateTailBlock(Block<T> block, Block<T> block2) {
        if (block != block2) {
            this.casTailBlock(block, block2);
        }
    }

    protected boolean casTailBlock(Block<T> block, Block<T> block2) {
        return this._blocks.compareAndSet(TAIL_OFFSET, block, block2);
    }

    @Override
    public T poll() {
        Block<T> block;
        Block<T> block2 = block = this.getHeadBlock();
        int n = block2.head();
        Block<T> block3 = null;
        while (true) {
            Block<T> block4;
            if (n == this.getBlockSize()) {
                block4 = block2.next();
                if (block4 == null) break;
                block2 = block4;
                n = block2.head();
                continue;
            }
            block4 = block2.peek(n);
            if (block4 == REMOVED_ELEMENT) {
                ++n;
                continue;
            }
            block3 = block4;
            if (block3 == null || block2.remove(n, block3, true)) break;
            ++n;
        }
        this.updateHeadBlock(block, block2);
        return (T)block3;
    }

    private void updateHeadBlock(Block<T> block, Block<T> block2) {
        if (block != block2) {
            this.casHeadBlock(block, block2);
        }
    }

    protected boolean casHeadBlock(Block<T> block, Block<T> block2) {
        return this._blocks.compareAndSet(HEAD_OFFSET, block, block2);
    }

    @Override
    public T peek() {
        Block<T> block;
        Block<T> block2 = this.getHeadBlock();
        int n = block2.head();
        while (true) {
            if (n == this.getBlockSize()) {
                block = block2.next();
                if (block == null) {
                    return null;
                }
                block2 = block;
                n = block2.head();
                continue;
            }
            block = block2.peek(n);
            if (block != REMOVED_ELEMENT) break;
            ++n;
        }
        return (T)block;
    }

    @Override
    public boolean remove(Object object) {
        Block<T> block = this.getHeadBlock();
        int n = block.head();
        boolean bl = false;
        while (true) {
            Block<T> block2;
            if (n == this.getBlockSize()) {
                block2 = block.next();
                if (block2 == null) break;
                block = block2;
                n = block.head();
                continue;
            }
            block2 = block.peek(n);
            if (block2 == REMOVED_ELEMENT) {
                ++n;
                continue;
            }
            if (block2 == null) break;
            if (block2.equals(object)) {
                if (block.remove(n, object, false)) {
                    bl = true;
                    break;
                }
                ++n;
                continue;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public Iterator<T> iterator() {
        final ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (Block<T> block = this.getHeadBlock(); block != null; block = block.next()) {
            Object[] objectArray = block.arrayCopy();
            arrayList.add(objectArray);
        }
        return new Iterator<T>(){
            private int blockIndex;
            private int index;

            @Override
            public boolean hasNext() {
                while (this.blockIndex != arrayList.size()) {
                    Object object = ((Object[])arrayList.get(this.blockIndex))[this.index];
                    if (object == null) {
                        return false;
                    }
                    if (object != REMOVED_ELEMENT) {
                        return true;
                    }
                    this.advance();
                }
                return false;
            }

            @Override
            public T next() {
                Object object;
                do {
                    if (this.blockIndex == arrayList.size()) {
                        throw new NoSuchElementException();
                    }
                    object = ((Object[])arrayList.get(this.blockIndex))[this.index];
                    if (object == null) {
                        throw new NoSuchElementException();
                    }
                    this.advance();
                } while (object == REMOVED_ELEMENT);
                Object object2 = object;
                return object2;
            }

            private void advance() {
                if (++this.index == ConcurrentArrayQueue.this.getBlockSize()) {
                    this.index = 0;
                    ++this.blockIndex;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        Block<T> block = this.getHeadBlock();
        int n = block.head();
        int n2 = 0;
        while (true) {
            Block<T> block2;
            if (n == this.getBlockSize()) {
                block2 = block.next();
                if (block2 == null) break;
                block = block2;
                n = block.head();
                continue;
            }
            block2 = block.peek(n);
            if (block2 == REMOVED_ELEMENT) {
                ++n;
                continue;
            }
            if (block2 == null) break;
            ++n2;
            ++n;
        }
        return n2;
    }

    protected Block<T> newBlock() {
        return new Block(this.getBlockSize());
    }

    protected int getBlockCount() {
        int n = 0;
        for (Block<T> block = this.getHeadBlock(); block != null; block = block.next()) {
            ++n;
        }
        return n;
    }

    static /* synthetic */ int access$000() {
        return TAIL_OFFSET;
    }

    protected static final class Block<E> {
        private static final int headOffset = MemoryUtils.getIntegersPerCacheLine() - 1;
        private static final int tailOffset = MemoryUtils.getIntegersPerCacheLine() * 2 - 1;
        private final AtomicReferenceArray<Object> elements;
        private final AtomicReference<Block<E>> next = new AtomicReference();
        private final AtomicIntegerArray indexes = new AtomicIntegerArray(ConcurrentArrayQueue.access$000() + 1);

        protected Block(int n) {
            this.elements = new AtomicReferenceArray(n);
        }

        public E peek(int n) {
            return (E)this.elements.get(n);
        }

        public boolean store(int n, E e) {
            boolean bl = this.elements.compareAndSet(n, null, e);
            if (bl) {
                this.indexes.incrementAndGet(tailOffset);
            }
            return bl;
        }

        public boolean remove(int n, Object object, boolean bl) {
            boolean bl2 = this.elements.compareAndSet(n, object, REMOVED_ELEMENT);
            if (bl2 && bl) {
                this.indexes.incrementAndGet(headOffset);
            }
            return bl2;
        }

        public Block<E> next() {
            return this.next.get();
        }

        public boolean link(Block<E> block) {
            return this.next.compareAndSet(null, block);
        }

        public int head() {
            return this.indexes.get(headOffset);
        }

        public int tail() {
            return this.indexes.get(tailOffset);
        }

        public Object[] arrayCopy() {
            Object[] objectArray = new Object[this.elements.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.elements.get(i);
            }
            return objectArray;
        }
    }
}

