/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ClassLoadingObjectInputStream
extends ObjectInputStream {
    public ClassLoadingObjectInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ClassLoadingObjectInputStream() {
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
        try {
            return Class.forName(objectStreamClass.getName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(objectStreamClass);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz = Class.forName(stringArray[i], false, classLoader);
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl) {
                    if (classLoader2 != clazz.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            return Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }
}

