/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class BufferUtil {
    static final int TEMP_BUFFER_SIZE = 4096;
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    static final Field fdMappedByteBuffer;
    private static final int[] decDivisors;
    private static final int[] hexDivisors;
    private static final long[] decDivisorsL;

    public static ByteBuffer allocate(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.limit(0);
        return byteBuffer;
    }

    public static ByteBuffer allocateDirect(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.limit(0);
        return byteBuffer;
    }

    public static void clear(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byteBuffer.position(0);
            byteBuffer.limit(0);
        }
    }

    public static void clearToFill(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
        }
    }

    public static int flipToFill(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        if (n2 == (n = byteBuffer.limit())) {
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            return 0;
        }
        int n3 = byteBuffer.capacity();
        if (n == n3) {
            byteBuffer.compact();
            return 0;
        }
        byteBuffer.position(n);
        byteBuffer.limit(n3);
        return n2;
    }

    public static void flipToFlush(ByteBuffer byteBuffer, int n) {
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n);
    }

    public static byte[] toArray(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            return Arrays.copyOfRange(byArray, n, n + byteBuffer.remaining());
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.slice().get(byArray);
        return byArray;
    }

    public static boolean isEmpty(ByteBuffer byteBuffer) {
        return byteBuffer == null || byteBuffer.remaining() == 0;
    }

    public static boolean hasContent(ByteBuffer byteBuffer) {
        return byteBuffer != null && byteBuffer.remaining() > 0;
    }

    public static boolean isFull(ByteBuffer byteBuffer) {
        return byteBuffer != null && byteBuffer.limit() == byteBuffer.capacity();
    }

    public static int length(ByteBuffer byteBuffer) {
        return byteBuffer == null ? 0 : byteBuffer.remaining();
    }

    public static int space(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return 0;
        }
        return byteBuffer.capacity() - byteBuffer.limit();
    }

    public static boolean compact(ByteBuffer byteBuffer) {
        if (byteBuffer.position() == 0) {
            return false;
        }
        boolean bl = byteBuffer.limit() == byteBuffer.capacity();
        byteBuffer.compact().flip();
        return bl && byteBuffer.limit() < byteBuffer.capacity();
    }

    public static int put(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n;
        int n2 = byteBuffer.remaining();
        if (n2 > 0) {
            if (n2 <= byteBuffer2.remaining()) {
                byteBuffer2.put(byteBuffer);
                n = n2;
                byteBuffer.position(byteBuffer.limit());
            } else if (byteBuffer.hasArray()) {
                n = byteBuffer2.remaining();
                byteBuffer2.put(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
                byteBuffer.position(byteBuffer.position() + n);
            } else {
                n = byteBuffer2.remaining();
                ByteBuffer byteBuffer3 = byteBuffer.slice();
                byteBuffer3.limit(n);
                byteBuffer2.put(byteBuffer3);
                byteBuffer.position(byteBuffer.position() + n);
            }
        } else {
            n = 0;
        }
        return n;
    }

    public static int flipPutFlip(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return BufferUtil.append(byteBuffer2, byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        int n3 = BufferUtil.flipToFill(byteBuffer);
        try {
            byteBuffer.put(byArray, n, n2);
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n3);
        }
    }

    public static void append(ByteBuffer byteBuffer, byte by) {
        int n = BufferUtil.flipToFill(byteBuffer);
        try {
            byteBuffer.put(by);
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int append(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = BufferUtil.flipToFill(byteBuffer);
        try {
            int n2 = BufferUtil.put(byteBuffer2, byteBuffer);
            return n2;
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fill(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        int n3 = BufferUtil.flipToFill(byteBuffer);
        try {
            int n4 = byteBuffer.remaining();
            int n5 = n4 < n2 ? n4 : n2;
            byteBuffer.put(byArray, n, n5);
            int n6 = n5;
            return n6;
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n3);
        }
    }

    public static void readFrom(File file, ByteBuffer byteBuffer) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            FileChannel fileChannel = randomAccessFile.getChannel();
            for (long i = randomAccessFile.length(); i > 0L && byteBuffer.hasRemaining(); i -= (long)fileChannel.read(byteBuffer)) {
            }
        }
    }

    public static void readFrom(InputStream inputStream, int n, ByteBuffer byteBuffer) {
        int n2;
        ByteBuffer byteBuffer2 = BufferUtil.allocate(8192);
        while (n > 0 && byteBuffer.hasRemaining() && (n2 = inputStream.read(byteBuffer2.array(), 0, 8192)) >= 0) {
            byteBuffer2.position(0);
            byteBuffer2.limit(n2);
            byteBuffer.put(byteBuffer2);
        }
    }

    public static void writeTo(ByteBuffer byteBuffer, OutputStream outputStream) {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[4096];
            while (byteBuffer.hasRemaining()) {
                int n = Math.min(byteBuffer.remaining(), 4096);
                byteBuffer.get(byArray, 0, n);
                outputStream.write(byArray, 0, n);
            }
        }
    }

    public static String toString(ByteBuffer byteBuffer) {
        return BufferUtil.toString(byteBuffer, StandardCharsets.ISO_8859_1);
    }

    public static String toUTF8String(ByteBuffer byteBuffer) {
        return BufferUtil.toString(byteBuffer, StandardCharsets.UTF_8);
    }

    public static String toString(ByteBuffer byteBuffer, Charset charset) {
        byte[] byArray;
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray2 = byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
        if (byArray == null) {
            byte[] byArray3 = new byte[byteBuffer.remaining()];
            byteBuffer.slice().get(byArray3);
            return new String(byArray3, 0, byArray3.length, charset);
        }
        return new String(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), charset);
    }

    public static String toString(ByteBuffer byteBuffer, int n, int n2, Charset charset) {
        byte[] byArray;
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray2 = byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
        if (byArray == null) {
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.position(n);
            byteBuffer2.limit(n + n2);
            byte[] byArray3 = new byte[n2];
            byteBuffer2.get(byArray3);
            return new String(byArray3, 0, byArray3.length, charset);
        }
        return new String(byArray, byteBuffer.arrayOffset() + n, n2, charset);
    }

    public static int toInt(ByteBuffer byteBuffer) {
        return BufferUtil.toInt(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    public static int toInt(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = n + n2;
        if (n2 <= 0) {
            throw new NumberFormatException(BufferUtil.toString(byteBuffer, n, n2, StandardCharsets.UTF_8));
        }
        for (int i = n; i < n4; ++i) {
            byte by = byteBuffer.get(i);
            if (by <= 32) {
                if (!bl) continue;
                break;
            }
            if (by >= 48 && by <= 57) {
                n3 = n3 * 10 + (by - 48);
                bl = true;
                continue;
            }
            if (by != 45 || bl) break;
            bl2 = true;
        }
        if (bl) {
            return bl2 ? -n3 : n3;
        }
        throw new NumberFormatException(BufferUtil.toString(byteBuffer));
    }

    public static int takeInt(ByteBuffer byteBuffer) {
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = byteBuffer.position(); n < byteBuffer.limit(); ++n) {
            byte by = byteBuffer.get(n);
            if (by <= 32) {
                if (!bl) continue;
                break;
            }
            if (by >= 48 && by <= 57) {
                n2 = n2 * 10 + (by - 48);
                bl = true;
                continue;
            }
            if (by != 45 || bl) break;
            bl2 = true;
        }
        if (bl) {
            byteBuffer.position(n);
            return bl2 ? -n2 : n2;
        }
        throw new NumberFormatException(BufferUtil.toString(byteBuffer));
    }

    public static long toLong(ByteBuffer byteBuffer) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            byte by = byteBuffer.get(i);
            if (by <= 32) {
                if (!bl) continue;
                break;
            }
            if (by >= 48 && by <= 57) {
                l = l * 10L + (long)(by - 48);
                bl = true;
                continue;
            }
            if (by != 45 || bl) break;
            bl2 = true;
        }
        if (bl) {
            return bl2 ? -l : l;
        }
        throw new NumberFormatException(BufferUtil.toString(byteBuffer));
    }

    public static void putHexInt(ByteBuffer byteBuffer, int n) {
        if (n < 0) {
            byteBuffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                byteBuffer.put((byte)56);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                byteBuffer.put((byte)48);
                return;
            }
            n = -n;
        }
        if (n < 16) {
            byteBuffer.put(DIGIT[n]);
        } else {
            boolean bl = false;
            for (int n2 : hexDivisors) {
                if (n < n2) {
                    if (!bl) continue;
                    byteBuffer.put((byte)48);
                    continue;
                }
                bl = true;
                int n3 = n / n2;
                byteBuffer.put(DIGIT[n3]);
                n -= n3 * n2;
            }
        }
    }

    public static void putDecInt(ByteBuffer byteBuffer, int n) {
        if (n < 0) {
            byteBuffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                byteBuffer.put((byte)50);
                n = 147483648;
            } else {
                n = -n;
            }
        }
        if (n < 10) {
            byteBuffer.put(DIGIT[n]);
        } else {
            boolean bl = false;
            for (int n2 : decDivisors) {
                if (n < n2) {
                    if (!bl) continue;
                    byteBuffer.put((byte)48);
                    continue;
                }
                bl = true;
                int n3 = n / n2;
                byteBuffer.put(DIGIT[n3]);
                n -= n3 * n2;
            }
        }
    }

    public static void putDecLong(ByteBuffer byteBuffer, long l) {
        if (l < 0L) {
            byteBuffer.put((byte)45);
            if (l == Long.MIN_VALUE) {
                byteBuffer.put((byte)57);
                l = 223372036854775808L;
            } else {
                l = -l;
            }
        }
        if (l < 10L) {
            byteBuffer.put(DIGIT[(int)l]);
        } else {
            boolean bl = false;
            for (long l2 : decDivisorsL) {
                if (l < l2) {
                    if (!bl) continue;
                    byteBuffer.put((byte)48);
                    continue;
                }
                bl = true;
                long l3 = l / l2;
                byteBuffer.put(DIGIT[(int)l3]);
                l -= l3 * l2;
            }
        }
    }

    public static ByteBuffer toBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        BufferUtil.putDecInt(byteBuffer, n);
        return byteBuffer;
    }

    public static ByteBuffer toBuffer(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        BufferUtil.putDecLong(byteBuffer, l);
        return byteBuffer;
    }

    public static ByteBuffer toBuffer(String string) {
        return BufferUtil.toBuffer(string, StandardCharsets.ISO_8859_1);
    }

    public static ByteBuffer toBuffer(String string, Charset charset) {
        if (string == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(string.getBytes(charset));
    }

    public static ByteBuffer toBuffer(byte[] byArray) {
        if (byArray == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(byArray, 0, byArray.length);
    }

    public static ByteBuffer toBuffer(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(byArray, n, n2);
    }

    public static ByteBuffer toDirectBuffer(String string) {
        return BufferUtil.toDirectBuffer(string, StandardCharsets.ISO_8859_1);
    }

    public static ByteBuffer toDirectBuffer(String string, Charset charset) {
        if (string == null) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = string.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer toMappedBuffer(File file) {
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            return mappedByteBuffer;
        }
    }

    public static boolean isMappedBuffer(ByteBuffer byteBuffer) {
        if (!(byteBuffer instanceof MappedByteBuffer)) {
            return false;
        }
        MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)byteBuffer;
        if (fdMappedByteBuffer != null) {
            try {
                if (fdMappedByteBuffer.get(mappedByteBuffer) instanceof FileDescriptor) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static ByteBuffer toBuffer(Resource resource, boolean bl) {
        int n = (int)resource.length();
        if (n < 0) {
            throw new IllegalArgumentException("invalid resource: " + String.valueOf(resource) + " len=" + n);
        }
        ByteBuffer byteBuffer = bl ? BufferUtil.allocateDirect(n) : BufferUtil.allocate(n);
        int n2 = BufferUtil.flipToFill(byteBuffer);
        if (resource.getFile() != null) {
            BufferUtil.readFrom(resource.getFile(), byteBuffer);
        } else {
            try (InputStream inputStream = resource.getInputStream();){
                BufferUtil.readFrom(inputStream, n, byteBuffer);
            }
        }
        BufferUtil.flipToFlush(byteBuffer, n2);
        return byteBuffer;
    }

    public static String toSummaryString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[p=");
        stringBuilder.append(byteBuffer.position());
        stringBuilder.append(",l=");
        stringBuilder.append(byteBuffer.limit());
        stringBuilder.append(",c=");
        stringBuilder.append(byteBuffer.capacity());
        stringBuilder.append(",r=");
        stringBuilder.append(byteBuffer.remaining());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toDetailString(ByteBuffer[] byteBufferArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < byteBufferArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(BufferUtil.toDetailString(byteBufferArray[i]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static void idString(ByteBuffer byteBuffer, StringBuilder stringBuilder) {
        stringBuilder.append(byteBuffer.getClass().getSimpleName());
        stringBuilder.append("@");
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 4) {
            stringBuilder.append('T');
            byte[] byArray = byteBuffer.array();
            TypeUtil.toHex(byArray[0], (Appendable)stringBuilder);
            TypeUtil.toHex(byArray[1], (Appendable)stringBuilder);
            TypeUtil.toHex(byArray[2], (Appendable)stringBuilder);
            TypeUtil.toHex(byArray[3], (Appendable)stringBuilder);
        } else {
            stringBuilder.append(Integer.toHexString(System.identityHashCode(byteBuffer)));
        }
    }

    public static String toIDString(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferUtil.idString(byteBuffer, stringBuilder);
        return stringBuilder.toString();
    }

    public static String toDetailString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferUtil.idString(byteBuffer, stringBuilder);
        stringBuilder.append("[p=");
        stringBuilder.append(byteBuffer.position());
        stringBuilder.append(",l=");
        stringBuilder.append(byteBuffer.limit());
        stringBuilder.append(",c=");
        stringBuilder.append(byteBuffer.capacity());
        stringBuilder.append(",r=");
        stringBuilder.append(byteBuffer.remaining());
        stringBuilder.append("]={");
        BufferUtil.appendDebugString(stringBuilder, byteBuffer);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static void appendDebugString(StringBuilder stringBuilder, ByteBuffer byteBuffer) {
        try {
            int n;
            for (n = 0; n < byteBuffer.position(); ++n) {
                BufferUtil.appendContentChar(stringBuilder, byteBuffer.get(n));
                if (n != 16 || byteBuffer.position() <= 32) continue;
                stringBuilder.append("...");
                n = byteBuffer.position() - 16;
            }
            stringBuilder.append("<<<");
            for (n = byteBuffer.position(); n < byteBuffer.limit(); ++n) {
                BufferUtil.appendContentChar(stringBuilder, byteBuffer.get(n));
                if (n != byteBuffer.position() + 16 || byteBuffer.limit() <= byteBuffer.position() + 32) continue;
                stringBuilder.append("...");
                n = byteBuffer.limit() - 16;
            }
            stringBuilder.append(">>>");
            n = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.capacity());
            for (int i = n; i < byteBuffer.capacity(); ++i) {
                BufferUtil.appendContentChar(stringBuilder, byteBuffer.get(i));
                if (i != n + 16 || byteBuffer.capacity() <= n + 32) continue;
                stringBuilder.append("...");
                i = byteBuffer.capacity() - 16;
            }
            byteBuffer.limit(n);
        }
        catch (Throwable throwable) {
            Log.getRootLogger().ignore(throwable);
            stringBuilder.append("!!concurrent mod!!");
        }
    }

    private static void appendContentChar(StringBuilder stringBuilder, byte by) {
        if (by == 92) {
            stringBuilder.append("\\\\");
        } else if (by >= 32) {
            stringBuilder.append((char)by);
        } else if (by == 13) {
            stringBuilder.append("\\r");
        } else if (by == 10) {
            stringBuilder.append("\\n");
        } else if (by == 9) {
            stringBuilder.append("\\t");
        } else {
            stringBuilder.append("\\x").append(TypeUtil.toHexString(by));
        }
    }

    public static String toHexSummary(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("b[").append(byteBuffer.remaining()).append("]=");
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            TypeUtil.toHex(byteBuffer.get(i), (Appendable)stringBuilder);
            if (i != byteBuffer.position() + 24 || byteBuffer.limit() <= byteBuffer.position() + 32) continue;
            stringBuilder.append("...");
            i = byteBuffer.limit() - 8;
        }
        return stringBuilder.toString();
    }

    public static void putCRLF(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)13);
        byteBuffer.put((byte)10);
    }

    public static boolean isPrefix(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.remaining() > byteBuffer2.remaining()) {
            return false;
        }
        int n = byteBuffer2.position();
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            if (byteBuffer.get(i) == byteBuffer2.get(n++)) continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            return BufferUtil.allocate(n);
        }
        if (byteBuffer.capacity() >= n) {
            return byteBuffer;
        }
        if (byteBuffer.hasArray()) {
            return ByteBuffer.wrap(Arrays.copyOfRange(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.arrayOffset() + n), byteBuffer.position(), byteBuffer.remaining());
        }
        throw new UnsupportedOperationException();
    }

    static {
        Field field = null;
        try {
            field = MappedByteBuffer.class.getDeclaredField("fd");
            field.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        fdMappedByteBuffer = field;
        decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
        hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
        decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};
    }
}

