/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class BlockingCallback
implements Callback.NonBlocking {
    private static final Logger LOG = Log.getLogger(BlockingCallback.class);
    private static Throwable SUCCEEDED = new Throwable(){

        @Override
        public String toString() {
            return "SUCCEEDED";
        }
    };
    private final CountDownLatch _latch = new CountDownLatch(1);
    private final AtomicReference<Throwable> _state = new AtomicReference();

    @Override
    public void succeeded() {
        if (this._state.compareAndSet(null, SUCCEEDED)) {
            this._latch.countDown();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this._state.compareAndSet(null, throwable)) {
            this._latch.countDown();
        }
    }

    public void block() {
        try {
            this._latch.await();
            Throwable throwable = this._state.get();
            if (throwable == SUCCEEDED) {
                return;
            }
            try {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof CancellationException) {
                    throw (CancellationException)throwable;
                }
                throw new IOException(throwable);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(){
                    {
                        this.initCause(interruptedException);
                    }
                };
            }
        }
        finally {
            this._state.set(null);
        }
    }

    public String toString() {
        return String.format("%s@%x{%s}", BlockingCallback.class.getSimpleName(), this.hashCode(), this._state.get());
    }
}

