/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class B64Code {
    private static final char __pad = '=';
    private static final char[] __rfc1421alphabet;
    private static final byte[] __rfc1421nibbles;
    private static final char[] __rfc4648urlAlphabet;
    private static final byte[] __rfc4648urlNibbles;

    private B64Code() {
    }

    public static String encode(String string) {
        return B64Code.encode(string, (Charset)null);
    }

    public static String encode(String string, String string2) {
        byte[] byArray = string2 == null ? string.getBytes(StandardCharsets.ISO_8859_1) : string.getBytes(Charset.forName(string2));
        return new String(B64Code.encode(byArray));
    }

    public static String encode(String string, Charset charset) {
        byte[] byArray = string.getBytes(charset == null ? StandardCharsets.ISO_8859_1 : charset);
        return new String(B64Code.encode(byArray));
    }

    public static char[] encode(byte[] byArray) {
        byte by;
        byte by2;
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = (n + 2) / 3 * 4;
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = n / 3 * 3;
        while (n4 < n5) {
            by2 = byArray[n4++];
            by = byArray[n4++];
            byte by3 = byArray[n4++];
            cArray[n3++] = __rfc1421alphabet[by2 >>> 2 & 0x3F];
            cArray[n3++] = __rfc1421alphabet[by2 << 4 & 0x3F | by >>> 4 & 0xF];
            cArray[n3++] = __rfc1421alphabet[by << 2 & 0x3F | by3 >>> 6 & 3];
            cArray[n3++] = __rfc1421alphabet[by3 & 0x3F];
        }
        if (n != n4) {
            switch (n % 3) {
                case 2: {
                    by2 = byArray[n4++];
                    by = byArray[n4++];
                    cArray[n3++] = __rfc1421alphabet[by2 >>> 2 & 0x3F];
                    cArray[n3++] = __rfc1421alphabet[by2 << 4 & 0x3F | by >>> 4 & 0xF];
                    cArray[n3++] = __rfc1421alphabet[by << 2 & 0x3F];
                    cArray[n3++] = 61;
                    break;
                }
                case 1: {
                    by2 = byArray[n4++];
                    cArray[n3++] = __rfc1421alphabet[by2 >>> 2 & 0x3F];
                    cArray[n3++] = __rfc1421alphabet[by2 << 4 & 0x3F];
                    cArray[n3++] = 61;
                    cArray[n3++] = 61;
                    break;
                }
            }
        }
        return cArray;
    }

    public static char[] encode(byte[] byArray, boolean bl) {
        byte by;
        byte by2;
        if (byArray == null) {
            return null;
        }
        if (!bl) {
            return B64Code.encode(byArray);
        }
        int n = byArray.length;
        int n2 = (n + 2) / 3 * 4;
        n2 += 2 + 2 * (n2 / 76);
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = n / 3 * 3;
        int n6 = 0;
        while (n4 < n5) {
            by2 = byArray[n4++];
            by = byArray[n4++];
            byte by3 = byArray[n4++];
            cArray[n3++] = __rfc1421alphabet[by2 >>> 2 & 0x3F];
            cArray[n3++] = __rfc1421alphabet[by2 << 4 & 0x3F | by >>> 4 & 0xF];
            cArray[n3++] = __rfc1421alphabet[by << 2 & 0x3F | by3 >>> 6 & 3];
            cArray[n3++] = __rfc1421alphabet[by3 & 0x3F];
            if ((n6 += 4) % 76 != 0) continue;
            cArray[n3++] = 13;
            cArray[n3++] = 10;
        }
        if (n != n4) {
            switch (n % 3) {
                case 2: {
                    by2 = byArray[n4++];
                    by = byArray[n4++];
                    cArray[n3++] = __rfc1421alphabet[by2 >>> 2 & 0x3F];
                    cArray[n3++] = __rfc1421alphabet[by2 << 4 & 0x3F | by >>> 4 & 0xF];
                    cArray[n3++] = __rfc1421alphabet[by << 2 & 0x3F];
                    cArray[n3++] = 61;
                    break;
                }
                case 1: {
                    by2 = byArray[n4++];
                    cArray[n3++] = __rfc1421alphabet[by2 >>> 2 & 0x3F];
                    cArray[n3++] = __rfc1421alphabet[by2 << 4 & 0x3F];
                    cArray[n3++] = 61;
                    cArray[n3++] = 61;
                    break;
                }
            }
        }
        cArray[n3++] = 13;
        cArray[n3++] = 10;
        return cArray;
    }

    public static String decode(String string, String string2) {
        byte[] byArray = B64Code.decode(string);
        if (string2 == null) {
            return new String(byArray);
        }
        return new String(byArray, Charset.forName(string2));
    }

    public static String decode(String string, Charset charset) {
        byte[] byArray = B64Code.decode(string);
        if (charset == null) {
            return new String(byArray);
        }
        return new String(byArray, charset);
    }

    public static byte[] decode(char[] cArray) {
        int n;
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        if (n2 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        for (n = n2 - 1; n >= 0 && cArray[n] == '='; --n) {
        }
        if (n < 0) {
            return new byte[0];
        }
        int n3 = (n + 1) * 3 / 4;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 / 3 * 3;
        try {
            byte by;
            byte by2;
            byte by3;
            while (n4 < n6) {
                by3 = __rfc1421nibbles[cArray[n5++]];
                by2 = __rfc1421nibbles[cArray[n5++]];
                by = __rfc1421nibbles[cArray[n5++]];
                byte by4 = __rfc1421nibbles[cArray[n5++]];
                if (by3 < 0 || by2 < 0 || by < 0 || by4 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                byArray[n4++] = (byte)(by3 << 2 | by2 >>> 4);
                byArray[n4++] = (byte)(by2 << 4 | by >>> 2);
                byArray[n4++] = (byte)(by << 6 | by4);
            }
            if (n3 != n4) {
                switch (n3 % 3) {
                    case 2: {
                        by3 = __rfc1421nibbles[cArray[n5++]];
                        by2 = __rfc1421nibbles[cArray[n5++]];
                        by = __rfc1421nibbles[cArray[n5++]];
                        if (by3 < 0 || by2 < 0 || by < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by3 << 2 | by2 >>> 4);
                        byArray[n4++] = (byte)(by2 << 4 | by >>> 2);
                        break;
                    }
                    case 1: {
                        by3 = __rfc1421nibbles[cArray[n5++]];
                        by2 = __rfc1421nibbles[cArray[n5++]];
                        if (by3 < 0 || by2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by3 << 2 | by2 >>> 4);
                        break;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("char " + n5 + " was not B64 encoded");
        }
        return byArray;
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4 * string.length() / 3);
        B64Code.decode(string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void decode(String string, ByteArrayOutputStream byteArrayOutputStream) {
        char c;
        if (string == null) {
            return;
        }
        if (byteArrayOutputStream == null) {
            throw new IllegalArgumentException("No outputstream for decoded bytes");
        }
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n < string.length() && (c = string.charAt(n++)) != '=') {
            if (Character.isWhitespace(c)) continue;
            byte by = __rfc1421nibbles[c];
            if (by < 0) {
                throw new IllegalArgumentException("Not B64 encoded");
            }
            byArray[n2++] = __rfc1421nibbles[c];
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(byArray[0] << 2 | byArray[1] >>> 4);
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(byArray[1] << 4 | byArray[2] >>> 2);
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write(byArray[2] << 6 | byArray[3]);
                    n2 = 0;
                }
            }
        }
    }

    public static byte[] decodeRFC4648URL(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4 * string.length() / 3);
        B64Code.decodeRFC4648URL(string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void decodeRFC4648URL(String string, ByteArrayOutputStream byteArrayOutputStream) {
        char c;
        if (string == null) {
            return;
        }
        if (byteArrayOutputStream == null) {
            throw new IllegalArgumentException("No outputstream for decoded bytes");
        }
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n < string.length() && (c = string.charAt(n++)) != '=') {
            if (Character.isWhitespace(c)) continue;
            byte by = __rfc4648urlNibbles[c];
            if (by < 0) {
                throw new IllegalArgumentException("Not B64 encoded");
            }
            byArray[n2++] = __rfc4648urlNibbles[c];
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(byArray[0] << 2 | byArray[1] >>> 4);
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(byArray[1] << 4 | byArray[2] >>> 2);
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write(byArray[2] << 6 | byArray[3]);
                    n2 = 0;
                }
            }
        }
    }

    public static void encode(int n, Appendable appendable) {
        appendable.append(__rfc1421alphabet[0x3F & (0xFC000000 & n) >> 26]);
        appendable.append(__rfc1421alphabet[0x3F & (0x3F00000 & n) >> 20]);
        appendable.append(__rfc1421alphabet[0x3F & (0xFC000 & n) >> 14]);
        appendable.append(__rfc1421alphabet[0x3F & (0x3F00 & n) >> 8]);
        appendable.append(__rfc1421alphabet[0x3F & (0xFC & n) >> 2]);
        appendable.append(__rfc1421alphabet[0x3F & (3 & n) << 4]);
        appendable.append('=');
    }

    public static void encode(long l, Appendable appendable) {
        int n = (int)(0xFFFFFFFFFFFFFFFCL & l >> 32);
        appendable.append(__rfc1421alphabet[0x3F & (0xFC000000 & n) >> 26]);
        appendable.append(__rfc1421alphabet[0x3F & (0x3F00000 & n) >> 20]);
        appendable.append(__rfc1421alphabet[0x3F & (0xFC000 & n) >> 14]);
        appendable.append(__rfc1421alphabet[0x3F & (0x3F00 & n) >> 8]);
        appendable.append(__rfc1421alphabet[0x3F & (0xFC & n) >> 2]);
        appendable.append(__rfc1421alphabet[0x3F & ((3 & n) << 4) + (0xF & (int)(l >> 28))]);
        n = 0xFFFFFFF & (int)l;
        appendable.append(__rfc1421alphabet[0x3F & (0xFC00000 & n) >> 22]);
        appendable.append(__rfc1421alphabet[0x3F & (0x3F0000 & n) >> 16]);
        appendable.append(__rfc1421alphabet[0x3F & (0xFC00 & n) >> 10]);
        appendable.append(__rfc1421alphabet[0x3F & (0x3F0 & n) >> 4]);
        appendable.append(__rfc1421alphabet[0x3F & (0xF & n) << 2]);
    }

    static {
        int n;
        __rfc1421alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        __rfc1421nibbles = new byte[256];
        for (n = 0; n < 256; ++n) {
            B64Code.__rfc1421nibbles[n] = -1;
        }
        for (n = 0; n < 64; n = (int)((byte)(n + 1))) {
            B64Code.__rfc1421nibbles[(byte)B64Code.__rfc1421alphabet[n]] = n;
        }
        B64Code.__rfc1421nibbles[61] = 0;
        __rfc4648urlAlphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        __rfc4648urlNibbles = new byte[256];
        for (n = 0; n < 256; ++n) {
            B64Code.__rfc4648urlNibbles[n] = -1;
        }
        for (n = 0; n < 64; n = (int)((byte)(n + 1))) {
            B64Code.__rfc4648urlNibbles[(byte)B64Code.__rfc4648urlAlphabet[n]] = n;
        }
        B64Code.__rfc4648urlNibbles[61] = 0;
    }
}

