/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Attributes;

public class AttributesMap
implements Attributes {
    private final AtomicReference<ConcurrentMap<String, Object>> _map = new AtomicReference();

    public AttributesMap() {
    }

    public AttributesMap(AttributesMap attributesMap) {
        ConcurrentMap<String, Object> concurrentMap = attributesMap.map();
        if (concurrentMap != null) {
            this._map.set(new ConcurrentHashMap<String, Object>(concurrentMap));
        }
    }

    private ConcurrentMap<String, Object> map() {
        return this._map.get();
    }

    private ConcurrentMap<String, Object> ensureMap() {
        ConcurrentMap<String, Object> concurrentMap;
        do {
            if ((concurrentMap = this.map()) == null) continue;
            return concurrentMap;
        } while (!this._map.compareAndSet(null, concurrentMap = new ConcurrentHashMap<String, Object>()));
        return concurrentMap;
    }

    @Override
    public void removeAttribute(String string) {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        if (concurrentMap != null) {
            concurrentMap.remove(string);
        }
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.removeAttribute(string);
        } else {
            this.ensureMap().put(string, object);
        }
    }

    @Override
    public Object getAttribute(String string) {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        return concurrentMap == null ? null : concurrentMap.get(string);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeNameSet());
    }

    public Set<String> getAttributeNameSet() {
        return this.keySet();
    }

    public Set<Map.Entry<String, Object>> getAttributeEntrySet() {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        return concurrentMap == null ? Collections.emptySet() : concurrentMap.entrySet();
    }

    public static Enumeration<String> getAttributeNamesCopy(Attributes attributes) {
        if (attributes instanceof AttributesMap) {
            return Collections.enumeration(((AttributesMap)attributes).keySet());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Collections.list(attributes.getAttributeNames()));
        return Collections.enumeration(arrayList);
    }

    @Override
    public void clearAttributes() {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        if (concurrentMap != null) {
            concurrentMap.clear();
        }
    }

    public int size() {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        return concurrentMap == null ? 0 : concurrentMap.size();
    }

    public String toString() {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        return concurrentMap == null ? "{}" : concurrentMap.toString();
    }

    private Set<String> keySet() {
        ConcurrentMap<String, Object> concurrentMap = this.map();
        return concurrentMap == null ? Collections.emptySet() : concurrentMap.keySet();
    }

    public void addAll(Attributes attributes) {
        Enumeration<String> enumeration = attributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.setAttribute(string, attributes.getAttribute(string));
        }
    }
}

