/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int n) {
        super(true);
        this._value = new Object[n];
        this._rowIndex = new char[n * 32];
        this._key = new String[n];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String string, V v) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = __lookup[c & 0x7F];
            if (n3 >= 0) {
                int n4 = n * 32 + n3;
                if ((n = this._rowIndex[n4]) != 0) continue;
                this._rows = (char)(this._rows + '\u0001');
                if (this._rows >= this._value.length) {
                    return false;
                }
                this._rowIndex[n4] = this._rows;
                n = this._rowIndex[n4];
                continue;
            }
            if (c > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (n >= this._bigIndex.length) {
                return false;
            }
            char[] cArray = this._bigIndex[n];
            if (cArray == null) {
                this._bigIndex[n] = new char[128];
                cArray = this._bigIndex[n];
            }
            if ((n = cArray[c]) != 0) continue;
            if (this._rows == this._value.length) {
                return false;
            }
            cArray[c] = this._rows = (char)(this._rows + '\u0001');
            n = this._rows;
        }
        if (n >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[n] = v == null ? null : string;
        this._value[n] = v;
        return true;
    }

    @Override
    public V get(String string, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char[] cArray;
            char c = string.charAt(n + i);
            int n4 = __lookup[c & 0x7F];
            if (n4 >= 0) {
                int n5 = n3 * 32 + n4;
                if ((n3 = this._rowIndex[n5]) != 0) continue;
                return null;
            }
            char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n3];
            if (cArray == null) {
                return null;
            }
            n3 = cArray[c];
            if (n3 != 0) continue;
            return null;
        }
        return this._value[n3];
    }

    @Override
    public V get(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char[] cArray;
            byte by = byteBuffer.get(n + i);
            int n4 = __lookup[by & 0x7F];
            if (n4 >= 0) {
                int n5 = n3 * 32 + n4;
                if ((n3 = this._rowIndex[n5]) != 0) continue;
                return null;
            }
            char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n3];
            if (cArray == null) {
                return null;
            }
            n3 = cArray[by];
            if (n3 != 0) continue;
            return null;
        }
        return this._value[n3];
    }

    @Override
    public V getBest(byte[] byArray, int n, int n2) {
        return this.getBest(0, byArray, n, n2);
    }

    @Override
    public V getBest(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.hasArray()) {
            return this.getBest(0, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n, n2);
        }
        return this.getBest(0, byteBuffer, n, n2);
    }

    @Override
    public V getBest(String string, int n, int n2) {
        return this.getBest(0, string, n, n2);
    }

    private V getBest(int n, String string, int n2, int n3) {
        int n4 = n2;
        for (int i = 0; i < n3; ++i) {
            int n5;
            char c;
            int n6;
            if ((n6 = __lookup[(c = string.charAt(n4++)) & 0x7F]) >= 0) {
                int n7 = n * 32 + n6;
                n5 = this._rowIndex[n7];
                if (n5 == 0) break;
                n = n5;
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
                if (cArray == null) {
                    return null;
                }
                n5 = cArray[c];
                if (n5 == 0) break;
                n = n5;
            }
            if (this._key[n] == null) continue;
            V v = this.getBest(n, string, n2 + i + 1, n3 - i - 1);
            if (v != null) {
                return v;
            }
            return this._value[n];
        }
        return this._value[n];
    }

    private V getBest(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4;
            byte by = byArray[n2 + i];
            int n5 = __lookup[by & 0x7F];
            if (n5 >= 0) {
                int n6 = n * 32 + n5;
                n4 = this._rowIndex[n6];
                if (n4 == 0) break;
                n = n4;
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
                if (cArray == null) {
                    return null;
                }
                n4 = cArray[by];
                if (n4 == 0) break;
                n = n4;
            }
            if (this._key[n] == null) continue;
            V v = this.getBest(n, byArray, n2 + i + 1, n3 - i - 1);
            if (v == null) break;
            return v;
        }
        return this._value[n];
    }

    private V getBest(int n, ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = byteBuffer.position() + n2;
        for (int i = 0; i < n3; ++i) {
            int n5;
            byte by;
            int n6;
            if ((n6 = __lookup[(by = byteBuffer.get(n4++)) & 0x7F]) >= 0) {
                int n7 = n * 32 + n6;
                n5 = this._rowIndex[n7];
                if (n5 == 0) break;
                n = n5;
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
                if (cArray == null) {
                    return null;
                }
                n5 = cArray[by];
                if (n5 == 0) break;
                n = n5;
            }
            if (this._key[n] == null) continue;
            V v = this.getBest(n, byteBuffer, n2 + i + 1, n3 - i - 1);
            if (v == null) break;
            return v;
        }
        return this._value[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, 0);
        if (stringBuilder.length() == 0) {
            return "{}";
        }
        stringBuilder.setCharAt(0, '{');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void toString(Appendable appendable, int n) {
        char[] cArray;
        if (this._value[n] != null) {
            try {
                appendable.append(',');
                appendable.append(this._key[n]);
                appendable.append('=');
                appendable.append(this._value[n].toString());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        for (int i = 0; i < 32; ++i) {
            int n2 = n * 32 + i;
            if (this._rowIndex[n2] == '\u0000') continue;
            this.toString(appendable, this._rowIndex[n2]);
        }
        char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
        if (cArray != null) {
            for (char c : cArray) {
                if (c == '\u0000') continue;
                this.toString(appendable, c);
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        this.keySet(hashSet, 0);
        return hashSet;
    }

    private void keySet(Set<String> set, int n) {
        char[] cArray;
        if (n < this._value.length && this._value[n] != null) {
            set.add(this._key[n]);
        }
        for (int i = 0; i < 32; ++i) {
            int n2 = n * 32 + i;
            if (n2 >= this._rowIndex.length || this._rowIndex[n2] == '\u0000') continue;
            this.keySet(set, this._rowIndex[n2]);
        }
        char[] cArray2 = cArray = this._bigIndex == null || n >= this._bigIndex.length ? null : this._bigIndex[n];
        if (cArray != null) {
            for (char c : cArray) {
                if (c == '\u0000') continue;
                this.keySet(set, c);
            }
        }
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' >= this._key.length;
    }
}

