/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class ArrayQueue<E>
extends AbstractList<E>
implements Queue<E> {
    public static final int DEFAULT_CAPACITY = 64;
    public static final int DEFAULT_GROWTH = 32;
    protected final Object _lock;
    protected final int _growCapacity;
    protected Object[] _elements;
    protected int _nextE;
    protected int _nextSlot;
    protected int _size;

    public ArrayQueue() {
        this(64, -1);
    }

    public ArrayQueue(Object object) {
        this(64, -1, object);
    }

    public ArrayQueue(int n) {
        this(n, -1);
    }

    public ArrayQueue(int n, int n2) {
        this(n, n2, null);
    }

    public ArrayQueue(int n, int n2, Object object) {
        this._lock = object == null ? this : object;
        this._growCapacity = n2;
        this._elements = new Object[n];
    }

    public Object lock() {
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        Object object = this._lock;
        synchronized (object) {
            return this._elements.length;
        }
    }

    public int getNextSlotUnsafe() {
        return this._nextSlot;
    }

    @Override
    public boolean add(E e) {
        if (!this.offer(e)) {
            throw new IllegalStateException("Full");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object object = this._lock;
        synchronized (object) {
            return this.enqueue(e);
        }
    }

    protected boolean enqueue(E e) {
        if (this._size == this._elements.length && !this.growUnsafe()) {
            return false;
        }
        ++this._size;
        this._elements[this._nextSlot++] = e;
        if (this._nextSlot == this._elements.length) {
            this._nextSlot = 0;
        }
        return true;
    }

    public void addUnsafe(E e) {
        if (!this.enqueue(e)) {
            throw new IllegalStateException("Full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        Object object = this._lock;
        synchronized (object) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.at(this._nextE);
        }
    }

    private E at(int n) {
        return (E)this._elements[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                return null;
            }
            return this.at(this._nextE);
        }
    }

    public E peekUnsafe() {
        if (this._size == 0) {
            return null;
        }
        return this.at(this._nextE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                return null;
            }
            return this.dequeue();
        }
    }

    public E pollUnsafe() {
        if (this._size == 0) {
            return null;
        }
        return this.dequeue();
    }

    protected E dequeue() {
        E e = this.at(this._nextE);
        this._elements[this._nextE] = null;
        --this._size;
        if (++this._nextE == this._elements.length) {
            this._nextE = 0;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                throw new NoSuchElementException();
            }
            return this.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._size = 0;
            this._nextE = 0;
            this._nextSlot = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            return this._size;
        }
    }

    public int sizeUnsafe() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int n) {
        Object object = this._lock;
        synchronized (object) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
            }
            return this.getUnsafe(n);
        }
    }

    public E getUnsafe(int n) {
        int n2 = (this._nextE + n) % this._elements.length;
        return this.at(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) {
        Object object = this._lock;
        synchronized (object) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
            }
            int n2 = (this._nextE + n) % this._elements.length;
            E e = this.at(n2);
            if (n2 < this._nextSlot) {
                System.arraycopy(this._elements, n2 + 1, this._elements, n2, this._nextSlot - n2);
                --this._nextSlot;
                --this._size;
            } else {
                System.arraycopy(this._elements, n2 + 1, this._elements, n2, this._elements.length - n2 - 1);
                if (this._nextSlot > 0) {
                    this._elements[this._elements.length - 1] = this._elements[0];
                    System.arraycopy(this._elements, 1, this._elements, 0, this._nextSlot - 1);
                    --this._nextSlot;
                } else {
                    this._nextSlot = this._elements.length - 1;
                }
                --this._size;
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e) {
        Object object = this._lock;
        synchronized (object) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
            }
            int n2 = this._nextE + n;
            if (n2 >= this._elements.length) {
                n2 -= this._elements.length;
            }
            E e2 = this.at(n2);
            this._elements[n2] = e;
            return e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, E e) {
        Object object = this._lock;
        synchronized (object) {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
            }
            if (this._size == this._elements.length && !this.growUnsafe()) {
                throw new IllegalStateException("Full");
            }
            if (n == this._size) {
                this.add(e);
            } else {
                int n2 = this._nextE + n;
                if (n2 >= this._elements.length) {
                    n2 -= this._elements.length;
                }
                ++this._size;
                ++this._nextSlot;
                if (this._nextSlot == this._elements.length) {
                    this._nextSlot = 0;
                }
                if (n2 < this._nextSlot) {
                    System.arraycopy(this._elements, n2, this._elements, n2 + 1, this._nextSlot - n2);
                    this._elements[n2] = e;
                } else {
                    if (this._nextSlot > 0) {
                        System.arraycopy(this._elements, 0, this._elements, 1, this._nextSlot);
                        this._elements[0] = this._elements[this._elements.length - 1];
                    }
                    System.arraycopy(this._elements, n2, this._elements, n2 + 1, this._elements.length - n2 - 1);
                    this._elements[n2] = e;
                }
            }
        }
    }

    protected void resizeUnsafe(int n) {
        n = Math.max(n, this._size);
        Object[] objectArray = new Object[n];
        if (this._size > 0) {
            if (this._nextSlot > this._nextE) {
                System.arraycopy(this._elements, this._nextE, objectArray, 0, this._size);
            } else {
                int n2 = this._elements.length - this._nextE;
                System.arraycopy(this._elements, this._nextE, objectArray, 0, n2);
                System.arraycopy(this._elements, 0, objectArray, n2, this._nextSlot);
            }
        }
        this._elements = objectArray;
        this._nextE = 0;
        this._nextSlot = this._size;
    }

    protected boolean growUnsafe() {
        if (this._growCapacity <= 0) {
            return false;
        }
        this.resizeUnsafe(this._elements.length + this._growCapacity);
        return true;
    }
}

