/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SessionHandler
extends ScopedHandler {
    static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final EnumSet<SessionTrackingMode> DEFAULT_TRACKING = EnumSet.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
    public static final Class<? extends EventListener>[] SESSION_LISTENER_TYPES = new Class[]{HttpSessionAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class};
    private SessionManager _sessionManager;

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager sessionManager) {
        this.setSessionManager(sessionManager);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        if (sessionManager != null) {
            sessionManager.setSessionHandler(this);
        }
        this.updateBean(this._sessionManager, sessionManager);
        this._sessionManager = sessionManager;
    }

    @Override
    protected void doStart() {
        if (this._sessionManager == null) {
            this.setSessionManager(new HashSessionManager());
        }
        super.doStart();
    }

    @Override
    protected void doStop() {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doScope(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession;
        HttpSession httpSession2;
        HttpSession httpSession3;
        SessionManager sessionManager;
        block19: {
            sessionManager = null;
            httpSession3 = null;
            httpSession2 = null;
            try {
                sessionManager = request.getSessionManager();
                httpSession3 = request.getSession(false);
                if (sessionManager != this._sessionManager) {
                    request.setSessionManager(this._sessionManager);
                    request.setSession(null);
                    this.checkRequestedSessionId(request, httpServletRequest);
                }
                httpSession = null;
                if (this._sessionManager != null) {
                    httpSession = request.getSession(false);
                    if (httpSession != null) {
                        if (httpSession != httpSession3 && (httpServletRequest.getDispatcherType() == DispatcherType.ASYNC || httpServletRequest.getDispatcherType() == DispatcherType.REQUEST)) {
                            httpSession2 = httpSession;
                            HttpCookie httpCookie = this._sessionManager.access(httpSession, httpServletRequest.isSecure());
                            if (httpCookie != null) {
                                request.getResponse().addCookie(httpCookie);
                            }
                        }
                    } else {
                        httpSession = request.recoverNewSession(this._sessionManager);
                        if (httpSession != null) {
                            request.setSession(httpSession);
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sessionManager=" + this._sessionManager, new Object[0]);
                    LOG.debug("session=" + httpSession, new Object[0]);
                }
                if (this._nextScope != null) {
                    this._nextScope.doScope(string, request, httpServletRequest, httpServletResponse);
                } else if (this._outerScope != null) {
                    this._outerScope.doHandle(string, request, httpServletRequest, httpServletResponse);
                } else {
                    this.doHandle(string, request, httpServletRequest, httpServletResponse);
                }
                if (httpSession2 == null) break block19;
                this._sessionManager.complete(httpSession2);
            }
            catch (Throwable throwable) {
                HttpSession httpSession4;
                if (httpSession2 != null) {
                    this._sessionManager.complete(httpSession2);
                }
                if ((httpSession4 = request.getSession(false)) != null && httpSession3 == null && httpSession4 != httpSession2 && (httpServletRequest.getDispatcherType() == DispatcherType.ASYNC || httpServletRequest.getDispatcherType() == DispatcherType.REQUEST)) {
                    this._sessionManager.complete(httpSession4);
                }
                if (sessionManager != null && sessionManager != this._sessionManager) {
                    request.setSessionManager(sessionManager);
                    request.setSession(httpSession3);
                }
                throw throwable;
            }
        }
        if ((httpSession = request.getSession(false)) != null && httpSession3 == null && httpSession != httpSession2 && (httpServletRequest.getDispatcherType() == DispatcherType.ASYNC || httpServletRequest.getDispatcherType() == DispatcherType.REQUEST)) {
            this._sessionManager.complete(httpSession);
        }
        if (sessionManager != null && sessionManager != this._sessionManager) {
            request.setSessionManager(sessionManager);
            request.setSession(httpSession3);
        }
    }

    @Override
    public void doHandle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.never()) {
            this.nextHandle(string, request, httpServletRequest, httpServletResponse);
        } else if (this._nextScope != null && this._nextScope == this._handler) {
            this._nextScope.doHandle(string, request, httpServletRequest, httpServletResponse);
        } else if (this._handler != null) {
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
        }
    }

    protected void checkRequestedSessionId(Request request, HttpServletRequest httpServletRequest) {
        int n;
        String string;
        Object object;
        String string2 = httpServletRequest.getRequestedSessionId();
        SessionManager sessionManager = this.getSessionManager();
        if (string2 != null && sessionManager != null) {
            HttpSession httpSession = sessionManager.getHttpSession(string2);
            if (httpSession != null && sessionManager.isValid(httpSession)) {
                request.setSession(httpSession);
            }
            return;
        }
        if (!DispatcherType.REQUEST.equals((Object)request.getDispatcherType())) {
            return;
        }
        boolean bl = false;
        HttpSession httpSession = null;
        if (this._sessionManager.isUsingCookies() && (object = httpServletRequest.getCookies()) != null && ((Cookie[])object).length > 0) {
            string = sessionManager.getSessionCookieConfig().getName();
            for (n = 0; n < ((Object)object).length; ++n) {
                if (!string.equalsIgnoreCase(object[n].getName())) continue;
                string2 = object[n].getValue();
                bl = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got Session ID {} from cookie", new Object[]{string2});
                }
                if (string2 != null) {
                    httpSession = sessionManager.getHttpSession(string2);
                    if (httpSession == null || !sessionManager.isValid(httpSession)) continue;
                    break;
                }
                LOG.warn("null session id from cookie", new Object[0]);
            }
        }
        if (string2 == null || httpSession == null) {
            object = httpServletRequest.getRequestURI();
            string = sessionManager.getSessionIdPathParameterNamePrefix();
            if (string != null && (n = ((String)object).indexOf(string)) >= 0) {
                char c;
                int n2;
                for (n2 = n += string.length(); n2 < ((String)object).length() && (c = ((String)object).charAt(n2)) != ';' && c != '#' && c != '?' && c != '/'; ++n2) {
                }
                string2 = ((String)object).substring(n, n2);
                bl = false;
                httpSession = sessionManager.getHttpSession(string2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got Session ID {} from URL", new Object[]{string2});
                }
            }
        }
        request.setRequestedSessionId(string2);
        request.setRequestedSessionIdFromCookie(string2 != null && bl);
        if (httpSession != null && sessionManager.isValid(httpSession)) {
            request.setSession(httpSession);
        }
    }

    public void addEventListener(EventListener eventListener) {
        if (this._sessionManager != null) {
            this._sessionManager.addEventListener(eventListener);
        }
    }

    public void removeEventListener(EventListener eventListener) {
        if (this._sessionManager != null) {
            this._sessionManager.removeEventListener(eventListener);
        }
    }

    public void clearEventListeners() {
        if (this._sessionManager != null) {
            this._sessionManager.clearEventListeners();
        }
    }
}

