/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;

public class MemSession
extends AbstractSession {
    private final Map<String, Object> _attributes = new HashMap<String, Object>();

    protected MemSession(AbstractSessionManager abstractSessionManager, HttpServletRequest httpServletRequest) {
        super(abstractSessionManager, httpServletRequest);
    }

    public MemSession(AbstractSessionManager abstractSessionManager, long l, long l2, String string) {
        super(abstractSessionManager, l, l2, string);
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this._attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAttributes() {
        MemSession memSession = this;
        synchronized (memSession) {
            this.checkValid();
            return this._attributes.size();
        }
    }

    @Override
    public Enumeration<String> doGetAttributeNames() {
        List<Object> list = this._attributes == null ? Collections.EMPTY_LIST : new ArrayList<String>(this._attributes.keySet());
        return Collections.enumeration(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getNames() {
        MemSession memSession = this;
        synchronized (memSession) {
            return new HashSet<String>(this._attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAttributes() {
        while (this._attributes != null && this._attributes.size() > 0) {
            ArrayList<String> arrayList;
            MemSession memSession = this;
            synchronized (memSession) {
                arrayList = new ArrayList<String>(this._attributes.keySet());
            }
            for (String string : arrayList) {
                Object object;
                MemSession memSession2 = this;
                synchronized (memSession2) {
                    object = this.doPutOrRemove(string, null);
                }
                this.unbindValue(string, object);
                ((AbstractSessionManager)this.getSessionManager()).doSessionAttributeListeners(this, string, object, null);
            }
        }
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public void addAttributes(Map<String, Object> map) {
        this._attributes.putAll(map);
    }

    @Override
    public Object doPutOrRemove(String string, Object object) {
        return object == null ? this._attributes.remove(string) : this._attributes.put(string, object);
    }

    @Override
    public Object doGet(String string) {
        return this._attributes.get(string);
    }
}

