/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.JDBCSessionIdManager;
import org.eclipse.jetty.server.session.MemSession;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JDBCSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger(JDBCSessionManager.class);
    private ConcurrentHashMap<String, Session> _sessions;
    protected JDBCSessionIdManager _jdbcSessionIdMgr = null;
    protected long _saveIntervalSec = 60L;
    protected JDBCSessionIdManager.SessionTableSchema _sessionTableSchema;

    public void setSaveInterval(long l) {
        this._saveIntervalSec = l;
    }

    public long getSaveInterval() {
        return this._saveIntervalSec;
    }

    public void cacheInvalidate(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(String string) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            Session session2 = this._sessions.get(string);
            long l = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                if (session2 == null) {
                    LOG.debug("getSession(" + string + "): not in session map," + " now=" + l + " lastSaved=" + (session2 == null ? 0L : session2._lastSaved) + " interval=" + this._saveIntervalSec * 1000L, new Object[0]);
                } else {
                    LOG.debug("getSession(" + string + "): in session map, " + " hashcode=" + session2.hashCode() + " now=" + l + " lastSaved=" + (session2 == null ? 0L : session2._lastSaved) + " interval=" + this._saveIntervalSec * 1000L + " lastNode=" + session2._lastNode + " thisNode=" + this.getSessionIdManager().getWorkerName() + " difference=" + (l - session2._lastSaved), new Object[0]);
                }
            }
            try {
                if (session2 == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + string + "): no session in session map. Reloading session data from db.", new Object[0]);
                    }
                    session = this.loadSession(string, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context));
                } else if (l - session2._lastSaved >= this._saveIntervalSec * 1000L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + string + "): stale session. Reloading session data from db.", new Object[0]);
                    }
                    session = this.loadSession(string, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + string + "): session in session map", new Object[0]);
                    }
                    session = session2;
                }
            }
            catch (Exception exception) {
                LOG.warn("Unable to load session " + string, (Throwable)exception);
                return null;
            }
            if (session != null) {
                if (!session.getLastNode().equals(this.getSessionIdManager().getWorkerName()) || session2 == null) {
                    if (session._expiryTime <= 0L || session._expiryTime > l) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession(" + string + "): lastNode=" + session.getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName(), new Object[0]);
                        }
                        session.setLastNode(this.getSessionIdManager().getWorkerName());
                        this._sessions.put(string, session);
                        try {
                            this.updateSessionNode(session);
                            session.didActivate();
                        }
                        catch (Exception exception) {
                            LOG.warn("Unable to update freshly loaded session " + string, (Throwable)exception);
                            return null;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession ({}): Session has expired", new Object[]{string});
                        }
                        this._jdbcSessionIdMgr.removeSession(string);
                        session = null;
                    }
                } else {
                    session = session2;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession({}): Session not stale {}", new Object[]{string, session});
                    }
                }
            } else {
                if (session2 != null) {
                    this.removeSession(session2, true);
                }
                LOG.debug("getSession({}): No session in database matching id={}", new Object[]{string, string});
            }
            return session;
        }
    }

    @Override
    public int getSessions() {
        return this._sessions.size();
    }

    @Override
    public void doStart() {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        this._jdbcSessionIdMgr = (JDBCSessionIdManager)this._sessionIdManager;
        this._sessionTableSchema = this._jdbcSessionIdMgr.getSessionTableSchema();
        this._sessions = new ConcurrentHashMap();
        super.doStart();
    }

    @Override
    public void doStop() {
        super.doStop();
        this._sessions.clear();
        this._sessions = null;
    }

    @Override
    protected void shutdownSessions() {
        ArrayList<Object> arrayList;
        long l = this.getContextHandler().getServer().getStopTimeout();
        long l2 = 0L;
        if (l > 0L) {
            l2 = System.nanoTime() + TimeUnit.NANOSECONDS.convert(l, TimeUnit.MILLISECONDS);
        }
        ArrayList<Object> arrayList2 = arrayList = this._sessions == null ? new ArrayList() : new ArrayList<Session>(this._sessions.values());
        while (arrayList.size() > 0 && (l2 > 0L && System.nanoTime() < l2 || l2 == 0L)) {
            for (Session session : arrayList) {
                try {
                    session.save(false);
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
                this._sessions.remove(session.getClusterId());
            }
            if (l2 == 0L) break;
            arrayList = new ArrayList<Session>(this._sessions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String string, String string2, String string3, String string4) {
        block5: {
            Session session = null;
            try {
                session = this._sessions.remove(string);
                if (session == null) break block5;
                Session session2 = session;
                synchronized (session2) {
                    session.setClusterId(string3);
                    session.setNodeId(string4);
                    this._sessions.put(string3, session);
                    this.updateSession(session);
                }
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
        }
        super.renewSessionId(string, string2, string3, string4);
    }

    protected void invalidateSession(String string) {
        Session session = this._sessions.get(string);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    protected boolean removeSession(String string) {
        Session session = this._sessions.remove(string);
        try {
            if (session != null) {
                this.deleteSession(session);
            }
        }
        catch (Exception exception) {
            LOG.warn("Problem deleting session id=" + string, (Throwable)exception);
        }
        return session != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSession(AbstractSession abstractSession) {
        if (abstractSession == null) {
            return;
        }
        this._sessions.put(abstractSession.getClusterId(), (Session)abstractSession);
        try {
            AbstractSession abstractSession2 = abstractSession;
            synchronized (abstractSession2) {
                abstractSession.willPassivate();
                this.storeSession((Session)abstractSession);
                abstractSession.didActivate();
            }
        }
        catch (Exception exception) {
            LOG.warn("Unable to store new session id=" + abstractSession.getId(), (Throwable)exception);
        }
    }

    @Override
    protected AbstractSession newSession(HttpServletRequest httpServletRequest) {
        return new Session(httpServletRequest);
    }

    protected AbstractSession newSession(String string, String string2, long l, long l2, long l3) {
        return new Session(string, string2, l, l2, l3);
    }

    @Override
    public boolean removeSession(AbstractSession abstractSession, boolean bl) {
        boolean bl2 = super.removeSession(abstractSession, bl);
        if (bl2 && !bl) {
            abstractSession.willPassivate();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> expire(Set<String> set) {
        if (this.isStopping() || this.isStopped()) {
            return null;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            for (String object2 : set) {
                Session session;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Expiring session id " + object2, new Object[0]);
                }
                if ((session = this._sessions.get(object2)) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Force loading session id " + object2, new Object[0]);
                    }
                    if ((session = this.loadSession(object2, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context))) != null) {
                        this._sessions.put(session.getClusterId(), session);
                    } else {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Unrecognized session id=" + object2, new Object[0]);
                        continue;
                    }
                }
                if (session == null) continue;
                session.timeout();
                hashSet.add(session.getClusterId());
            }
            HashSet<String> hashSet2 = hashSet;
            return hashSet2;
        }
        catch (Throwable throwable) {
            LOG.warn("Problem expiring sessions", throwable);
            HashSet<String> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    protected void expireCandidates(Set<String> set) {
        Iterator<String> iterator = set.iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            String string = iterator.next();
            try {
                Session session;
                Session session2 = this._sessions.get(string);
                if (session2 == null || (session = this.loadSession(string, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context))) != null) continue;
                session2.timeout();
            }
            catch (Exception exception) {
                LOG.warn("Error checking db for expiry for session {}", new Object[]{string});
            }
        }
    }

    protected Set<String> getCandidateExpiredIds() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this._sessions.keySet()) {
            Session session = this._sessions.get(string);
            if (session._expiryTime <= 0L || System.currentTimeMillis() <= session._expiryTime) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected Session loadSession(final String string, final String string2, final String string3) {
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try (Connection connection = JDBCSessionManager.this.getConnection();
                     PreparedStatement preparedStatement = JDBCSessionManager.this._sessionTableSchema.getLoadStatement(connection, string, string2, string3);
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    Session session = null;
                    if (resultSet.next()) {
                        long l = resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getMaxIntervalColumn());
                        if (l == -999L) {
                            l = JDBCSessionManager.this.getMaxInactiveInterval();
                        }
                        session = (Session)JDBCSessionManager.this.newSession(string, resultSet.getString(JDBCSessionManager.this._sessionTableSchema.getRowIdColumn()), resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getCreateTimeColumn()), resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getAccessTimeColumn()), l);
                        session.setCookieSetTime(resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getCookieTimeColumn()));
                        session.setLastAccessedTime(resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getLastAccessTimeColumn()));
                        session.setLastNode(resultSet.getString(JDBCSessionManager.this._sessionTableSchema.getLastNodeColumn()));
                        session.setLastSaved(resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getLastSavedTimeColumn()));
                        session.setExpiryTime(resultSet.getLong(JDBCSessionManager.this._sessionTableSchema.getExpiryTimeColumn()));
                        session.setCanonicalContext(resultSet.getString(JDBCSessionManager.this._sessionTableSchema.getContextPathColumn()));
                        session.setVirtualHost(resultSet.getString(JDBCSessionManager.this._sessionTableSchema.getVirtualHostColumn()));
                        try (InputStream inputStream = ((JDBCSessionIdManager)JDBCSessionManager.this.getSessionIdManager())._dbAdaptor.getBlobInputStream(resultSet, JDBCSessionManager.this._sessionTableSchema.getMapColumn());
                             ClassLoadingObjectInputStream classLoadingObjectInputStream = new ClassLoadingObjectInputStream(inputStream);){
                            Object object = classLoadingObjectInputStream.readObject();
                            session.addAttributes((Map)object);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("LOADED session " + session, new Object[0]);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to load session " + string, new Object[0]);
                    }
                    atomicReference.set(session);
                }
                catch (Exception exception) {
                    atomicReference2.set(exception);
                }
            }
        };
        if (this._context == null) {
            runnable.run();
        } else {
            this._context.getContextHandler().handle(null, runnable);
        }
        if (atomicReference2.get() != null) {
            this._jdbcSessionIdMgr.removeSession(string);
            throw (Exception)atomicReference2.get();
        }
        return (Session)atomicReference.get();
    }

    protected void storeSession(Session session) {
        if (session == null) {
            return;
        }
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._jdbcSessionIdMgr._insertSession);){
            String string = this.calculateRowId(session);
            long l = System.currentTimeMillis();
            connection.setAutoCommit(true);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, session.getClusterId());
            preparedStatement.setString(3, session.getCanonicalContext());
            preparedStatement.setString(4, session.getVirtualHost());
            preparedStatement.setString(5, this.getSessionIdManager().getWorkerName());
            preparedStatement.setLong(6, session.getAccessed());
            preparedStatement.setLong(7, session.getLastAccessedTime());
            preparedStatement.setLong(8, session.getCreationTime());
            preparedStatement.setLong(9, session.getCookieSetTime());
            preparedStatement.setLong(10, l);
            preparedStatement.setLong(11, session.getExpiryTime());
            preparedStatement.setLong(12, session.getMaxInactiveInterval());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(session.getAttributeMap());
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(13, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.executeUpdate();
            session.setRowId(string);
            session.setLastSaved(l);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stored session " + session, new Object[0]);
        }
    }

    protected void updateSession(Session session) {
        if (session == null) {
            return;
        }
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSession);){
            long l = System.currentTimeMillis();
            connection.setAutoCommit(true);
            preparedStatement.setString(1, session.getClusterId());
            preparedStatement.setString(2, this.getSessionIdManager().getWorkerName());
            preparedStatement.setLong(3, session.getAccessed());
            preparedStatement.setLong(4, session.getLastAccessedTime());
            preparedStatement.setLong(5, l);
            preparedStatement.setLong(6, session.getExpiryTime());
            preparedStatement.setLong(7, session.getMaxInactiveInterval());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(session.getAttributeMap());
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(8, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.setString(9, session.getRowId());
            preparedStatement.executeUpdate();
            session.setLastSaved(l);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated session " + session, new Object[0]);
        }
    }

    protected void updateSessionNode(Session session) {
        String string = this.getSessionIdManager().getWorkerName();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionNode);){
            connection.setAutoCommit(true);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, session.getRowId());
            preparedStatement.executeUpdate();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated last node for session id=" + session.getId() + ", lastNode = " + string, new Object[0]);
        }
    }

    private void updateSessionAccessTime(Session session) {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionAccessTime);){
            long l = System.currentTimeMillis();
            connection.setAutoCommit(true);
            preparedStatement.setString(1, this.getSessionIdManager().getWorkerName());
            preparedStatement.setLong(2, session.getAccessed());
            preparedStatement.setLong(3, session.getLastAccessedTime());
            preparedStatement.setLong(4, l);
            preparedStatement.setLong(5, session.getExpiryTime());
            preparedStatement.setLong(6, session.getMaxInactiveInterval());
            preparedStatement.setString(7, session.getRowId());
            preparedStatement.executeUpdate();
            session.setLastSaved(l);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated access time session id=" + session.getId() + " with lastsaved=" + session.getLastSaved(), new Object[0]);
        }
    }

    protected void deleteSession(Session session) {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._jdbcSessionIdMgr._deleteSession);){
            connection.setAutoCommit(true);
            preparedStatement.setString(1, session.getRowId());
            preparedStatement.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted Session " + session, new Object[0]);
            }
        }
    }

    private Connection getConnection() {
        return ((JDBCSessionIdManager)this.getSessionIdManager()).getConnection();
    }

    private String calculateRowId(Session session) {
        String string = JDBCSessionManager.canonicalize(this._context.getContextPath());
        string = string + "_" + JDBCSessionManager.getVirtualHost(this._context);
        string = string + "_" + session.getId();
        return string;
    }

    private static String getVirtualHost(ContextHandler.Context context) {
        String string = "0.0.0.0";
        if (context == null) {
            return string;
        }
        String[] stringArray = context.getContextHandler().getVirtualHosts();
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return string;
        }
        return stringArray[0];
    }

    private static String canonicalize(String string) {
        if (string == null) {
            return "";
        }
        return string.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    public class Session
    extends MemSession {
        private static final long serialVersionUID = 5208464051134226143L;
        protected boolean _dirty;
        protected long _expiryTime;
        protected long _lastSaved;
        protected String _lastNode;
        protected String _virtualHost;
        protected String _rowId;
        protected String _canonicalContext;

        protected Session(HttpServletRequest httpServletRequest) {
            super(JDBCSessionManager.this, httpServletRequest);
            this._dirty = false;
            int n = this.getMaxInactiveInterval();
            this._expiryTime = n <= 0 ? 0L : System.currentTimeMillis() + (long)n * 1000L;
            this._virtualHost = JDBCSessionManager.getVirtualHost(JDBCSessionManager.this._context);
            this._canonicalContext = JDBCSessionManager.canonicalize(JDBCSessionManager.this._context.getContextPath());
            this._lastNode = JDBCSessionManager.this.getSessionIdManager().getWorkerName();
        }

        protected Session(String string, String string2, long l, long l2, long l3) {
            super(JDBCSessionManager.this, l, l2, string);
            this._dirty = false;
            this._rowId = string2;
            super.setMaxInactiveInterval((int)l3);
            this._expiryTime = l3 <= 0L ? 0L : System.currentTimeMillis() + l3 * 1000L;
        }

        protected synchronized String getRowId() {
            return this._rowId;
        }

        protected synchronized void setRowId(String string) {
            this._rowId = string;
        }

        public synchronized void setVirtualHost(String string) {
            this._virtualHost = string;
        }

        public synchronized String getVirtualHost() {
            return this._virtualHost;
        }

        public synchronized long getLastSaved() {
            return this._lastSaved;
        }

        public synchronized void setLastSaved(long l) {
            this._lastSaved = l;
        }

        public synchronized void setExpiryTime(long l) {
            this._expiryTime = l;
        }

        public synchronized long getExpiryTime() {
            return this._expiryTime;
        }

        public synchronized void setCanonicalContext(String string) {
            this._canonicalContext = string;
        }

        public synchronized String getCanonicalContext() {
            return this._canonicalContext;
        }

        public synchronized void setLastNode(String string) {
            this._lastNode = string;
        }

        public synchronized String getLastNode() {
            return this._lastNode;
        }

        @Override
        public void setAttribute(String string, Object object) {
            Object object2 = this.changeAttribute(string, object);
            if (object == null && object2 == null) {
                return;
            }
            this._dirty = true;
        }

        @Override
        public void removeAttribute(String string) {
            Object object = this.changeAttribute(string, null);
            if (object != null) {
                this._dirty = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean access(long l) {
            Session session = this;
            synchronized (session) {
                if (super.access(l)) {
                    int n = this.getMaxInactiveInterval();
                    this._expiryTime = n <= 0 ? 0L : l + (long)n * 1000L;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMaxInactiveInterval(int n) {
            Session session = this;
            synchronized (session) {
                super.setMaxInactiveInterval(n);
                int n2 = this.getMaxInactiveInterval();
                this._expiryTime = n2 <= 0 ? 0L : System.currentTimeMillis() + (long)n2 * 1000L;
                try {
                    JDBCSessionManager.this.updateSessionAccessTime(this);
                }
                catch (Exception exception) {
                    LOG.warn("Problem saving changed max idle time for session " + this, (Throwable)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void complete() {
            Session session = this;
            synchronized (session) {
                super.complete();
                try {
                    if (this.isValid()) {
                        if (this._dirty) {
                            this.save(true);
                        } else if (this.getAccessed() - this._lastSaved >= JDBCSessionManager.this.getSaveInterval() * 1000L) {
                            JDBCSessionManager.this.updateSessionAccessTime(this);
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.warn("Problem persisting changed session data id=" + this.getId(), (Throwable)exception);
                }
                finally {
                    this._dirty = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void save() {
            Session session = this;
            synchronized (session) {
                try {
                    JDBCSessionManager.this.updateSession(this);
                }
                finally {
                    this._dirty = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void save(boolean bl) {
            Session session = this;
            synchronized (session) {
                if (this._dirty) {
                    this.willPassivate();
                    JDBCSessionManager.this.updateSession(this);
                    if (bl) {
                        this.didActivate();
                    }
                }
            }
        }

        @Override
        protected void timeout() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out session id=" + this.getClusterId(), new Object[0]);
            }
            super.timeout();
        }

        @Override
        public String toString() {
            return "Session rowId=" + this._rowId + ",id=" + this.getId() + ",lastNode=" + this._lastNode + ",created=" + this.getCreationTime() + ",accessed=" + this.getAccessed() + ",lastAccessed=" + this.getLastAccessedTime() + ",cookieSet=" + this.getCookieSetTime() + ",maxInterval=" + this.getMaxInactiveInterval() + ",lastSaved=" + this._lastSaved + ",expiry=" + this._expiryTime;
        }
    }
}

