/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class JDBCSessionIdManager
extends AbstractSessionIdManager {
    static final Logger LOG = SessionHandler.LOG;
    public static final int MAX_INTERVAL_NOT_SET = -999;
    protected final HashSet<String> _sessionIds = new HashSet();
    protected Server _server;
    protected Driver _driver;
    protected String _driverClassName;
    protected String _connectionUrl;
    protected DataSource _datasource;
    protected String _jndiName;
    protected int _deleteBlockSize = 10;
    protected Scheduler.Task _task;
    protected Scheduler _scheduler;
    protected Scavenger _scavenger;
    protected boolean _ownScheduler;
    protected long _lastScavengeTime;
    protected long _scavengeIntervalMs = 600000L;
    protected String _createSessionIdTable;
    protected String _createSessionTable;
    protected String _selectBoundedExpiredSessions;
    private String _selectExpiredSessions;
    protected String _insertId;
    protected String _deleteId;
    protected String _queryId;
    protected String _insertSession;
    protected String _deleteSession;
    protected String _updateSession;
    protected String _updateSessionNode;
    protected String _updateSessionAccessTime;
    protected DatabaseAdaptor _dbAdaptor = new DatabaseAdaptor();
    protected SessionIdTableSchema _sessionIdTableSchema = new SessionIdTableSchema();
    protected SessionTableSchema _sessionTableSchema = new SessionTableSchema();

    public JDBCSessionIdManager(Server server) {
        this._server = server;
    }

    public JDBCSessionIdManager(Server server, Random random) {
        super(random);
        this._server = server;
    }

    public void setDriverInfo(String string, String string2) {
        this._driverClassName = string;
        this._connectionUrl = string2;
    }

    public void setDriverInfo(Driver driver, String string) {
        this._driver = driver;
        this._connectionUrl = string;
    }

    public void setDatasource(DataSource dataSource) {
        this._datasource = dataSource;
    }

    public DataSource getDataSource() {
        return this._datasource;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    public void setDatasourceName(String string) {
        this._jndiName = string;
    }

    public String getDatasourceName() {
        return this._jndiName;
    }

    @Deprecated
    public void setBlobType(String string) {
        this._dbAdaptor.setBlobType(string);
    }

    public DatabaseAdaptor getDbAdaptor() {
        return this._dbAdaptor;
    }

    public void setDbAdaptor(DatabaseAdaptor databaseAdaptor) {
        if (databaseAdaptor == null) {
            throw new IllegalStateException("DbAdaptor cannot be null");
        }
        this._dbAdaptor = databaseAdaptor;
    }

    @Deprecated
    public String getBlobType() {
        return this._dbAdaptor.getBlobType();
    }

    @Deprecated
    public String getLongType() {
        return this._dbAdaptor.getLongType();
    }

    @Deprecated
    public void setLongType(String string) {
        this._dbAdaptor.setLongType(string);
    }

    public SessionIdTableSchema getSessionIdTableSchema() {
        return this._sessionIdTableSchema;
    }

    public void setSessionIdTableSchema(SessionIdTableSchema sessionIdTableSchema) {
        if (sessionIdTableSchema == null) {
            throw new IllegalArgumentException("Null SessionIdTableSchema");
        }
        this._sessionIdTableSchema = sessionIdTableSchema;
    }

    public SessionTableSchema getSessionTableSchema() {
        return this._sessionTableSchema;
    }

    public void setSessionTableSchema(SessionTableSchema sessionTableSchema) {
        this._sessionTableSchema = sessionTableSchema;
    }

    public void setDeleteBlockSize(int n) {
        this._deleteBlockSize = n;
    }

    public int getDeleteBlockSize() {
        return this._deleteBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengeInterval(long l) {
        long l2;
        if (l <= 0L) {
            l = 60L;
        }
        long l3 = this._scavengeIntervalMs;
        this._scavengeIntervalMs = l2 = l * 1000L;
        long l4 = this._scavengeIntervalMs / 10L;
        if (System.currentTimeMillis() % 2L == 0L) {
            this._scavengeIntervalMs += l4;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging every " + this._scavengeIntervalMs + " ms", new Object[0]);
        }
        JDBCSessionIdManager jDBCSessionIdManager = this;
        synchronized (jDBCSessionIdManager) {
            if (this._scheduler != null && (l2 != l3 || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                }
                if (this._scavenger == null) {
                    this._scavenger = new Scavenger();
                }
                this._task = this._scheduler.schedule((Runnable)this._scavenger, this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    public long getScavengeInterval() {
        return this._scavengeIntervalMs / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession httpSession) {
        if (httpSession == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            String string = ((JDBCSessionManager.Session)httpSession).getClusterId();
            try {
                this.insert(string);
                this._sessionIds.add(string);
            }
            catch (Exception exception) {
                LOG.warn("Problem storing session id=" + string, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String string) {
        if (string == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            try {
                this.insert(string);
                this._sessionIds.add(string);
            }
            catch (Exception exception) {
                LOG.warn("Problem storing session id=" + string, (Throwable)exception);
            }
        }
    }

    @Override
    public void removeSession(HttpSession httpSession) {
        if (httpSession == null) {
            return;
        }
        this.removeSession(((JDBCSessionManager.Session)httpSession).getClusterId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String string) {
        if (string == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing sessionid=" + string, new Object[0]);
            }
            try {
                this._sessionIds.remove(string);
                this.delete(string);
            }
            catch (Exception exception) {
                LOG.warn("Problem removing session id=" + string, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idInUse(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.getClusterId(string);
        boolean bl = false;
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            bl = this._sessionIds.contains(string2);
        }
        if (bl) {
            return true;
        }
        try {
            return this.exists(string2);
        }
        catch (Exception exception) {
            LOG.warn("Problem checking inUse for id=" + string2, (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String string) {
        this.removeSession(string);
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            Handler[] handlerArray = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
                SessionManager sessionManager;
                SessionHandler sessionHandler = ((ContextHandler)handlerArray[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (sessionManager = sessionHandler.getSessionManager()) == null || !(sessionManager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)sessionManager).invalidateSession(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String string, String string2, HttpServletRequest httpServletRequest) {
        String string3 = this.newSessionId(httpServletRequest.hashCode());
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            this.removeSession(string);
            this.addSession(string3);
            Handler[] handlerArray = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
                SessionManager sessionManager;
                SessionHandler sessionHandler = ((ContextHandler)handlerArray[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (sessionManager = sessionHandler.getSessionManager()) == null || !(sessionManager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)sessionManager).renewSessionId(string, string2, string3, this.getNodeId(string3, httpServletRequest));
            }
        }
    }

    @Override
    public void doStart() {
        this.initializeDatabase();
        this.prepareTables();
        super.doStart();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging interval = " + this.getScavengeInterval() + " sec", new Object[0]);
        }
        this._scheduler = (Scheduler)this._server.getBean(Scheduler.class);
        if (this._scheduler == null) {
            this._scheduler = new ScheduledExecutorScheduler();
            this._ownScheduler = true;
            this._scheduler.start();
        } else if (!this._scheduler.isStarted()) {
            throw new IllegalStateException("Shared scheduler not started");
        }
        this.setScavengeInterval(this.getScavengeInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        JDBCSessionIdManager jDBCSessionIdManager = this;
        synchronized (jDBCSessionIdManager) {
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this._ownScheduler && this._scheduler != null) {
                this._scheduler.stop();
            }
            this._scheduler = null;
        }
        this._sessionIds.clear();
        super.doStop();
    }

    protected Connection getConnection() {
        if (this._datasource != null) {
            return this._datasource.getConnection();
        }
        return DriverManager.getConnection(this._connectionUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTables() {
        if (this._sessionIdTableSchema == null) {
            throw new IllegalStateException("No SessionIdTableSchema");
        }
        if (this._sessionTableSchema == null) {
            throw new IllegalStateException("No SessionTableSchema");
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            Object object;
            Object object2;
            String string;
            DatabaseMetaData databaseMetaData;
            block76: {
                connection.setAutoCommit(true);
                databaseMetaData = connection.getMetaData();
                this._dbAdaptor.adaptTo(databaseMetaData);
                this._sessionTableSchema.setDatabaseAdaptor(this._dbAdaptor);
                this._sessionIdTableSchema.setDatabaseAdaptor(this._dbAdaptor);
                this._createSessionIdTable = this._sessionIdTableSchema.getCreateStatementAsString();
                this._insertId = this._sessionIdTableSchema.getInsertStatementAsString();
                this._deleteId = this._sessionIdTableSchema.getDeleteStatementAsString();
                this._queryId = this._sessionIdTableSchema.getSelectStatementAsString();
                string = this._dbAdaptor.convertIdentifier(this._sessionIdTableSchema.getTableName());
                object2 = databaseMetaData.getTables(null, null, string, null);
                object = null;
                try {
                    if (!object2.next()) {
                        statement.executeUpdate(this._createSessionIdTable);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                object2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            object2.close();
                        }
                    }
                }
                string = this._dbAdaptor.convertIdentifier(this._sessionTableSchema.getTableName());
                object2 = databaseMetaData.getTables(null, null, string, null);
                object = null;
                try {
                    if (!object2.next()) {
                        this._createSessionTable = this._sessionTableSchema.getCreateStatementAsString();
                        statement.executeUpdate(this._createSessionTable);
                        break block76;
                    }
                    ResultSet resultSet = null;
                    try {
                        resultSet = databaseMetaData.getColumns(null, null, this._dbAdaptor.convertIdentifier(this._sessionTableSchema.getTableName()), this._dbAdaptor.convertIdentifier(this._sessionTableSchema.getMaxIntervalColumn()));
                    }
                    catch (SQLException sQLException) {
                        LOG.warn("Problem checking if " + this._sessionTableSchema.getTableName() + " table contains " + this._sessionTableSchema.getMaxIntervalColumn() + " column. Ensure table contains column definition: \"" + this._sessionTableSchema.getMaxIntervalColumn() + " long not null default -999\"", new Object[0]);
                        throw sQLException;
                    }
                    try {
                        if (resultSet.next()) break block76;
                        try {
                            statement.executeUpdate(this._sessionTableSchema.getAlterTableForMaxIntervalAsString());
                        }
                        catch (SQLException sQLException) {
                            LOG.warn("Problem adding " + this._sessionTableSchema.getMaxIntervalColumn() + " column. Ensure table contains column definition: \"" + this._sessionTableSchema.getMaxIntervalColumn() + " long not null default -999\"", new Object[0]);
                            throw sQLException;
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                object2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            object2.close();
                        }
                    }
                }
            }
            object2 = "idx_" + this._sessionTableSchema.getTableName() + "_expiry";
            object = "idx_" + this._sessionTableSchema.getTableName() + "_session";
            boolean bl = false;
            boolean bl2 = false;
            try (ResultSet resultSet = databaseMetaData.getIndexInfo(null, null, string, false, false);){
                while (resultSet.next()) {
                    String string2 = resultSet.getString("INDEX_NAME");
                    if (((String)object2).equalsIgnoreCase(string2)) {
                        bl = true;
                        continue;
                    }
                    if (!((String)object).equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                }
            }
            if (!bl) {
                statement.executeUpdate(this._sessionTableSchema.getCreateIndexOverExpiryStatementAsString((String)object2));
            }
            if (!bl2) {
                statement.executeUpdate(this._sessionTableSchema.getCreateIndexOverSessionStatementAsString((String)object));
            }
            this._insertSession = this._sessionTableSchema.getInsertSessionStatementAsString();
            this._deleteSession = this._sessionTableSchema.getDeleteSessionStatementAsString();
            this._updateSession = this._sessionTableSchema.getUpdateSessionStatementAsString();
            this._updateSessionNode = this._sessionTableSchema.getUpdateSessionNodeStatementAsString();
            this._updateSessionAccessTime = this._sessionTableSchema.getUpdateSessionAccessTimeStatementAsString();
            this._selectBoundedExpiredSessions = this._sessionTableSchema.getBoundedExpiredSessionsStatementAsString();
            this._selectExpiredSessions = this._sessionTableSchema.getSelectExpiredSessionsStatementAsString();
        }
    }

    private void insert(String string) {
        block48: {
            try (Connection connection = this.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(this._queryId);){
                connection.setAutoCommit(true);
                preparedStatement.setString(1, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) break block48;
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement(this._insertId);){
                        preparedStatement2.setString(1, string);
                        preparedStatement2.executeUpdate();
                    }
                }
            }
        }
    }

    private void delete(String string) {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._deleteId);){
            connection.setAutoCommit(true);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean exists(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        block84: {
            Set<String> set = this.getAllCandidateExpiredSessionIds();
            Connection connection = null;
            try {
                block87: {
                    String string;
                    Throwable throwable;
                    ResultSet resultSet;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getWorkerName() + "- Scavenge sweep started at " + System.currentTimeMillis(), new Object[0]);
                    }
                    if (this._lastScavengeTime <= 0L) break block84;
                    connection = this.getConnection();
                    connection.setAutoCommit(true);
                    HashSet<String> hashSet = new HashSet<String>();
                    long l = this._lastScavengeTime - this._scavengeIntervalMs;
                    long l2 = this._lastScavengeTime;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getWorkerName() + "- Pass 1: Searching for sessions expired between " + l + " and " + l2, new Object[0]);
                    }
                    try (PreparedStatement preparedStatement = connection.prepareStatement(this._selectBoundedExpiredSessions);){
                        preparedStatement.setString(1, this.getWorkerName());
                        preparedStatement.setLong(2, l);
                        preparedStatement.setLong(3, l2);
                        resultSet = preparedStatement.executeQuery();
                        throwable = null;
                        try {
                            while (resultSet.next()) {
                                string = resultSet.getString(this._sessionTableSchema.getIdColumn());
                                hashSet.add(string);
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Found expired sessionId=" + string, new Object[0]);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (resultSet != null) {
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                        }
                    }
                    this.scavengeSessions(set, hashSet, false);
                    preparedStatement = connection.prepareStatement(this._selectExpiredSessions);
                    var9_10 = null;
                    try {
                        hashSet.clear();
                        l2 = this._lastScavengeTime - 2L * this._scavengeIntervalMs;
                        if (l2 > 0L) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(this.getWorkerName() + "- Pass 2: Searching for sessions expired before " + l2, new Object[0]);
                            }
                            preparedStatement.setLong(1, l2);
                            resultSet = preparedStatement.executeQuery();
                            throwable = null;
                            try {
                                while (resultSet.next()) {
                                    string = resultSet.getString(this._sessionTableSchema.getIdColumn());
                                    String string2 = resultSet.getString(this._sessionTableSchema.getLastNodeColumn());
                                    if (this.getWorkerName() == null && string2 == null || this.getWorkerName() != null && this.getWorkerName().equals(string2)) {
                                        hashSet.add(string);
                                    }
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug("Found expired sessionId=" + string + " last managed by " + this.getWorkerName(), new Object[0]);
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (resultSet != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        resultSet.close();
                                    }
                                }
                            }
                            this.scavengeSessions(set, hashSet, false);
                        }
                        l2 = this._lastScavengeTime - 3L * this._scavengeIntervalMs;
                        hashSet.clear();
                        if (l2 <= 0L) break block87;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(this.getWorkerName() + "- Pass 3: searching for sessions expired before " + l2, new Object[0]);
                        }
                        preparedStatement.setLong(1, l2);
                        resultSet = preparedStatement.executeQuery();
                        throwable = null;
                        try {
                            while (resultSet.next()) {
                                string = resultSet.getString(this._sessionTableSchema.getIdColumn());
                                hashSet.add(string);
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Found expired sessionId=" + string, new Object[0]);
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (resultSet != null) {
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                        }
                        this.scavengeSessions(set, hashSet, true);
                    }
                    catch (Throwable throwable8) {
                        var9_10 = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (preparedStatement != null) {
                            if (var9_10 != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable9) {
                                    var9_10.addSuppressed(throwable9);
                                }
                            } else {
                                preparedStatement.close();
                            }
                        }
                    }
                }
                this.scavengeSessions(set);
            }
            catch (Exception exception) {
                if (this.isRunning()) {
                    LOG.warn("Problem selecting expired sessions", (Throwable)exception);
                } else {
                    LOG.ignore((Throwable)exception);
                }
            }
            finally {
                this._lastScavengeTime = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getWorkerName() + "- Scavenge sweep ended at " + this._lastScavengeTime, new Object[0]);
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        LOG.warn((Throwable)sQLException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavengeSessions(Set<String> set, Set<String> set2, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(set2);
        Set<SessionManager> set3 = this.getAllSessionManagers();
        for (SessionManager sessionManager : set3) {
            Set<String> set4 = ((JDBCSessionManager)sessionManager).expire(set2);
            if (set4 == null) continue;
            hashSet.removeAll(set4);
            set.removeAll(set4);
        }
        if (!hashSet.isEmpty() && bl) {
            LOG.info("Forcibly deleting unrecoverable expired sessions {}", new Object[]{hashSet});
            try {
                HashSet<String> hashSet2 = this._sessionIds;
                synchronized (hashSet2) {
                    this._sessionIds.removeAll(hashSet);
                }
                this.cleanExpiredSessionIds(hashSet);
            }
            catch (Exception exception) {
                LOG.warn("Error removing expired session ids", (Throwable)exception);
            }
        }
    }

    private void scavengeSessions(Set<String> set) {
        if (set.isEmpty()) {
            return;
        }
        Set<SessionManager> set2 = this.getAllSessionManagers();
        for (SessionManager sessionManager : set2) {
            ((JDBCSessionManager)sessionManager).expireCandidates(set);
        }
    }

    private Set<String> getAllCandidateExpiredSessionIds() {
        HashSet<String> hashSet = new HashSet<String>();
        Set<SessionManager> set = this.getAllSessionManagers();
        for (SessionManager sessionManager : set) {
            hashSet.addAll(((JDBCSessionManager)sessionManager).getCandidateExpiredIds());
        }
        return hashSet;
    }

    private Set<SessionManager> getAllSessionManagers() {
        HashSet<SessionManager> hashSet = new HashSet<SessionManager>();
        Handler[] handlerArray = this._server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
            SessionManager sessionManager;
            SessionHandler sessionHandler = ((ContextHandler)handlerArray[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (sessionManager = sessionHandler.getSessionManager()) == null || !(sessionManager instanceof JDBCSessionManager)) continue;
            hashSet.add(sessionManager);
        }
        return hashSet;
    }

    private void cleanExpiredSessionIds(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        String[] stringArray = set.toArray(new String[set.size()]);
        try (Connection connection = this.getConnection();){
            connection.setTransactionIsolation(2);
            connection.setAutoCommit(false);
            int n = 0;
            int n2 = 0;
            int n3 = this._deleteBlockSize;
            int n4 = 0;
            try (Statement statement = connection.createStatement();){
                while (n2 < stringArray.length) {
                    n = n4 * n3;
                    n2 = stringArray.length - n >= n3 ? n + n3 : stringArray.length;
                    statement.executeUpdate(this.fillInClause("delete from " + this._sessionIdTableSchema.getTableName() + " where " + this._sessionIdTableSchema.getIdColumn() + " in ", stringArray, n, n2));
                    statement.executeUpdate(this.fillInClause("delete from " + this._sessionTableSchema.getTableName() + " where " + this._sessionTableSchema.getIdColumn() + " in ", stringArray, n, n2));
                    ++n4;
                }
            }
            catch (Exception exception) {
                connection.rollback();
                throw exception;
            }
            connection.commit();
        }
    }

    private String fillInClause(String string, String[] stringArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("(");
        for (int i = n; i < n2; ++i) {
            stringBuffer.append("'" + stringArray[i] + "'");
            if (i + 1 >= n2) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void initializeDatabase() {
        if (this._datasource != null) {
            return;
        }
        if (this._jndiName != null) {
            InitialContext initialContext = new InitialContext();
            this._datasource = (DataSource)initialContext.lookup(this._jndiName);
        } else if (this._driver != null && this._connectionUrl != null) {
            DriverManager.registerDriver(this._driver);
        } else if (this._driverClassName != null && this._connectionUrl != null) {
            Class.forName(this._driverClassName);
        } else {
            throw new IllegalStateException("No database configured for sessions");
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        @Override
        public void run() {
            try {
                JDBCSessionIdManager.this.scavenge();
            }
            finally {
                if (JDBCSessionIdManager.this._scheduler != null && JDBCSessionIdManager.this._scheduler.isRunning()) {
                    JDBCSessionIdManager.this._task = JDBCSessionIdManager.this._scheduler.schedule((Runnable)this, JDBCSessionIdManager.this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public static class DatabaseAdaptor {
        String _dbName;
        boolean _isLower;
        boolean _isUpper;
        protected String _blobType;
        protected String _longType;

        public void adaptTo(DatabaseMetaData databaseMetaData) {
            this._dbName = databaseMetaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using database {}", new Object[]{this._dbName});
            }
            this._isLower = databaseMetaData.storesLowerCaseIdentifiers();
            this._isUpper = databaseMetaData.storesUpperCaseIdentifiers();
        }

        public void setBlobType(String string) {
            this._blobType = string;
        }

        public String getBlobType() {
            if (this._blobType != null) {
                return this._blobType;
            }
            if (this._dbName.startsWith("postgres")) {
                return "bytea";
            }
            return "blob";
        }

        public void setLongType(String string) {
            this._longType = string;
        }

        public String getLongType() {
            if (this._longType != null) {
                return this._longType;
            }
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            if (this._dbName.startsWith("oracle")) {
                return "number(20)";
            }
            return "bigint";
        }

        public String convertIdentifier(String string) {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            if (this._isLower) {
                return string.toLowerCase(Locale.ENGLISH);
            }
            if (this._isUpper) {
                return string.toUpperCase(Locale.ENGLISH);
            }
            return string;
        }

        public String getDBName() {
            return this._dbName;
        }

        public InputStream getBlobInputStream(ResultSet resultSet, String string) {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            if (this._dbName.startsWith("postgres")) {
                byte[] byArray = resultSet.getBytes(string);
                return new ByteArrayInputStream(byArray);
            }
            Blob blob = resultSet.getBlob(string);
            return blob.getBinaryStream();
        }

        public boolean isEmptyStringNull() {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            return this._dbName.startsWith("oracle");
        }

        public boolean isRowIdReserved() {
            if (this._dbName == null) {
                throw new IllegalStateException("DbAdaptor missing metadata");
            }
            return this._dbName != null && this._dbName.startsWith("oracle");
        }
    }

    public static class SessionIdTableSchema {
        protected DatabaseAdaptor _dbAdaptor;
        protected String _tableName = "JettySessionIds";
        protected String _idColumn = "id";

        public void setDatabaseAdaptor(DatabaseAdaptor databaseAdaptor) {
            this._dbAdaptor = databaseAdaptor;
        }

        public String getIdColumn() {
            return this._idColumn;
        }

        public void setIdColumn(String string) {
            this.checkNotNull(string);
            this._idColumn = string;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setTableName(String string) {
            this.checkNotNull(string);
            this._tableName = string;
        }

        public String getInsertStatementAsString() {
            return "insert into " + this._tableName + " (" + this._idColumn + ")  values (?)";
        }

        public String getDeleteStatementAsString() {
            return "delete from " + this._tableName + " where " + this._idColumn + " = ?";
        }

        public String getSelectStatementAsString() {
            return "select * from " + this._tableName + " where " + this._idColumn + " = ?";
        }

        public String getCreateStatementAsString() {
            return "create table " + this._tableName + " (" + this._idColumn + " varchar(120), primary key(" + this._idColumn + "))";
        }

        private void checkNotNull(String string) {
            if (string == null) {
                throw new IllegalArgumentException(string);
            }
        }
    }

    public static class SessionTableSchema {
        protected DatabaseAdaptor _dbAdaptor;
        protected String _tableName = "JettySessions";
        protected String _rowIdColumn = "rowId";
        protected String _idColumn = "sessionId";
        protected String _contextPathColumn = "contextPath";
        protected String _virtualHostColumn = "virtualHost";
        protected String _lastNodeColumn = "lastNode";
        protected String _accessTimeColumn = "accessTime";
        protected String _lastAccessTimeColumn = "lastAccessTime";
        protected String _createTimeColumn = "createTime";
        protected String _cookieTimeColumn = "cookieTime";
        protected String _lastSavedTimeColumn = "lastSavedTime";
        protected String _expiryTimeColumn = "expiryTime";
        protected String _maxIntervalColumn = "maxInterval";
        protected String _mapColumn = "map";

        protected void setDatabaseAdaptor(DatabaseAdaptor databaseAdaptor) {
            this._dbAdaptor = databaseAdaptor;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setTableName(String string) {
            this.checkNotNull(string);
            this._tableName = string;
        }

        public String getRowIdColumn() {
            if ("rowId".equals(this._rowIdColumn) && this._dbAdaptor.isRowIdReserved()) {
                this._rowIdColumn = "srowId";
            }
            return this._rowIdColumn;
        }

        public void setRowIdColumn(String string) {
            this.checkNotNull(string);
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("DbAdaptor is null");
            }
            if (this._dbAdaptor.isRowIdReserved() && "rowId".equals(string)) {
                throw new IllegalArgumentException("rowId is reserved word for Oracle");
            }
            this._rowIdColumn = string;
        }

        public String getIdColumn() {
            return this._idColumn;
        }

        public void setIdColumn(String string) {
            this.checkNotNull(string);
            this._idColumn = string;
        }

        public String getContextPathColumn() {
            return this._contextPathColumn;
        }

        public void setContextPathColumn(String string) {
            this.checkNotNull(string);
            this._contextPathColumn = string;
        }

        public String getVirtualHostColumn() {
            return this._virtualHostColumn;
        }

        public void setVirtualHostColumn(String string) {
            this.checkNotNull(string);
            this._virtualHostColumn = string;
        }

        public String getLastNodeColumn() {
            return this._lastNodeColumn;
        }

        public void setLastNodeColumn(String string) {
            this.checkNotNull(string);
            this._lastNodeColumn = string;
        }

        public String getAccessTimeColumn() {
            return this._accessTimeColumn;
        }

        public void setAccessTimeColumn(String string) {
            this.checkNotNull(string);
            this._accessTimeColumn = string;
        }

        public String getLastAccessTimeColumn() {
            return this._lastAccessTimeColumn;
        }

        public void setLastAccessTimeColumn(String string) {
            this.checkNotNull(string);
            this._lastAccessTimeColumn = string;
        }

        public String getCreateTimeColumn() {
            return this._createTimeColumn;
        }

        public void setCreateTimeColumn(String string) {
            this.checkNotNull(string);
            this._createTimeColumn = string;
        }

        public String getCookieTimeColumn() {
            return this._cookieTimeColumn;
        }

        public void setCookieTimeColumn(String string) {
            this.checkNotNull(string);
            this._cookieTimeColumn = string;
        }

        public String getLastSavedTimeColumn() {
            return this._lastSavedTimeColumn;
        }

        public void setLastSavedTimeColumn(String string) {
            this.checkNotNull(string);
            this._lastSavedTimeColumn = string;
        }

        public String getExpiryTimeColumn() {
            return this._expiryTimeColumn;
        }

        public void setExpiryTimeColumn(String string) {
            this.checkNotNull(string);
            this._expiryTimeColumn = string;
        }

        public String getMaxIntervalColumn() {
            return this._maxIntervalColumn;
        }

        public void setMaxIntervalColumn(String string) {
            this.checkNotNull(string);
            this._maxIntervalColumn = string;
        }

        public String getMapColumn() {
            return this._mapColumn;
        }

        public void setMapColumn(String string) {
            this.checkNotNull(string);
            this._mapColumn = string;
        }

        public String getCreateStatementAsString() {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String string = this._dbAdaptor.getBlobType();
            String string2 = this._dbAdaptor.getLongType();
            return "create table " + this._tableName + " (" + this.getRowIdColumn() + " varchar(120), " + this._idColumn + " varchar(120), " + this._contextPathColumn + " varchar(60), " + this._virtualHostColumn + " varchar(60), " + this._lastNodeColumn + " varchar(60), " + this._accessTimeColumn + " " + string2 + ", " + this._lastAccessTimeColumn + " " + string2 + ", " + this._createTimeColumn + " " + string2 + ", " + this._cookieTimeColumn + " " + string2 + ", " + this._lastSavedTimeColumn + " " + string2 + ", " + this._expiryTimeColumn + " " + string2 + ", " + this._maxIntervalColumn + " " + string2 + ", " + this._mapColumn + " " + string + ", primary key(" + this.getRowIdColumn() + "))";
        }

        public String getCreateIndexOverExpiryStatementAsString(String string) {
            return "create index " + string + " on " + this.getTableName() + " (" + this.getExpiryTimeColumn() + ")";
        }

        public String getCreateIndexOverSessionStatementAsString(String string) {
            return "create index " + string + " on " + this.getTableName() + " (" + this.getIdColumn() + ", " + this.getContextPathColumn() + ")";
        }

        public String getAlterTableForMaxIntervalAsString() {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String string = this._dbAdaptor.getLongType();
            String string2 = "alter table " + this.getTableName() + " add " + this.getMaxIntervalColumn() + " " + string;
            if (this._dbAdaptor.getDBName().contains("oracle")) {
                return string2 + " default " + -999 + " not null";
            }
            return string2 + " not null default " + -999;
        }

        private void checkNotNull(String string) {
            if (string == null) {
                throw new IllegalArgumentException(string);
            }
        }

        public String getInsertSessionStatementAsString() {
            return "insert into " + this.getTableName() + " (" + this.getRowIdColumn() + ", " + this.getIdColumn() + ", " + this.getContextPathColumn() + ", " + this.getVirtualHostColumn() + ", " + this.getLastNodeColumn() + ", " + this.getAccessTimeColumn() + ", " + this.getLastAccessTimeColumn() + ", " + this.getCreateTimeColumn() + ", " + this.getCookieTimeColumn() + ", " + this.getLastSavedTimeColumn() + ", " + this.getExpiryTimeColumn() + ", " + this.getMaxIntervalColumn() + ", " + this.getMapColumn() + ") " + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }

        public String getDeleteSessionStatementAsString() {
            return "delete from " + this.getTableName() + " where " + this.getRowIdColumn() + " = ?";
        }

        public String getUpdateSessionStatementAsString() {
            return "update " + this.getTableName() + " set " + this.getIdColumn() + " = ?, " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ?, " + this.getMapColumn() + " = ? where " + this.getRowIdColumn() + " = ?";
        }

        public String getUpdateSessionNodeStatementAsString() {
            return "update " + this.getTableName() + " set " + this.getLastNodeColumn() + " = ? where " + this.getRowIdColumn() + " = ?";
        }

        public String getUpdateSessionAccessTimeStatementAsString() {
            return "update " + this.getTableName() + " set " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ? where " + this.getRowIdColumn() + " = ?";
        }

        public String getBoundedExpiredSessionsStatementAsString() {
            return "select * from " + this.getTableName() + " where " + this.getLastNodeColumn() + " = ? and " + this.getExpiryTimeColumn() + " >= ? and " + this.getExpiryTimeColumn() + " <= ?";
        }

        public String getSelectExpiredSessionsStatementAsString() {
            return "select * from " + this.getTableName() + " where " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?";
        }

        public PreparedStatement getLoadStatement(Connection connection, String string, String string2, String string3) {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            if ((string2 == null || "".equals(string2)) && this._dbAdaptor.isEmptyStringNull()) {
                PreparedStatement preparedStatement = connection.prepareStatement("select * from " + this.getTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " is null and " + this.getVirtualHostColumn() + " = ?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                return preparedStatement;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("select * from " + this.getTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            return preparedStatement;
        }
    }
}

