/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.MemSession;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HashedSession
extends MemSession {
    private static final Logger LOG = Log.getLogger(HashedSession.class);
    private final HashSessionManager _hashSessionManager;
    private transient boolean _idled = false;
    private transient boolean _saveFailed = false;
    private transient boolean _deIdleFailed = false;

    protected HashedSession(HashSessionManager hashSessionManager, HttpServletRequest httpServletRequest) {
        super(hashSessionManager, httpServletRequest);
        this._hashSessionManager = hashSessionManager;
    }

    protected HashedSession(HashSessionManager hashSessionManager, long l, long l2, String string) {
        super(hashSessionManager, l, l2, string);
        this._hashSessionManager = hashSessionManager;
    }

    @Override
    protected void checkValid() {
        if (!this._deIdleFailed && this._hashSessionManager._idleSavePeriodMs != 0L) {
            this.deIdle();
        }
        super.checkValid();
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        super.setMaxInactiveInterval(n);
        if (this.getMaxInactiveInterval() > 0 && (long)this.getMaxInactiveInterval() * 1000L / 10L < this._hashSessionManager._scavengePeriodMs) {
            this._hashSessionManager.setScavengePeriod((n + 9) / 10);
        }
    }

    @Override
    protected void doInvalidate() {
        super.doInvalidate();
        this.remove();
    }

    synchronized void remove() {
        if (this._hashSessionManager._storeDir != null && this.getId() != null) {
            String string = this.getId();
            File file = new File(this._hashSessionManager._storeDir, string);
            file.delete();
        }
    }

    synchronized void save(boolean bl) {
        if (!this.isIdled() && !this._saveFailed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving {} {}", new Object[]{super.getId(), bl});
            }
            try {
                this.willPassivate();
                this.save();
                if (bl) {
                    this.didActivate();
                } else {
                    this.clearAttributes();
                }
            }
            catch (Exception exception) {
                LOG.warn("Problem saving session " + super.getId(), (Throwable)exception);
                this._idled = false;
            }
        }
    }

    synchronized void save() {
        File file = null;
        if (!this._saveFailed && this._hashSessionManager._storeDir != null) {
            file = new File(this._hashSessionManager._storeDir, super.getId());
            if (file.exists()) {
                file.delete();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file, false);){
                this.save(fileOutputStream);
            }
            catch (Exception exception) {
                this.saveFailed();
                if (file != null) {
                    file.delete();
                }
                throw exception;
            }
        }
    }

    public synchronized void save(OutputStream outputStream) {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeUTF(this.getClusterId());
        dataOutputStream.writeUTF(this.getNodeId());
        dataOutputStream.writeLong(this.getCreationTime());
        dataOutputStream.writeLong(this.getAccessed());
        dataOutputStream.writeInt(this.getRequests());
        dataOutputStream.writeInt(this.getAttributes());
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
        Enumeration<String> enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            objectOutputStream.writeUTF(string);
            objectOutputStream.writeObject(this.doGet(string));
        }
        dataOutputStream.writeInt(this.getMaxInactiveInterval());
    }

    public synchronized void deIdle() {
        if (this.isIdled() && !this._deIdleFailed) {
            this.access(System.currentTimeMillis());
            if (LOG.isDebugEnabled()) {
                LOG.debug("De-idling " + super.getId(), new Object[0]);
            }
            FileInputStream fileInputStream = null;
            try {
                File file = new File(this._hashSessionManager._storeDir, super.getId());
                if (!file.exists() || !file.canRead()) {
                    throw new FileNotFoundException(file.getName());
                }
                fileInputStream = new FileInputStream(file);
                this._idled = false;
                this._hashSessionManager.restoreSession(fileInputStream, this);
                IO.close((InputStream)fileInputStream);
                this.didActivate();
                if (this._hashSessionManager._savePeriodMs == 0L) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                this.deIdleFailed();
                LOG.warn("Problem de-idling session " + super.getId(), (Throwable)exception);
                if (fileInputStream != null) {
                    IO.close((InputStream)fileInputStream);
                }
                this.invalidate();
            }
        }
    }

    public synchronized void idle() {
        this.save(false);
        this._idled = true;
    }

    public synchronized boolean isIdled() {
        return this._idled;
    }

    public synchronized boolean isSaveFailed() {
        return this._saveFailed;
    }

    public synchronized void saveFailed() {
        this._saveFailed = true;
    }

    public synchronized void deIdleFailed() {
        this._deIdleFailed = true;
    }

    public synchronized boolean isDeIdleFailed() {
        return this._deIdleFailed;
    }
}

