/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class HashSessionManager
extends AbstractSessionManager {
    static final Logger LOG = SessionHandler.LOG;
    protected final ConcurrentMap<String, HashedSession> _sessions = new ConcurrentHashMap<String, HashedSession>();
    private Scheduler _timer;
    private Scheduler.Task _task;
    long _scavengePeriodMs = 30000L;
    long _savePeriodMs = 0L;
    long _idleSavePeriodMs = 0L;
    private Scheduler.Task _saveTask;
    File _storeDir;
    private boolean _lazyLoad = false;
    private volatile boolean _sessionsLoaded = false;
    private boolean _deleteUnrestorableSessions = false;

    @Override
    public void doStart() {
        ContextHandler.Context context;
        this._timer = (Scheduler)this.getSessionHandler().getServer().getBean(Scheduler.class);
        if (this._timer == null && (context = ContextHandler.getCurrentContext()) != null) {
            this._timer = (Scheduler)context.getAttribute("org.eclipse.jetty.server.session.timer");
        }
        if (this._timer == null) {
            this._timer = new ScheduledExecutorScheduler(this.toString() + "Timer", true);
            this.addBean(this._timer, true);
        } else {
            this.addBean(this._timer, false);
        }
        super.doStart();
        this.setScavengePeriod(this.getScavengePeriod());
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdirs();
            }
            if (!this._lazyLoad) {
                this.restoreSessions();
            }
        }
        this.setSavePeriod(this.getSavePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._saveTask != null) {
                this._saveTask.cancel();
            }
            this._saveTask = null;
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this.isManaged(this._timer)) {
                this.removeBean(this._timer);
            }
            this._timer = null;
        }
        super.doStop();
        this._sessions.clear();
    }

    public int getScavengePeriod() {
        return (int)(this._scavengePeriodMs / 1000L);
    }

    @Override
    public int getSessions() {
        int n = super.getSessions();
        if (LOG.isDebugEnabled() && this._sessions.size() != n) {
            LOG.warn("sessions: " + this._sessions.size() + "!=" + n, new Object[0]);
        }
        return n;
    }

    public int getIdleSavePeriod() {
        if (this._idleSavePeriodMs <= 0L) {
            return 0;
        }
        return (int)(this._idleSavePeriodMs / 1000L);
    }

    public void setIdleSavePeriod(int n) {
        this._idleSavePeriodMs = (long)n * 1000L;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        super.setMaxInactiveInterval(n);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > (long)this._dftMaxIdleSecs * 1000L) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePeriod(int n) {
        long l = (long)n * 1000L;
        if (l < 0L) {
            l = 0L;
        }
        this._savePeriodMs = l;
        if (this._timer != null) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._saveTask != null) {
                    this._saveTask.cancel();
                }
                this._saveTask = null;
                if (this._savePeriodMs > 0L && this._storeDir != null) {
                    this._saveTask = this._timer.schedule((Runnable)new Saver(), this._savePeriodMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public int getSavePeriod() {
        if (this._savePeriodMs <= 0L) {
            return 0;
        }
        return (int)(this._savePeriodMs / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int n) {
        if (n == 0) {
            n = 60;
        }
        long l = this._scavengePeriodMs;
        long l2 = (long)n * 1000L;
        if (l2 > 60000L) {
            l2 = 60000L;
        }
        if (l2 < 1000L) {
            l2 = 1000L;
        }
        this._scavengePeriodMs = l2;
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._timer != null && (l2 != l || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                    this._task = null;
                }
                this._task = this._timer.schedule((Runnable)new Scavenger(), this._scavengePeriodMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long l = System.currentTimeMillis();
            __log.debug("Scavenging sessions at {}", l);
            for (HashedSession hashedSession : this._sessions.values()) {
                long l2 = (long)hashedSession.getMaxInactiveInterval() * 1000L;
                if (l2 > 0L && hashedSession.getAccessed() + l2 < l) {
                    try {
                        hashedSession.timeout();
                    }
                    catch (Exception exception) {
                        __log.warn("Problem scavenging sessions", (Throwable)exception);
                    }
                    continue;
                }
                if (this._idleSavePeriodMs <= 0L || hashedSession.getAccessed() + this._idleSavePeriodMs >= l) continue;
                try {
                    hashedSession.idle();
                }
                catch (Exception exception) {
                    __log.warn("Problem idling session " + hashedSession.getId(), (Throwable)exception);
                }
            }
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    @Override
    protected void addSession(AbstractSession abstractSession) {
        if (this.isRunning()) {
            this._sessions.put(abstractSession.getClusterId(), (HashedSession)abstractSession);
        }
    }

    @Override
    public AbstractSession getSession(String string) {
        ConcurrentMap<String, HashedSession> concurrentMap;
        if (this._lazyLoad && !this._sessionsLoaded) {
            try {
                this.restoreSessions();
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
        }
        if ((concurrentMap = this._sessions) == null) {
            return null;
        }
        HashedSession hashedSession = (HashedSession)concurrentMap.get(string);
        if (hashedSession == null && this._lazyLoad) {
            hashedSession = this.restoreSession(string);
        }
        if (hashedSession == null) {
            return null;
        }
        if (this._idleSavePeriodMs != 0L) {
            hashedSession.deIdle();
        }
        return hashedSession;
    }

    @Override
    protected void shutdownSessions() {
        ArrayList arrayList = new ArrayList(this._sessions.values());
        int n = 100;
        while (arrayList.size() > 0 && n-- > 0) {
            if (this.isStopping() && this._storeDir != null && this._storeDir.exists() && this._storeDir.canWrite()) {
                for (HashedSession hashedSession : arrayList) {
                    hashedSession.save(false);
                    this._sessions.remove(hashedSession.getClusterId());
                }
            } else {
                for (HashedSession hashedSession : arrayList) {
                    hashedSession.invalidate();
                }
            }
            arrayList = new ArrayList(this._sessions.values());
        }
    }

    @Override
    public void renewSessionId(String string, String string2, String string3, String string4) {
        try {
            ConcurrentMap<String, HashedSession> concurrentMap = this._sessions;
            if (concurrentMap == null) {
                return;
            }
            HashedSession hashedSession = (HashedSession)concurrentMap.remove(string);
            if (hashedSession == null) {
                return;
            }
            hashedSession.remove();
            hashedSession.setClusterId(string3);
            hashedSession.setNodeId(string4);
            hashedSession.save();
            concurrentMap.put(string3, hashedSession);
            super.renewSessionId(string, string2, string3, string4);
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
        }
    }

    @Override
    protected AbstractSession newSession(HttpServletRequest httpServletRequest) {
        return new HashedSession(this, httpServletRequest);
    }

    protected AbstractSession newSession(long l, long l2, String string) {
        return new HashedSession(this, l, l2, string);
    }

    @Override
    protected boolean removeSession(String string) {
        return this._sessions.remove(string) != null;
    }

    public void setStoreDirectory(File file) {
        this._storeDir = file.getCanonicalFile();
    }

    public File getStoreDirectory() {
        return this._storeDir;
    }

    public void setLazyLoad(boolean bl) {
        this._lazyLoad = bl;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public boolean isDeleteUnrestorableSessions() {
        return this._deleteUnrestorableSessions;
    }

    public void setDeleteUnrestorableSessions(boolean bl) {
        this._deleteUnrestorableSessions = bl;
    }

    public void restoreSessions() {
        this._sessionsLoaded = true;
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            LOG.warn("Unable to restore Sessions: Cannot read from Session storage directory " + this._storeDir.getAbsolutePath(), new Object[0]);
            return;
        }
        String[] stringArray = this._storeDir.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.restoreSession(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized HashedSession restoreSession(String string) {
        HashedSession hashedSession;
        Throwable throwable;
        FileInputStream fileInputStream;
        Exception exception;
        File file;
        block30: {
            block28: {
                block29: {
                    block26: {
                        block27: {
                            file = new File(this._storeDir, string);
                            exception = null;
                            if (!file.exists()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Not loading: {}", new Object[]{file});
                                }
                                return null;
                            }
                            fileInputStream = new FileInputStream(file);
                            throwable = null;
                            HashedSession hashedSession2 = this.restoreSession(fileInputStream, null);
                            this.addSession(hashedSession2, false);
                            hashedSession2.didActivate();
                            hashedSession = hashedSession2;
                            if (fileInputStream == null) break block26;
                            if (throwable == null) break block27;
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block26;
                        }
                        fileInputStream.close();
                    }
                    if (exception == null) break block28;
                    if (!this.isDeleteUnrestorableSessions() || !file.exists() || !file.getParentFile().equals(this._storeDir)) break block29;
                    file.delete();
                    LOG.warn("Deleting file for unrestorable session {} {}", new Object[]{string, exception});
                    __log.debug((Throwable)exception);
                    break block30;
                }
                __log.warn("Problem restoring session {} {}", new Object[]{string, exception});
                __log.debug((Throwable)exception);
                break block30;
            }
            file.delete();
        }
        return hashedSession;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (fileInputStream != null) {
                                if (throwable != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    fileInputStream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (exception != null) {
                            if (this.isDeleteUnrestorableSessions() && file.exists() && file.getParentFile().equals(this._storeDir)) {
                                file.delete();
                                LOG.warn("Deleting file for unrestorable session {} {}", new Object[]{string, exception});
                                __log.debug((Throwable)exception);
                            } else {
                                __log.warn("Problem restoring session {} {}", new Object[]{string, exception});
                                __log.debug((Throwable)exception);
                            }
                        } else {
                            file.delete();
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (exception != null) {
                        if (this.isDeleteUnrestorableSessions() && file.exists() && file.getParentFile().equals(this._storeDir)) {
                            file.delete();
                            LOG.warn("Deleting file for unrestorable session {} {}", new Object[]{string, exception});
                            __log.debug((Throwable)exception);
                        } else {
                            __log.warn("Problem restoring session {} {}", new Object[]{string, exception});
                            __log.debug((Throwable)exception);
                        }
                    } else {
                        file.delete();
                    }
                    throw throwable6;
                }
            }
        }
        return null;
    }

    public void saveSessions(boolean bl) {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            LOG.warn("Unable to save Sessions: Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable", new Object[0]);
            return;
        }
        for (HashedSession hashedSession : this._sessions.values()) {
            hashedSession.save(bl);
        }
    }

    public HashedSession restoreSession(InputStream inputStream, HashedSession hashedSession) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = dataInputStream.readUTF();
        dataInputStream.readUTF();
        long l = dataInputStream.readLong();
        long l2 = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        if (hashedSession == null) {
            hashedSession = (HashedSession)this.newSession(l, l2, string);
        }
        hashedSession.setRequests(n);
        int n2 = dataInputStream.readInt();
        this.restoreSessionAttributes(dataInputStream, n2, hashedSession);
        try {
            int n3 = dataInputStream.readInt();
            hashedSession.setMaxInactiveInterval(n3);
        }
        catch (IOException iOException) {
            LOG.debug("No maxInactiveInterval persisted for session " + string, new Object[0]);
            LOG.ignore((Throwable)iOException);
        }
        return hashedSession;
    }

    private void restoreSessionAttributes(InputStream inputStream, int n, HashedSession hashedSession) {
        if (n > 0) {
            ClassLoadingObjectInputStream classLoadingObjectInputStream = new ClassLoadingObjectInputStream(inputStream);
            for (int i = 0; i < n; ++i) {
                String string = classLoadingObjectInputStream.readUTF();
                Object object = classLoadingObjectInputStream.readObject();
                hashedSession.setAttribute(string, object);
            }
        }
    }

    protected class Saver
    implements Runnable {
        protected Saver() {
        }

        @Override
        public void run() {
            try {
                HashSessionManager.this.saveSessions(true);
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
            finally {
                if (HashSessionManager.this._timer != null && HashSessionManager.this._timer.isRunning()) {
                    HashSessionManager.this._saveTask = HashSessionManager.this._timer.schedule((Runnable)this, HashSessionManager.this._savePeriodMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        @Override
        public void run() {
            try {
                HashSessionManager.this.scavenge();
            }
            finally {
                if (HashSessionManager.this._timer != null && HashSessionManager.this._timer.isRunning()) {
                    HashSessionManager.this._task = HashSessionManager.this._timer.schedule((Runnable)this, HashSessionManager.this._scavengePeriodMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

