/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;

public class HashSessionIdManager
extends AbstractSessionIdManager {
    private final Map<String, Set<WeakReference<HttpSession>>> _sessions = new HashMap<String, Set<WeakReference<HttpSession>>>();

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        super(random);
    }

    public Collection<String> getSessions() {
        return Collections.unmodifiableCollection(this._sessions.keySet());
    }

    public Collection<HttpSession> getSession(String string) {
        ArrayList<HttpSession> arrayList = new ArrayList<HttpSession>();
        Set<WeakReference<HttpSession>> set = this._sessions.get(string);
        if (set != null) {
            for (WeakReference<HttpSession> weakReference : set) {
                HttpSession httpSession = (HttpSession)weakReference.get();
                if (httpSession == null) continue;
                arrayList.add(httpSession);
            }
        }
        return arrayList;
    }

    @Override
    protected void doStart() {
        super.doStart();
    }

    @Override
    protected void doStop() {
        this._sessions.clear();
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idInUse(String string) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            return this._sessions.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession httpSession) {
        String string = this.getClusterId(httpSession.getId());
        WeakReference<HttpSession> weakReference = new WeakReference<HttpSession>(httpSession);
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Set<WeakReference<HttpSession>> set = this._sessions.get(string);
            if (set == null) {
                set = new HashSet<WeakReference<HttpSession>>();
                this._sessions.put(string, set);
            }
            set.add(weakReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(HttpSession httpSession) {
        String string = this.getClusterId(httpSession.getId());
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Collection collection = this._sessions.get(string);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    HttpSession httpSession2 = (HttpSession)weakReference.get();
                    if (httpSession2 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (httpSession2 != httpSession) continue;
                    iterator.remove();
                    break;
                }
                if (collection.isEmpty()) {
                    this._sessions.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String string) {
        Collection collection;
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            collection = this._sessions.remove(string);
        }
        if (collection != null) {
            for (WeakReference weakReference : collection) {
                AbstractSession abstractSession = (AbstractSession)weakReference.get();
                if (abstractSession == null || !abstractSession.isValid()) continue;
                abstractSession.invalidate();
            }
            collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String string, String string2, HttpServletRequest httpServletRequest) {
        String string3 = this.newSessionId(httpServletRequest.hashCode());
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Set<WeakReference<HttpSession>> set = this._sessions.remove(string);
            if (set != null) {
                for (WeakReference<HttpSession> weakReference : set) {
                    HttpSession httpSession = (HttpSession)weakReference.get();
                    if (httpSession == null || !(httpSession instanceof AbstractSession)) continue;
                    AbstractSession abstractSession = (AbstractSession)httpSession;
                    abstractSession.getSessionManager().renewSessionId(string, string2, string3, this.getNodeId(string3, httpServletRequest));
                }
                this._sessions.put(string3, set);
            }
        }
    }
}

