/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Abstract Session Manager")
public abstract class AbstractSessionManager
extends ContainerLifeCycle
implements SessionManager {
    static final Logger __log = SessionHandler.LOG;
    public Set<SessionTrackingMode> __defaultSessionTrackingModes = Collections.unmodifiableSet(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
    public static final int __distantFuture = 628992000;
    static final HttpSessionContext __nullSessionContext = new HttpSessionContext(){

        public HttpSession getSession(String string) {
            return null;
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    };
    private boolean _usingCookies = true;
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected boolean _secureRequestOnly = true;
    protected final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    protected final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    protected final List<HttpSessionIdListener> _sessionIdListeners = new CopyOnWriteArrayList<HttpSessionIdListener>();
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected String _sessionComment;
    public Set<SessionTrackingMode> _sessionTrackingModes;
    private boolean _usingURLs;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private SessionCookieConfig _cookieConfig = new CookieConfig();

    public AbstractSessionManager() {
        this.setSessionTrackingModes(this.__defaultSessionTrackingModes);
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ContextHandler getContextHandler() {
        return this._context.getContextHandler();
    }

    @ManagedAttribute(value="path of the session cookie, or null for default")
    public String getSessionPath() {
        return this._sessionPath;
    }

    @ManagedAttribute(value="if greater the zero, the time in seconds a session cookie will last for")
    public int getMaxCookieAge() {
        return this._maxCookieAge;
    }

    @Override
    public HttpCookie access(HttpSession httpSession, boolean bl) {
        long l = System.currentTimeMillis();
        AbstractSession abstractSession = ((SessionIf)httpSession).getSession();
        if (abstractSession.access(l) && this.isUsingCookies() && (abstractSession.isIdChanged() || this.getSessionCookieConfig().getMaxAge() > 0 && this.getRefreshCookieAge() > 0 && (l - abstractSession.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie httpCookie = this.getSessionCookie(httpSession, this._context == null ? "/" : this._context.getContextPath(), bl);
            abstractSession.cookieSet();
            abstractSession.setIdChanged(false);
            return httpCookie;
        }
        return null;
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        if (eventListener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add((HttpSessionAttributeListener)eventListener);
        }
        if (eventListener instanceof HttpSessionListener) {
            this._sessionListeners.add((HttpSessionListener)eventListener);
        }
        if (eventListener instanceof HttpSessionIdListener) {
            this._sessionIdListeners.add((HttpSessionIdListener)eventListener);
        }
        this.addBean(eventListener, false);
    }

    @Override
    public void clearEventListeners() {
        for (EventListener eventListener : this.getBeans(EventListener.class)) {
            this.removeBean(eventListener);
        }
        this._sessionAttributeListeners.clear();
        this._sessionListeners.clear();
        this._sessionIdListeners.clear();
    }

    @Override
    public void complete(HttpSession httpSession) {
        AbstractSession abstractSession = ((SessionIf)httpSession).getSession();
        abstractSession.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        Server server = this.getSessionHandler().getServer();
        Object object = server;
        synchronized (object) {
            if (this._sessionIdManager == null) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    ClassLoader classLoader = server.getClass().getClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(classLoader);
                        this._sessionIdManager = new HashSessionIdManager();
                        server.setSessionIdManager(this._sessionIdManager);
                        server.manage(this._sessionIdManager);
                        this._sessionIdManager.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(this._loader);
                    }
                }
                this.addBean(this._sessionIdManager, false);
            }
        }
        if (this._context != null) {
            object = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie");
            if (object != null) {
                this._sessionCookie = object;
            }
            if ((object = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
                this.setSessionIdPathParameterName((String)object);
            }
            if (this._maxCookieAge == -1 && (object = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
                this._maxCookieAge = Integer.parseInt(((String)object).trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
            }
            if (this._sessionPath == null) {
                this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
            }
            if ((object = this._context.getInitParameter("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean((String)object);
            }
        }
        super.doStart();
    }

    public void doStop() {
        super.doStop();
        this.shutdownSessions();
        this._loader = null;
    }

    @Override
    @ManagedAttribute(value="true if cookies use the http only flag")
    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    @Override
    public HttpSession getHttpSession(String string) {
        String string2 = this.getSessionIdManager().getClusterId(string);
        AbstractSession abstractSession = this.getSession(string2);
        if (abstractSession != null && !abstractSession.getNodeId().equals(string)) {
            abstractSession.setIdChanged(true);
        }
        return abstractSession;
    }

    @Override
    @ManagedAttribute(value="Session ID Manager")
    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    @Override
    @ManagedAttribute(value="defailt maximum time a session may be idle for (in s)")
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @ManagedAttribute(value="maximum number of simultaneous sessions")
    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    @ManagedAttribute(value="total number of sessions")
    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @ManagedAttribute(value="time before a session cookie is re-set (in s)")
    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @ManagedAttribute(value="if true, secure cookie flag is set on session cookies")
    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public boolean isSecureRequestOnly() {
        return this._secureRequestOnly;
    }

    public void setSecureRequestOnly(boolean bl) {
        this._secureRequestOnly = bl;
    }

    @ManagedAttribute(value="the set session cookie")
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    @Override
    public HttpCookie getSessionCookie(HttpSession httpSession, String string, boolean bl) {
        if (this.isUsingCookies()) {
            String string2 = this._cookieConfig.getPath() == null ? string : this._cookieConfig.getPath();
            string2 = string2 == null || string2.length() == 0 ? "/" : string2;
            String string3 = this.getNodeId(httpSession);
            HttpCookie httpCookie = null;
            httpCookie = this._sessionComment == null ? new HttpCookie(this._cookieConfig.getName(), string3, this._cookieConfig.getDomain(), string2, (long)this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure() || this.isSecureRequestOnly() && bl) : new HttpCookie(this._cookieConfig.getName(), string3, this._cookieConfig.getDomain(), string2, (long)this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure() || this.isSecureRequestOnly() && bl, this._sessionComment, 1);
            return httpCookie;
        }
        return null;
    }

    @ManagedAttribute(value="domain of the session cookie, or null for the default")
    public String getSessionDomain() {
        return this._sessionDomain;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    @ManagedAttribute(value="number of currently active sessions")
    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    @Override
    @ManagedAttribute(value="name of use for URL session tracking")
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public boolean isValid(HttpSession httpSession) {
        AbstractSession abstractSession = ((SessionIf)httpSession).getSession();
        return abstractSession.isValid();
    }

    @Override
    public String getClusterId(HttpSession httpSession) {
        AbstractSession abstractSession = ((SessionIf)httpSession).getSession();
        return abstractSession.getClusterId();
    }

    @Override
    public String getNodeId(HttpSession httpSession) {
        AbstractSession abstractSession = ((SessionIf)httpSession).getSession();
        return abstractSession.getNodeId();
    }

    @Override
    public HttpSession newHttpSession(HttpServletRequest httpServletRequest) {
        AbstractSession abstractSession = this.newSession(httpServletRequest);
        abstractSession.setMaxInactiveInterval(this._dftMaxIdleSecs);
        if (httpServletRequest.isSecure()) {
            abstractSession.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
        }
        this.addSession(abstractSession, true);
        return abstractSession;
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        if (eventListener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(eventListener);
        }
        if (eventListener instanceof HttpSessionListener) {
            this._sessionListeners.remove(eventListener);
        }
        if (eventListener instanceof HttpSessionIdListener) {
            this._sessionIdListeners.remove(eventListener);
        }
        this.removeBean(eventListener);
    }

    @ManagedOperation(value="reset statistics", impact="ACTION")
    public void statsReset() {
        this._sessionsStats.reset((long)this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean bl) {
        this._httpOnly = bl;
    }

    @Override
    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this.updateBean(this._sessionIdManager, sessionIdManager);
        this._sessionIdManager = sessionIdManager;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this._dftMaxIdleSecs = n;
    }

    public void setRefreshCookieAge(int n) {
        this._refreshCookieAge = n;
    }

    public void setSessionCookie(String string) {
        this._sessionCookie = string;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    @Override
    public void setSessionIdPathParameterName(String string) {
        this._sessionIdPathParameterName = string == null || "none".equals(string) ? null : string;
        this._sessionIdPathParameterNamePrefix = string == null || "none".equals(string) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    public void setUsingCookies(boolean bl) {
        this._usingCookies = bl;
    }

    protected abstract void addSession(AbstractSession var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSession abstractSession, boolean bl) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(abstractSession);
            this.addSession(abstractSession);
        }
        if (bl) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                sessionIdManager = new HttpSessionEvent((HttpSession)abstractSession);
                for (HttpSessionListener httpSessionListener : this._sessionListeners) {
                    httpSessionListener.sessionCreated((HttpSessionEvent)sessionIdManager);
                }
            }
        }
    }

    public abstract AbstractSession getSession(String var1);

    protected abstract void shutdownSessions();

    protected abstract AbstractSession newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean bl) {
        this._nodeIdInSessionId = bl;
    }

    public void removeSession(HttpSession httpSession, boolean bl) {
        AbstractSession abstractSession = ((SessionIf)httpSession).getSession();
        this.removeSession(abstractSession, bl);
    }

    public boolean removeSession(AbstractSession abstractSession, boolean bl) {
        boolean bl2 = this.removeSession(abstractSession.getClusterId());
        if (bl2) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - abstractSession.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(abstractSession);
            if (bl) {
                this._sessionIdManager.invalidateAll(abstractSession.getClusterId());
            }
            if (bl && this._sessionListeners != null) {
                HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)abstractSession);
                for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                    this._sessionListeners.get(i).sessionDestroyed(httpSessionEvent);
                }
            }
        }
        return bl2;
    }

    protected abstract boolean removeSession(String var1);

    @ManagedAttribute(value="maximum amount of time sessions have remained active (in s)")
    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.__defaultSessionTrackingModes;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.unmodifiableSet(this._sessionTrackingModes);
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
        this._sessionTrackingModes = new HashSet<SessionTrackingMode>(set);
        this._usingCookies = this._sessionTrackingModes.contains(SessionTrackingMode.COOKIE);
        this._usingURLs = this._sessionTrackingModes.contains(SessionTrackingMode.URL);
    }

    @Override
    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    @ManagedAttribute(value="total time sessions have remained valid")
    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time sessions remain valid (in s)")
    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation a session remained valid (in s)")
    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @Override
    @ManagedAttribute(value="check remote session id encoding")
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    @Override
    public void setCheckingRemoteSessionIdEncoding(boolean bl) {
        this._checkingRemoteSessionIdEncoding = bl;
    }

    @Override
    public void renewSessionId(String string, String string2, String string3, String string4) {
        if (!this._sessionIdListeners.isEmpty()) {
            AbstractSession abstractSession = this.getSession(string3);
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)abstractSession);
            for (HttpSessionIdListener httpSessionIdListener : this._sessionIdListeners) {
                httpSessionIdListener.sessionIdChanged(httpSessionEvent, string);
            }
        }
    }

    public void doSessionAttributeListeners(AbstractSession abstractSession, String string, Object object, Object object2) {
        if (!this._sessionAttributeListeners.isEmpty()) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)abstractSession, string, object == null ? object2 : object);
            for (HttpSessionAttributeListener httpSessionAttributeListener : this._sessionAttributeListeners) {
                if (object == null) {
                    httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
                    continue;
                }
                if (object2 == null) {
                    httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                    continue;
                }
                httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
            }
        }
    }

    @Override
    @Deprecated
    public SessionIdManager getMetaManager() {
        throw new UnsupportedOperationException();
    }

    public static interface SessionIf
    extends HttpSession {
        public AbstractSession getSession();
    }

    public final class CookieConfig
    implements SessionCookieConfig {
        public String getComment() {
            return AbstractSessionManager.this._sessionComment;
        }

        public String getDomain() {
            return AbstractSessionManager.this._sessionDomain;
        }

        public int getMaxAge() {
            return AbstractSessionManager.this._maxCookieAge;
        }

        public String getName() {
            return AbstractSessionManager.this._sessionCookie;
        }

        public String getPath() {
            return AbstractSessionManager.this._sessionPath;
        }

        public boolean isHttpOnly() {
            return AbstractSessionManager.this._httpOnly;
        }

        public boolean isSecure() {
            return AbstractSessionManager.this._secureCookies;
        }

        public void setComment(String string) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionComment = string;
        }

        public void setDomain(String string) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionDomain = string;
        }

        public void setHttpOnly(boolean bl) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._httpOnly = bl;
        }

        public void setMaxAge(int n) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._maxCookieAge = n;
        }

        public void setName(String string) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionCookie = string;
        }

        public void setPath(String string) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionPath = string;
        }

        public void setSecure(boolean bl) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._secureCookies = bl;
        }
    }
}

