/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final Logger LOG = Log.getLogger(AbstractSessionIdManager.class);
    private static final String __NEW_SESSION_ID = "org.eclipse.jetty.server.newSessionId";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected String _workerAttr;
    protected long _reseed = 100000L;

    public AbstractSessionIdManager() {
    }

    public AbstractSessionIdManager(Random random) {
        this._random = random;
    }

    @Override
    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        if (string.contains(".")) {
            throw new IllegalArgumentException("Name cannot contain '.'");
        }
        this._workerName = string;
    }

    public Random getRandom() {
        return this._random;
    }

    public synchronized void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    public long getReseed() {
        return this._reseed;
    }

    public void setReseed(long l) {
        this._reseed = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String newSessionId(HttpServletRequest httpServletRequest, long l) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            String string;
            if (httpServletRequest == null) {
                return this.newSessionId(l);
            }
            String string2 = httpServletRequest.getRequestedSessionId();
            if (string2 != null && this.idInUse(string = this.getClusterId(string2))) {
                return string;
            }
            string = (String)httpServletRequest.getAttribute(__NEW_SESSION_ID);
            if (string != null && this.idInUse(string)) {
                return string;
            }
            String string3 = this.newSessionId(httpServletRequest.hashCode());
            httpServletRequest.setAttribute(__NEW_SESSION_ID, (Object)string3);
            return string3;
        }
    }

    public String newSessionId(long l) {
        String string = null;
        while (string == null || string.length() == 0 || this.idInUse(string)) {
            long l2;
            long l3;
            long l4 = l3 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ l << 32 : this._random.nextLong();
            if (l3 < 0L) {
                l3 = -l3;
            }
            if (this._reseed > 0L && l3 % this._reseed == 1L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reseeding {}", new Object[]{this});
                }
                if (this._random instanceof SecureRandom) {
                    SecureRandom secureRandom = (SecureRandom)this._random;
                    secureRandom.setSeed(secureRandom.generateSeed(8));
                } else {
                    this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ l ^ Runtime.getRuntime().freeMemory());
                }
            }
            long l5 = l2 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ l << 32 : this._random.nextLong();
            if (l2 < 0L) {
                l2 = -l2;
            }
            string = Long.toString(l3, 36) + Long.toString(l2, 36);
            if (this._workerName == null) continue;
            string = this._workerName + string;
        }
        return string;
    }

    @Override
    public abstract void renewSessionId(String var1, String var2, HttpServletRequest var3);

    protected void doStart() {
        this.initRandom();
        this._workerAttr = this._workerName != null && this._workerName.startsWith("$") ? this._workerName.substring(1) : null;
    }

    protected void doStop() {
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
            }
            catch (Exception exception) {
                LOG.warn("Could not generate SecureRandom for session-id randomness", (Throwable)exception);
                this._random = new Random();
                this._weakRandom = true;
            }
        } else {
            this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
        }
    }

    @Override
    public String getNodeId(String string, HttpServletRequest httpServletRequest) {
        if (this._workerName != null) {
            if (this._workerAttr == null) {
                return string + '.' + this._workerName;
            }
            String string2 = (String)httpServletRequest.getAttribute(this._workerAttr);
            if (string2 != null) {
                return string + '.' + string2;
            }
        }
        return string;
    }

    @Override
    public String getClusterId(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) : string;
    }
}

