/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractSession
implements AbstractSessionManager.SessionIf {
    static final Logger LOG = SessionHandler.LOG;
    public static final String SESSION_CREATED_SECURE = "org.eclipse.jetty.security.sessionCreatedSecure";
    private String _clusterId;
    private String _nodeId;
    private final AbstractSessionManager _manager;
    private boolean _idChanged;
    private final long _created;
    private long _cookieSet;
    private long _accessed;
    private long _lastAccessed;
    private boolean _invalid;
    private boolean _doInvalidate;
    private long _maxIdleMs;
    private boolean _newSession;
    private int _requests;

    protected AbstractSession(AbstractSessionManager abstractSessionManager, HttpServletRequest httpServletRequest) {
        this._manager = abstractSessionManager;
        this._newSession = true;
        this._created = System.currentTimeMillis();
        this._clusterId = this._manager._sessionIdManager.newSessionId(httpServletRequest, this._created);
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, httpServletRequest);
        this._accessed = this._created;
        this._lastAccessed = this._created;
        this._requests = 1;
        long l = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)this._manager._dftMaxIdleSecs * 1000L : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new session & id " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected AbstractSession(AbstractSessionManager abstractSessionManager, long l, long l2, String string) {
        this._manager = abstractSessionManager;
        this._created = l;
        this._clusterId = string;
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, null);
        this._accessed = l2;
        this._lastAccessed = l2;
        this._requests = 1;
        long l3 = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)this._manager._dftMaxIdleSecs * 1000L : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new session " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected void checkValid() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
    }

    protected boolean checkExpiry(long l) {
        return this._maxIdleMs > 0L && this._lastAccessed > 0L && this._lastAccessed + this._maxIdleMs < l;
    }

    @Override
    public AbstractSession getSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAccessed() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._accessed;
        }
    }

    public abstract Map<String, Object> getAttributeMap();

    public abstract int getAttributes();

    public abstract Set<String> getNames();

    public long getCookieSetTime() {
        return this._cookieSet;
    }

    public void setCookieSetTime(long l) {
        this._cookieSet = l;
    }

    public long getCreationTime() {
        this.checkValid();
        return this._created;
    }

    public String getId() {
        return this._manager._nodeIdInSessionId ? this._nodeId : this._clusterId;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getClusterId() {
        return this._clusterId;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return this._lastAccessed;
    }

    public void setLastAccessedTime(long l) {
        this._lastAccessed = l;
    }

    public int getMaxInactiveInterval() {
        return (int)(this._maxIdleMs / 1000L);
    }

    public ServletContext getServletContext() {
        return this._manager._context;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        this.checkValid();
        return AbstractSessionManager.__nullSessionContext;
    }

    @Deprecated
    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public void renewId(HttpServletRequest httpServletRequest) {
        this._manager._sessionIdManager.renewSessionId(this.getClusterId(), this.getNodeId(), httpServletRequest);
        this.setIdChanged(true);
    }

    public SessionManager getSessionManager() {
        return this._manager;
    }

    protected void setClusterId(String string) {
        this._clusterId = string;
    }

    protected void setNodeId(String string) {
        this._nodeId = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean access(long l) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (this._invalid) {
                return false;
            }
            this._newSession = false;
            this._lastAccessed = this._accessed;
            this._accessed = l;
            if (this.checkExpiry(l)) {
                this.invalidate();
                return false;
            }
            ++this._requests;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            --this._requests;
            if (this._doInvalidate && this._requests <= 0) {
                this.doInvalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout() {
        this._manager.removeSession(this, true);
        boolean bl = false;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (!this._invalid) {
                if (this._requests <= 0) {
                    bl = true;
                } else {
                    this._doInvalidate = true;
                }
            }
        }
        if (bl) {
            this.doInvalidate();
        }
    }

    public void invalidate() {
        this.checkValid();
        this._manager.removeSession(this, true);
        this.doInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvalidate() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invalidate {}", new Object[]{this._clusterId});
            }
            if (this.isValid()) {
                this.clearAttributes();
            }
        }
        finally {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                this._invalid = true;
            }
        }
    }

    public abstract void clearAttributes();

    public boolean isIdChanged() {
        return this._idChanged;
    }

    public boolean isNew() {
        this.checkValid();
        return this._newSession;
    }

    @Deprecated
    public void putValue(String string, Object object) {
        this.changeAttribute(string, object);
    }

    public void removeAttribute(String string) {
        this.setAttribute(string, null);
    }

    @Deprecated
    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this.doGetAttributeNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String[] getValueNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            Enumeration<String> enumeration = this.doGetAttributeNames();
            if (enumeration == null) {
                return new String[0];
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    public abstract Object doPutOrRemove(String var1, Object var2);

    public abstract Object doGet(String var1);

    public abstract Enumeration<String> doGetAttributeNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this.doGet(string);
        }
    }

    public void setAttribute(String string, Object object) {
        this.changeAttribute(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected boolean updateAttribute(String string, Object object) {
        Object object2 = null;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            object2 = this.doPutOrRemove(string, object);
        }
        if (object == null || !object.equals(object2)) {
            if (object2 != null) {
                this.unbindValue(string, object2);
            }
            if (object != null) {
                this.bindValue(string, object);
            }
            this._manager.doSessionAttributeListeners(this, string, object2, object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object changeAttribute(String string, Object object) {
        Object object2 = null;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            object2 = this.doPutOrRemove(string, object);
        }
        this.callSessionAttributeListeners(string, object, object2);
        return object2;
    }

    protected void callSessionAttributeListeners(String string, Object object, Object object2) {
        if (object == null || !object.equals(object2)) {
            if (object2 != null) {
                this.unbindValue(string, object2);
            }
            if (object != null) {
                this.bindValue(string, object);
            }
            this._manager.doSessionAttributeListeners(this, string, object2, object);
        }
    }

    public void setIdChanged(boolean bl) {
        this._idChanged = bl;
    }

    public void setMaxInactiveInterval(int n) {
        this._maxIdleMs = (long)n * 1000L;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
    }

    public void bindValue(String string, Object object) {
        if (object != null && object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public boolean isValid() {
        return !this._invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cookieSet() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._cookieSet = this._accessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequests() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequests(int n) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._requests = n;
        }
    }

    public void unbindValue(String string, Object object) {
        if (object != null && object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void willPassivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
            for (Object object : this.getAttributeMap().values()) {
                if (!(object instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener httpSessionActivationListener = (HttpSessionActivationListener)object;
                httpSessionActivationListener.sessionWillPassivate(httpSessionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didActivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
            for (Object object : this.getAttributeMap().values()) {
                if (!(object instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener httpSessionActivationListener = (HttpSessionActivationListener)object;
                httpSessionActivationListener.sessionDidActivate(httpSessionEvent);
            }
        }
    }
}

