/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.jmx.AbstractHandlerMBean;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;

@ManagedObject(value="ContextHandler mbean wrapper")
public class ContextHandlerMBean
extends AbstractHandlerMBean {
    public ContextHandlerMBean(Object object) {
        super(object);
    }

    @ManagedAttribute(value="Map of context attributes")
    public Map<String, Object> getContextAttributes() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Attributes attributes = ((ContextHandler)this._managed).getAttributes();
        Enumeration enumeration = attributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = attributes.getAttribute(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String string, @Name(value="value", description="attribute value") Object object) {
        Attributes attributes = ((ContextHandler)this._managed).getAttributes();
        attributes.setAttribute(string, object);
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String string, @Name(value="value", description="attribute value") String string2) {
        Attributes attributes = ((ContextHandler)this._managed).getAttributes();
        attributes.setAttribute(string, (Object)string2);
    }

    @ManagedOperation(value="Remove context attribute", impact="ACTION")
    public void removeContextAttribute(@Name(value="name", description="attribute name") String string) {
        Attributes attributes = ((ContextHandler)this._managed).getAttributes();
        attributes.removeAttribute(string);
    }
}

