/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import java.io.IOException;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = Log.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object object) {
        super(object);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            ContextHandler contextHandler;
            AbstractHandler abstractHandler;
            Server server;
            String string = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler contextHandler2 = (ContextHandler)this._managed;
                String string2 = this.getContextName(contextHandler2);
                if (string2 == null) {
                    string2 = contextHandler2.getDisplayName();
                }
                if (string2 != null) {
                    return string2;
                }
            } else if (this._managed instanceof AbstractHandler && (server = (abstractHandler = (AbstractHandler)this._managed).getServer()) != null && (contextHandler = AbstractHandlerContainer.findContainerOf(server, ContextHandler.class, abstractHandler)) != null) {
                string = this.getContextName(contextHandler);
            }
            if (string != null) {
                return string;
            }
        }
        return super.getObjectContextBasis();
    }

    protected String getContextName(ContextHandler contextHandler) {
        String string = null;
        if (contextHandler.getContextPath() != null && contextHandler.getContextPath().length() > 0) {
            int n = contextHandler.getContextPath().lastIndexOf(47);
            String string2 = string = n < 0 ? contextHandler.getContextPath() : contextHandler.getContextPath().substring(++n);
            if (string == null || string.length() == 0) {
                string = "ROOT";
            }
        }
        if (string == null && contextHandler.getBaseResource() != null) {
            try {
                if (contextHandler.getBaseResource().getFile() != null) {
                    string = contextHandler.getBaseResource().getFile().getName();
                }
            }
            catch (IOException iOException) {
                LOG.ignore((Throwable)iOException);
                string = contextHandler.getBaseResource().getName();
            }
        }
        if (contextHandler.getVirtualHosts() != null && contextHandler.getVirtualHosts().length > 0) {
            string = '\"' + string + "@" + contextHandler.getVirtualHosts()[0] + '\"';
        }
        return string;
    }
}

