/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jetty.http.GzipHttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.handler.gzip.GzipFactory;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHttpOutputInterceptor
implements HttpOutput.Interceptor {
    public static Logger LOG = Log.getLogger(GzipHttpOutputInterceptor.class);
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    public static final HttpField VARY_ACCEPT_ENCODING_USER_AGENT = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING + ", " + HttpHeader.USER_AGENT);
    public static final HttpField VARY_ACCEPT_ENCODING = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());
    private final AtomicReference<GZState> _state = new AtomicReference<GZState>(GZState.MIGHT_COMPRESS);
    private final CRC32 _crc = new CRC32();
    private final GzipFactory _factory;
    private final HttpOutput.Interceptor _interceptor;
    private final HttpChannel _channel;
    private final HttpField _vary;
    private final int _bufferSize;
    private final boolean _syncFlush;
    private Deflater _deflater;
    private ByteBuffer _buffer;

    public GzipHttpOutputInterceptor(GzipFactory gzipFactory, HttpChannel httpChannel, HttpOutput.Interceptor interceptor, boolean bl) {
        this(gzipFactory, VARY_ACCEPT_ENCODING_USER_AGENT, httpChannel.getHttpConfiguration().getOutputBufferSize(), httpChannel, interceptor, bl);
    }

    public GzipHttpOutputInterceptor(GzipFactory gzipFactory, HttpField httpField, HttpChannel httpChannel, HttpOutput.Interceptor interceptor, boolean bl) {
        this(gzipFactory, httpField, httpChannel.getHttpConfiguration().getOutputBufferSize(), httpChannel, interceptor, bl);
    }

    public GzipHttpOutputInterceptor(GzipFactory gzipFactory, HttpField httpField, int n, HttpChannel httpChannel, HttpOutput.Interceptor interceptor, boolean bl) {
        this._factory = gzipFactory;
        this._channel = httpChannel;
        this._interceptor = interceptor;
        this._vary = httpField;
        this._bufferSize = n;
        this._syncFlush = bl;
    }

    @Override
    public HttpOutput.Interceptor getNextInterceptor() {
        return this._interceptor;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    @Override
    public void write(ByteBuffer byteBuffer, boolean bl, Callback callback) {
        switch (this._state.get()) {
            case MIGHT_COMPRESS: {
                this.commit(byteBuffer, bl, callback);
                break;
            }
            case NOT_COMPRESSING: {
                this._interceptor.write(byteBuffer, bl, callback);
                return;
            }
            case COMMITTING: {
                callback.failed((Throwable)new WritePendingException());
                break;
            }
            case COMPRESSING: {
                this.gzip(byteBuffer, bl, callback);
                break;
            }
            default: {
                callback.failed((Throwable)new IllegalStateException("state=" + (Object)((Object)this._state.get())));
            }
        }
    }

    private void addTrailer() {
        int n = this._buffer.limit();
        this._buffer.limit(n + 8);
        int n2 = (int)this._crc.getValue();
        this._buffer.put(n++, (byte)(n2 & 0xFF));
        this._buffer.put(n++, (byte)(n2 >>> 8 & 0xFF));
        this._buffer.put(n++, (byte)(n2 >>> 16 & 0xFF));
        this._buffer.put(n++, (byte)(n2 >>> 24 & 0xFF));
        n2 = this._deflater.getTotalIn();
        this._buffer.put(n++, (byte)(n2 & 0xFF));
        this._buffer.put(n++, (byte)(n2 >>> 8 & 0xFF));
        this._buffer.put(n++, (byte)(n2 >>> 16 & 0xFF));
        this._buffer.put(n++, (byte)(n2 >>> 24 & 0xFF));
    }

    private void gzip(ByteBuffer byteBuffer, boolean bl, Callback callback) {
        if (byteBuffer.hasRemaining() || bl) {
            new GzipBufferCB(byteBuffer, bl, callback).iterate();
        } else {
            callback.succeeded();
        }
    }

    protected void commit(ByteBuffer byteBuffer, boolean bl, Callback callback) {
        int n = this._channel.getResponse().getStatus();
        if (n > 0 && (n < 200 || n == 204 || n == 205 || n >= 300)) {
            LOG.debug("{} exclude by status {}", new Object[]{this, n});
            this.noCompression();
            this._interceptor.write(byteBuffer, bl, callback);
            return;
        }
        String string = this._channel.getResponse().getContentType();
        if (string != null && !this._factory.isMimeTypeGzipable(StringUtil.asciiToLowerCase((String)(string = MimeTypes.getContentTypeWithoutCharset((String)string))))) {
            LOG.debug("{} exclude by mimeType {}", new Object[]{this, string});
            this.noCompression();
            this._interceptor.write(byteBuffer, bl, callback);
            return;
        }
        String string2 = this._channel.getResponse().getHeader("Content-Encoding");
        if (string2 != null) {
            LOG.debug("{} exclude by content-encoding {}", new Object[]{this, string2});
            this.noCompression();
            this._interceptor.write(byteBuffer, bl, callback);
            return;
        }
        if (this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.COMMITTING)) {
            HttpFields httpFields = this._channel.getResponse().getHttpFields();
            httpFields.add(this._vary);
            long l = this._channel.getResponse().getContentLength();
            if (l < 0L && bl) {
                l = byteBuffer.remaining();
            }
            this._deflater = this._factory.getDeflater(this._channel.getRequest(), l);
            if (this._deflater == null) {
                LOG.debug("{} exclude no deflater", new Object[]{this});
                this._state.set(GZState.NOT_COMPRESSING);
                this._interceptor.write(byteBuffer, bl, callback);
                return;
            }
            httpFields.put((HttpField)GzipHttpContent.CONTENT_ENCODING_GZIP);
            this._crc.reset();
            this._buffer = this._channel.getByteBufferPool().acquire(this._bufferSize, false);
            BufferUtil.fill((ByteBuffer)this._buffer, (byte[])GZIP_HEADER, (int)0, (int)GZIP_HEADER.length);
            this._channel.getResponse().setContentLength(-1);
            String string3 = httpFields.get(HttpHeader.ETAG);
            if (string3 != null) {
                int n2 = string3.length() - 1;
                string3 = string3.charAt(n2) == '\"' ? string3.substring(0, n2) + "--gzip" + '\"' : string3 + "--gzip";
                httpFields.put(HttpHeader.ETAG, string3);
            }
            LOG.debug("{} compressing {}", new Object[]{this, this._deflater});
            this._state.set(GZState.COMPRESSING);
            this.gzip(byteBuffer, bl, callback);
        } else {
            callback.failed((Throwable)new WritePendingException());
        }
    }

    public void noCompression() {
        block4: while (true) {
            switch (this._state.get()) {
                case NOT_COMPRESSING: {
                    return;
                }
                case MIGHT_COMPRESS: {
                    if (!this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.NOT_COMPRESSING)) continue block4;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    public void noCompressionIfPossible() {
        block4: while (true) {
            switch (this._state.get()) {
                case NOT_COMPRESSING: 
                case COMPRESSING: {
                    return;
                }
                case MIGHT_COMPRESS: {
                    if (!this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.NOT_COMPRESSING)) continue block4;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    public boolean mightCompress() {
        return this._state.get() == GZState.MIGHT_COMPRESS;
    }

    private class GzipBufferCB
    extends IteratingNestedCallback {
        private ByteBuffer _copy;
        private final ByteBuffer _content;
        private final boolean _last;

        public GzipBufferCB(ByteBuffer byteBuffer, boolean bl, Callback callback) {
            super(callback);
            this._content = byteBuffer;
            this._last = bl;
        }

        protected IteratingCallback.Action process() {
            int n;
            int n2;
            if (GzipHttpOutputInterceptor.this._deflater == null) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (GzipHttpOutputInterceptor.this._deflater.needsInput()) {
                if (BufferUtil.isEmpty((ByteBuffer)this._content)) {
                    if (GzipHttpOutputInterceptor.this._deflater.finished()) {
                        GzipHttpOutputInterceptor.this._factory.recycle(GzipHttpOutputInterceptor.this._deflater);
                        GzipHttpOutputInterceptor.this._deflater = null;
                        GzipHttpOutputInterceptor.this._channel.getByteBufferPool().release(GzipHttpOutputInterceptor.this._buffer);
                        GzipHttpOutputInterceptor.this._buffer = null;
                        if (this._copy != null) {
                            GzipHttpOutputInterceptor.this._channel.getByteBufferPool().release(this._copy);
                            this._copy = null;
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    if (!this._last) {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    GzipHttpOutputInterceptor.this._deflater.finish();
                } else if (this._content.hasArray()) {
                    byte[] byArray = this._content.array();
                    n2 = this._content.arrayOffset() + this._content.position();
                    n = this._content.remaining();
                    BufferUtil.clear((ByteBuffer)this._content);
                    GzipHttpOutputInterceptor.this._crc.update(byArray, n2, n);
                    GzipHttpOutputInterceptor.this._deflater.setInput(byArray, n2, n);
                    if (this._last) {
                        GzipHttpOutputInterceptor.this._deflater.finish();
                    }
                } else {
                    if (this._copy == null) {
                        this._copy = GzipHttpOutputInterceptor.this._channel.getByteBufferPool().acquire(GzipHttpOutputInterceptor.this._bufferSize, false);
                    }
                    BufferUtil.clearToFill((ByteBuffer)this._copy);
                    int n3 = BufferUtil.put((ByteBuffer)this._content, (ByteBuffer)this._copy);
                    BufferUtil.flipToFlush((ByteBuffer)this._copy, (int)0);
                    if (n3 == 0) {
                        throw new IllegalStateException();
                    }
                    byte[] byArray = this._copy.array();
                    n = this._copy.arrayOffset() + this._copy.position();
                    int n4 = this._copy.remaining();
                    GzipHttpOutputInterceptor.this._crc.update(byArray, n, n4);
                    GzipHttpOutputInterceptor.this._deflater.setInput(byArray, n, n4);
                    if (this._last && BufferUtil.isEmpty((ByteBuffer)this._content)) {
                        GzipHttpOutputInterceptor.this._deflater.finish();
                    }
                }
            }
            BufferUtil.compact((ByteBuffer)GzipHttpOutputInterceptor.this._buffer);
            int n5 = GzipHttpOutputInterceptor.this._buffer.arrayOffset() + GzipHttpOutputInterceptor.this._buffer.limit();
            n2 = GzipHttpOutputInterceptor.this._buffer.capacity() - GzipHttpOutputInterceptor.this._buffer.limit() - (this._last ? 8 : 0);
            if (n2 > 0) {
                n = GzipHttpOutputInterceptor.this._deflater.deflate(GzipHttpOutputInterceptor.this._buffer.array(), n5, n2, GzipHttpOutputInterceptor.this._syncFlush ? 2 : 0);
                GzipHttpOutputInterceptor.this._buffer.limit(GzipHttpOutputInterceptor.this._buffer.limit() + n);
            }
            if ((n = (int)(GzipHttpOutputInterceptor.this._deflater.finished() ? 1 : 0)) != 0) {
                GzipHttpOutputInterceptor.this.addTrailer();
            }
            GzipHttpOutputInterceptor.this._interceptor.write(GzipHttpOutputInterceptor.this._buffer, n != 0, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }
    }

    private static enum GZState {
        MIGHT_COMPRESS,
        NOT_COMPRESSING,
        COMMITTING,
        COMPRESSING,
        FINISHED;

    }
}

