/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.io.File;
import java.util.Set;
import java.util.zip.Deflater;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHttpOutputInterceptor;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.RegexSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHandler
extends HandlerWrapper
implements GzipFactory {
    private static final Logger LOG = Log.getLogger(GzipHandler.class);
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final int DEFAULT_MIN_GZIP_SIZE = 16;
    private int _minGzipSize = 16;
    private int _compressionLevel = -1;
    private boolean _checkGzExists = true;
    private boolean _syncFlush = false;
    private final ThreadLocal<Deflater> _deflater = new ThreadLocal();
    private final IncludeExclude<String> _agentPatterns = new IncludeExclude(RegexSet.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private HttpField _vary;

    public GzipHandler() {
        this._methods.include((Object)HttpMethod.GET.asString());
        for (String string : MimeTypes.getKnownMimeTypes()) {
            if ("image/svg+xml".equals(string)) {
                this._paths.exclude((Object)"*.svgz");
                continue;
            }
            if (!string.startsWith("image/") && !string.startsWith("audio/") && !string.startsWith("video/")) continue;
            this._mimeTypes.exclude((Object)string);
        }
        this._mimeTypes.exclude((Object)"application/compress");
        this._mimeTypes.exclude((Object)"application/zip");
        this._mimeTypes.exclude((Object)"application/gzip");
        this._mimeTypes.exclude((Object)"application/bzip2");
        this._mimeTypes.exclude((Object)"application/x-rar-compressed");
        LOG.debug("{} mime types {}", new Object[]{this, this._mimeTypes});
        this._agentPatterns.exclude((Object)".*MSIE 6.0.*");
    }

    public void addExcludedAgentPatterns(String ... stringArray) {
        this._agentPatterns.exclude((Object[])stringArray);
    }

    public void addExcludedMethods(String ... stringArray) {
        for (String string : stringArray) {
            this._methods.exclude((Object)string);
        }
    }

    public void addExcludedMimeTypes(String ... stringArray) {
        for (String string : stringArray) {
            this._mimeTypes.exclude((Object[])StringUtil.csvSplit((String)string));
        }
    }

    public void addExcludedPaths(String ... stringArray) {
        for (String string : stringArray) {
            this._paths.exclude((Object[])StringUtil.csvSplit((String)string));
        }
    }

    public void addIncludedAgentPatterns(String ... stringArray) {
        this._agentPatterns.include((Object[])stringArray);
    }

    public void addIncludedMethods(String ... stringArray) {
        for (String string : stringArray) {
            this._methods.include((Object)string);
        }
    }

    public boolean isSyncFlush() {
        return this._syncFlush;
    }

    public void setSyncFlush(boolean bl) {
        this._syncFlush = bl;
    }

    public void addIncludedMimeTypes(String ... stringArray) {
        for (String string : stringArray) {
            this._mimeTypes.include((Object[])StringUtil.csvSplit((String)string));
        }
    }

    public void addIncludedPaths(String ... stringArray) {
        for (String string : stringArray) {
            this._paths.include((Object[])StringUtil.csvSplit((String)string));
        }
    }

    @Override
    protected void doStart() {
        this._vary = this._agentPatterns.size() > 0 ? GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING_USER_AGENT : GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING;
        super.doStart();
    }

    public boolean getCheckGzExists() {
        return this._checkGzExists;
    }

    public int getCompressionLevel() {
        return this._compressionLevel;
    }

    @Override
    public Deflater getDeflater(Request request, long l) {
        Object object;
        String string = request.getHttpFields().get(HttpHeader.USER_AGENT);
        if (string != null && !this.isAgentGzipable(string)) {
            LOG.debug("{} excluded user agent {}", new Object[]{this, request});
            return null;
        }
        if (l >= 0L && l < (long)this._minGzipSize) {
            LOG.debug("{} excluded minGzipSize {}", new Object[]{this, request});
            return null;
        }
        if (request.getHttpVersion() != HttpVersion.HTTP_2) {
            object = request.getHttpFields().getField(HttpHeader.ACCEPT_ENCODING);
            if (object == null) {
                LOG.debug("{} excluded !accept {}", new Object[]{this, request});
                return null;
            }
            boolean bl = object.contains(GZIP);
            if (!bl) {
                LOG.debug("{} excluded not gzip accept {}", new Object[]{this, request});
                return null;
            }
        }
        if ((object = this._deflater.get()) == null) {
            object = new Deflater(this._compressionLevel, true);
        } else {
            this._deflater.set(null);
        }
        return object;
    }

    public String[] getExcludedAgentPatterns() {
        Set set = this._agentPatterns.getExcluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getExcludedMethods() {
        Set set = this._methods.getExcluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getExcludedMimeTypes() {
        Set set = this._mimeTypes.getExcluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getExcludedPaths() {
        Set set = this._paths.getExcluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getIncludedAgentPatterns() {
        Set set = this._agentPatterns.getIncluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getIncludedMethods() {
        Set set = this._methods.getIncluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getIncludedMimeTypes() {
        Set set = this._mimeTypes.getIncluded();
        return set.toArray(new String[set.size()]);
    }

    public String[] getIncludedPaths() {
        Set set = this._paths.getIncluded();
        return set.toArray(new String[set.size()]);
    }

    @Deprecated
    public String[] getMethods() {
        return this.getIncludedMethods();
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n;
        File file;
        String string2;
        String string3;
        ServletContext servletContext = request.getServletContext();
        String string4 = servletContext == null ? request.getRequestURI() : URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo());
        LOG.debug("{} handle {} in {}", new Object[]{this, request, servletContext});
        HttpOutput httpOutput = request.getResponse().getHttpOutput();
        for (HttpOutput.Interceptor interceptor = httpOutput.getInterceptor(); interceptor != null; interceptor = interceptor.getNextInterceptor()) {
            if (!(interceptor instanceof GzipHttpOutputInterceptor)) continue;
            LOG.debug("{} already intercepting {}", new Object[]{this, httpServletRequest});
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
            return;
        }
        if (!this._methods.matches((Object)request.getMethod())) {
            LOG.debug("{} excluded by method {}", new Object[]{this, httpServletRequest});
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
            return;
        }
        if (!this.isPathGzipable(string4)) {
            LOG.debug("{} excluded by path {}", new Object[]{this, httpServletRequest});
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
            return;
        }
        String string5 = string3 = servletContext == null ? null : servletContext.getMimeType(string4);
        if (string3 != null && !this.isMimeTypeGzipable(string3 = MimeTypes.getContentTypeWithoutCharset((String)string3))) {
            LOG.debug("{} excluded by path suffix mime type {}", new Object[]{this, httpServletRequest});
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
            return;
        }
        if (this._checkGzExists && servletContext != null && (string2 = httpServletRequest.getServletContext().getRealPath(string4)) != null && (file = new File(string2 + ".gz")).exists()) {
            LOG.debug("{} gzip exists {}", new Object[]{this, httpServletRequest});
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
            return;
        }
        string2 = request.getHttpFields().get(HttpHeader.IF_NONE_MATCH);
        if (string2 != null && (n = string2.indexOf("--gzip\"")) > 0) {
            while (n >= 0) {
                string2 = string2.substring(0, n) + string2.substring(n + "--gzip".length());
                n = string2.indexOf("--gzip\"", n);
            }
            request.getHttpFields().put(new HttpField(HttpHeader.IF_NONE_MATCH, string2));
        }
        httpOutput.setInterceptor(new GzipHttpOutputInterceptor(this, this._vary, request.getHttpChannel(), httpOutput.getInterceptor(), this._syncFlush));
        if (this._handler != null) {
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
        }
    }

    protected boolean isAgentGzipable(String string) {
        if (string == null) {
            return false;
        }
        return this._agentPatterns.matches((Object)string);
    }

    @Override
    public boolean isMimeTypeGzipable(String string) {
        return this._mimeTypes.matches((Object)string);
    }

    protected boolean isPathGzipable(String string) {
        if (string == null) {
            return true;
        }
        return this._paths.matches((Object)string);
    }

    @Override
    public void recycle(Deflater deflater) {
        deflater.reset();
        if (this._deflater.get() == null) {
            this._deflater.set(deflater);
        }
    }

    public void setCheckGzExists(boolean bl) {
        this._checkGzExists = bl;
    }

    public void setCompressionLevel(int n) {
        this._compressionLevel = n;
    }

    public void setExcludedAgentPatterns(String ... stringArray) {
        this._agentPatterns.getExcluded().clear();
        this.addExcludedAgentPatterns(stringArray);
    }

    public void setExcludedMethods(String ... stringArray) {
        this._methods.getExcluded().clear();
        this._methods.exclude((Object[])stringArray);
    }

    public void setExcludedMimeTypes(String ... stringArray) {
        this._mimeTypes.getExcluded().clear();
        this._mimeTypes.exclude((Object[])stringArray);
    }

    public void setExcludedPaths(String ... stringArray) {
        this._paths.getExcluded().clear();
        this._paths.exclude((Object[])stringArray);
    }

    public void setIncludedAgentPatterns(String ... stringArray) {
        this._agentPatterns.getIncluded().clear();
        this.addIncludedAgentPatterns(stringArray);
    }

    public void setIncludedMethods(String ... stringArray) {
        this._methods.getIncluded().clear();
        this._methods.include((Object[])stringArray);
    }

    public void setIncludedMimeTypes(String ... stringArray) {
        this._mimeTypes.getIncluded().clear();
        this._mimeTypes.include((Object[])stringArray);
    }

    public void setIncludedPaths(String ... stringArray) {
        this._paths.getIncluded().clear();
        this._paths.include((Object[])stringArray);
    }

    public void setMinGzipSize(int n) {
        this._minGzipSize = n;
    }
}

