/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Request Statistics Gathering")
public class StatisticsHandler
extends HandlerWrapper
implements Graceful {
    private static final Logger LOG = Log.getLogger(StatisticsHandler.class);
    private final AtomicLong _statsStartedAt = new AtomicLong();
    private final CounterStatistic _requestStats = new CounterStatistic();
    private final SampleStatistic _requestTimeStats = new SampleStatistic();
    private final CounterStatistic _dispatchedStats = new CounterStatistic();
    private final SampleStatistic _dispatchedTimeStats = new SampleStatistic();
    private final CounterStatistic _asyncWaitStats = new CounterStatistic();
    private final AtomicInteger _asyncDispatches = new AtomicInteger();
    private final AtomicInteger _expires = new AtomicInteger();
    private final AtomicInteger _responses1xx = new AtomicInteger();
    private final AtomicInteger _responses2xx = new AtomicInteger();
    private final AtomicInteger _responses3xx = new AtomicInteger();
    private final AtomicInteger _responses4xx = new AtomicInteger();
    private final AtomicInteger _responses5xx = new AtomicInteger();
    private final AtomicLong _responsesTotalBytes = new AtomicLong();
    private final AtomicReference<FutureCallback> _shutdown = new AtomicReference();
    private final AtomicBoolean _wrapWarning = new AtomicBoolean();
    private final AsyncListener _onCompletion = new AsyncListener(){

        public void onTimeout(AsyncEvent asyncEvent) {
            StatisticsHandler.this._expires.incrementAndGet();
        }

        public void onStartAsync(AsyncEvent asyncEvent) {
            asyncEvent.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onError(AsyncEvent asyncEvent) {
        }

        public void onComplete(AsyncEvent asyncEvent) {
            FutureCallback futureCallback;
            HttpChannelState httpChannelState = ((AsyncContextEvent)asyncEvent).getHttpChannelState();
            Request request = httpChannelState.getBaseRequest();
            long l = System.currentTimeMillis() - request.getTimeStamp();
            long l2 = StatisticsHandler.this._requestStats.decrement();
            StatisticsHandler.this._requestTimeStats.set(l);
            StatisticsHandler.this.updateResponse(request);
            StatisticsHandler.this._asyncWaitStats.decrement();
            if (l2 == 0L && (futureCallback = (FutureCallback)StatisticsHandler.this._shutdown.get()) != null) {
                futureCallback.succeeded();
            }
        }
    };

    @ManagedOperation(value="resets statistics", impact="ACTION")
    public void statsReset() {
        this._statsStartedAt.set(System.currentTimeMillis());
        this._requestStats.reset();
        this._requestTimeStats.reset();
        this._dispatchedStats.reset();
        this._dispatchedTimeStats.reset();
        this._asyncWaitStats.reset();
        this._asyncDispatches.set(0);
        this._expires.set(0);
        this._responses1xx.set(0);
        this._responses2xx.set(0);
        this._responses3xx.set(0);
        this._responses4xx.set(0);
        this._responses5xx.set(0);
        this._responsesTotalBytes.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        long l;
        this._dispatchedStats.increment();
        HttpChannelState httpChannelState = request.getHttpChannelState();
        if (httpChannelState.isInitial()) {
            this._requestStats.increment();
            l = request.getTimeStamp();
        } else {
            l = System.currentTimeMillis();
            this._asyncDispatches.incrementAndGet();
        }
        try {
            Handler handler = this.getHandler();
            if (handler != null && this._shutdown.get() == null && this.isStarted()) {
                handler.handle(string, request, httpServletRequest, httpServletResponse);
            } else if (request.isHandled()) {
                if (this._wrapWarning.compareAndSet(false, true)) {
                    LOG.warn("Bad statistics configuration. Latencies will be incorrect in {}", new Object[]{this});
                }
            } else {
                request.setHandled(true);
                httpServletResponse.sendError(503);
            }
        }
        finally {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            this._dispatchedStats.decrement();
            this._dispatchedTimeStats.set(l3);
            if (httpChannelState.isSuspended()) {
                if (httpChannelState.isInitial()) {
                    httpChannelState.addListener(this._onCompletion);
                    this._asyncWaitStats.increment();
                }
            } else if (httpChannelState.isInitial()) {
                long l4 = this._requestStats.decrement();
                this._requestTimeStats.set(l3);
                this.updateResponse(request);
                FutureCallback futureCallback = this._shutdown.get();
                if (futureCallback != null) {
                    httpServletResponse.flushBuffer();
                    if (l4 == 0L) {
                        futureCallback.succeeded();
                    }
                }
            }
        }
    }

    protected void updateResponse(Request request) {
        Response response = request.getResponse();
        if (request.isHandled()) {
            switch (response.getStatus() / 100) {
                case 1: {
                    this._responses1xx.incrementAndGet();
                    break;
                }
                case 2: {
                    this._responses2xx.incrementAndGet();
                    break;
                }
                case 3: {
                    this._responses3xx.incrementAndGet();
                    break;
                }
                case 4: {
                    this._responses4xx.incrementAndGet();
                    break;
                }
                case 5: {
                    this._responses5xx.incrementAndGet();
                    break;
                }
            }
        } else {
            this._responses4xx.incrementAndGet();
        }
        this._responsesTotalBytes.addAndGet(response.getContentCount());
    }

    @Override
    protected void doStart() {
        this._shutdown.set(null);
        super.doStart();
        this.statsReset();
    }

    @Override
    protected void doStop() {
        super.doStop();
        FutureCallback futureCallback = this._shutdown.get();
        if (futureCallback != null && !futureCallback.isDone()) {
            futureCallback.failed((Throwable)new TimeoutException());
        }
    }

    @ManagedAttribute(value="number of requests")
    public int getRequests() {
        return (int)this._requestStats.getTotal();
    }

    @ManagedAttribute(value="number of requests currently active")
    public int getRequestsActive() {
        return (int)this._requestStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of active requests")
    public int getRequestsActiveMax() {
        return (int)this._requestStats.getMax();
    }

    @ManagedAttribute(value="maximum time spend handling requests (in ms)")
    public long getRequestTimeMax() {
        return this._requestTimeStats.getMax();
    }

    @ManagedAttribute(value="total time spend in all request handling (in ms)")
    public long getRequestTimeTotal() {
        return this._requestTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time spent handling requests (in ms)")
    public double getRequestTimeMean() {
        return this._requestTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation for request handling (in ms)")
    public double getRequestTimeStdDev() {
        return this._requestTimeStats.getStdDev();
    }

    @ManagedAttribute(value="number of dispatches")
    public int getDispatched() {
        return (int)this._dispatchedStats.getTotal();
    }

    @ManagedAttribute(value="number of dispatches currently active")
    public int getDispatchedActive() {
        return (int)this._dispatchedStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of active dispatches being handled")
    public int getDispatchedActiveMax() {
        return (int)this._dispatchedStats.getMax();
    }

    @ManagedAttribute(value="maximum time spend in dispatch handling")
    public long getDispatchedTimeMax() {
        return this._dispatchedTimeStats.getMax();
    }

    @ManagedAttribute(value="total time spent in dispatch handling (in ms)")
    public long getDispatchedTimeTotal() {
        return this._dispatchedTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time spent in dispatch handling (in ms)")
    public double getDispatchedTimeMean() {
        return this._dispatchedTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation for dispatch handling (in ms)")
    public double getDispatchedTimeStdDev() {
        return this._dispatchedTimeStats.getStdDev();
    }

    @ManagedAttribute(value="total number of async requests")
    public int getAsyncRequests() {
        return (int)this._asyncWaitStats.getTotal();
    }

    @ManagedAttribute(value="currently waiting async requests")
    public int getAsyncRequestsWaiting() {
        return (int)this._asyncWaitStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of waiting async requests")
    public int getAsyncRequestsWaitingMax() {
        return (int)this._asyncWaitStats.getMax();
    }

    @ManagedAttribute(value="number of requested that have been asynchronously dispatched")
    public int getAsyncDispatches() {
        return this._asyncDispatches.get();
    }

    @ManagedAttribute(value="number of async requests requests that have expired")
    public int getExpires() {
        return this._expires.get();
    }

    @ManagedAttribute(value="number of requests with 1xx response status")
    public int getResponses1xx() {
        return this._responses1xx.get();
    }

    @ManagedAttribute(value="number of requests with 2xx response status")
    public int getResponses2xx() {
        return this._responses2xx.get();
    }

    @ManagedAttribute(value="number of requests with 3xx response status")
    public int getResponses3xx() {
        return this._responses3xx.get();
    }

    @ManagedAttribute(value="number of requests with 4xx response status")
    public int getResponses4xx() {
        return this._responses4xx.get();
    }

    @ManagedAttribute(value="number of requests with 5xx response status")
    public int getResponses5xx() {
        return this._responses5xx.get();
    }

    @ManagedAttribute(value="time in milliseconds stats have been collected for")
    public long getStatsOnMs() {
        return System.currentTimeMillis() - this._statsStartedAt.get();
    }

    @ManagedAttribute(value="total number of bytes across all responses")
    public long getResponsesBytesTotal() {
        return this._responsesTotalBytes.get();
    }

    public String toStatsHTML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h1>Statistics:</h1>\n");
        stringBuilder.append("Statistics gathering started ").append(this.getStatsOnMs()).append("ms ago").append("<br />\n");
        stringBuilder.append("<h2>Requests:</h2>\n");
        stringBuilder.append("Total requests: ").append(this.getRequests()).append("<br />\n");
        stringBuilder.append("Active requests: ").append(this.getRequestsActive()).append("<br />\n");
        stringBuilder.append("Max active requests: ").append(this.getRequestsActiveMax()).append("<br />\n");
        stringBuilder.append("Total requests time: ").append(this.getRequestTimeTotal()).append("<br />\n");
        stringBuilder.append("Mean request time: ").append(this.getRequestTimeMean()).append("<br />\n");
        stringBuilder.append("Max request time: ").append(this.getRequestTimeMax()).append("<br />\n");
        stringBuilder.append("Request time standard deviation: ").append(this.getRequestTimeStdDev()).append("<br />\n");
        stringBuilder.append("<h2>Dispatches:</h2>\n");
        stringBuilder.append("Total dispatched: ").append(this.getDispatched()).append("<br />\n");
        stringBuilder.append("Active dispatched: ").append(this.getDispatchedActive()).append("<br />\n");
        stringBuilder.append("Max active dispatched: ").append(this.getDispatchedActiveMax()).append("<br />\n");
        stringBuilder.append("Total dispatched time: ").append(this.getDispatchedTimeTotal()).append("<br />\n");
        stringBuilder.append("Mean dispatched time: ").append(this.getDispatchedTimeMean()).append("<br />\n");
        stringBuilder.append("Max dispatched time: ").append(this.getDispatchedTimeMax()).append("<br />\n");
        stringBuilder.append("Dispatched time standard deviation: ").append(this.getDispatchedTimeStdDev()).append("<br />\n");
        stringBuilder.append("Total requests suspended: ").append(this.getAsyncRequests()).append("<br />\n");
        stringBuilder.append("Total requests expired: ").append(this.getExpires()).append("<br />\n");
        stringBuilder.append("Total requests resumed: ").append(this.getAsyncDispatches()).append("<br />\n");
        stringBuilder.append("<h2>Responses:</h2>\n");
        stringBuilder.append("1xx responses: ").append(this.getResponses1xx()).append("<br />\n");
        stringBuilder.append("2xx responses: ").append(this.getResponses2xx()).append("<br />\n");
        stringBuilder.append("3xx responses: ").append(this.getResponses3xx()).append("<br />\n");
        stringBuilder.append("4xx responses: ").append(this.getResponses4xx()).append("<br />\n");
        stringBuilder.append("5xx responses: ").append(this.getResponses5xx()).append("<br />\n");
        stringBuilder.append("Bytes sent total: ").append(this.getResponsesBytesTotal()).append("<br />\n");
        return stringBuilder.toString();
    }

    public Future<Void> shutdown() {
        FutureCallback futureCallback = new FutureCallback(false);
        this._shutdown.compareAndSet(null, futureCallback);
        futureCallback = this._shutdown.get();
        if (this._dispatchedStats.getCurrent() == 0L) {
            futureCallback.succeeded();
        }
        return futureCallback;
    }
}

