/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ShutdownHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ShutdownHandler.class);
    private final String _shutdownToken;
    private boolean _sendShutdownAtStart;
    private boolean _exitJvm = false;

    @Deprecated
    public ShutdownHandler(Server server, String string) {
        this(string);
    }

    public ShutdownHandler(String string) {
        this(string, false, false);
    }

    public ShutdownHandler(String string, boolean bl, boolean bl2) {
        this._shutdownToken = string;
        this.setExitJvm(bl);
        this.setSendShutdownAtStart(bl2);
    }

    public void sendShutdown() {
        URL uRL = new URL(this.getServerUrl() + "/shutdown?token=" + this._shutdownToken);
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.getResponseCode();
            LOG.info("Shutting down " + uRL + ": " + httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage(), new Object[0]);
        }
        catch (SocketException socketException) {
            LOG.debug("Not running", new Object[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private String getServerUrl() {
        NetworkConnector networkConnector = null;
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof NetworkConnector)) continue;
            networkConnector = (NetworkConnector)connector;
            break;
        }
        if (networkConnector == null) {
            return "http://localhost";
        }
        return "http://localhost:" + networkConnector.getPort();
    }

    @Override
    protected void doStart() {
        super.doStart();
        if (this._sendShutdownAtStart) {
            this.sendShutdown();
        }
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!string.equals("/shutdown")) {
            super.handle(string, request, httpServletRequest, httpServletResponse);
            return;
        }
        if (!httpServletRequest.getMethod().equals("POST")) {
            httpServletResponse.sendError(400);
            return;
        }
        if (!this.hasCorrectSecurityToken(httpServletRequest)) {
            LOG.warn("Unauthorized tokenless shutdown attempt from " + httpServletRequest.getRemoteAddr(), new Object[0]);
            httpServletResponse.sendError(401);
            return;
        }
        if (!this.requestFromLocalhost(request)) {
            LOG.warn("Unauthorized non-loopback shutdown attempt from " + httpServletRequest.getRemoteAddr(), new Object[0]);
            httpServletResponse.sendError(401);
            return;
        }
        LOG.info("Shutting down by request from " + httpServletRequest.getRemoteAddr(), new Object[0]);
        this.doShutdown(request, httpServletResponse);
    }

    protected void doShutdown(Request request, HttpServletResponse httpServletResponse) {
        for (Connector connector : this.getServer().getConnectors()) {
            connector.shutdown();
        }
        httpServletResponse.sendError(200, "Connectors closed, commencing full shutdown");
        request.setHandled(true);
        final Server server = this.getServer();
        new Thread(){

            @Override
            public void run() {
                try {
                    ShutdownHandler.this.shutdownServer(server);
                }
                catch (InterruptedException interruptedException) {
                    LOG.ignore((Throwable)interruptedException);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Shutting down server", exception);
                }
            }
        }.start();
    }

    private boolean requestFromLocalhost(Request request) {
        InetSocketAddress inetSocketAddress = request.getRemoteInetSocketAddress();
        if (inetSocketAddress == null) {
            return false;
        }
        return inetSocketAddress.getAddress().isLoopbackAddress();
    }

    private boolean hasCorrectSecurityToken(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("token");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Token: {}", new Object[]{string});
        }
        return this._shutdownToken.equals(string);
    }

    private void shutdownServer(Server server) {
        server.stop();
        if (this._exitJvm) {
            System.exit(0);
        }
    }

    public void setExitJvm(boolean bl) {
        this._exitJvm = bl;
    }

    public boolean isSendShutdownAtStart() {
        return this._sendShutdownAtStart;
    }

    public void setSendShutdownAtStart(boolean bl) {
        this._sendShutdownAtStart = bl;
    }

    public String getShutdownToken() {
        return this._shutdownToken;
    }

    public boolean isExitJvm() {
        return this._exitJvm;
    }
}

