/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.URIUtil;

public class SecuredRedirectHandler
extends AbstractHandler {
    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpChannel httpChannel = request.getHttpChannel();
        if (request.isSecure() || httpChannel == null) {
            return;
        }
        HttpConfiguration httpConfiguration = httpChannel.getHttpConfiguration();
        if (httpConfiguration == null) {
            httpServletResponse.sendError(403, "No http configuration available");
            return;
        }
        if (httpConfiguration.getSecurePort() > 0) {
            String string2 = httpConfiguration.getSecureScheme();
            int n = httpConfiguration.getSecurePort();
            String string3 = URIUtil.newURI((String)string2, (String)request.getServerName(), (int)n, (String)request.getRequestURI(), (String)request.getQueryString());
            httpServletResponse.setContentLength(0);
            httpServletResponse.sendRedirect(string3);
        } else {
            httpServletResponse.sendError(403, "Not Secure");
        }
        request.setHandled(true);
    }
}

