/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceHandler
extends HandlerWrapper
implements ResourceFactory {
    private static final Logger LOG = Log.getLogger(ResourceHandler.class);
    ContextHandler _context;
    Resource _baseResource;
    Resource _defaultStylesheet;
    Resource _stylesheet;
    String[] _welcomeFiles = new String[]{"index.html"};
    MimeTypes _mimeTypes;
    String _cacheControl;
    boolean _directory;
    boolean _gzip;
    boolean _etags;
    int _minMemoryMappedContentLength = 0;
    int _minAsyncContentLength = 16384;

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public boolean isDirectoriesListed() {
        return this._directory;
    }

    public void setDirectoriesListed(boolean bl) {
        this._directory = bl;
    }

    public int getMinMemoryMappedContentLength() {
        return this._minMemoryMappedContentLength;
    }

    public void setMinMemoryMappedContentLength(int n) {
        this._minMemoryMappedContentLength = n;
    }

    public int getMinAsyncContentLength() {
        return this._minAsyncContentLength;
    }

    public void setMinAsyncContentLength(int n) {
        this._minAsyncContentLength = n;
    }

    public boolean isEtags() {
        return this._etags;
    }

    public void setEtags(boolean bl) {
        this._etags = bl;
    }

    @Override
    public void doStart() {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        this._context = context == null ? null : context.getContextHandler();
        this._mimeTypes = this._context == null ? new MimeTypes() : this._context.getMimeTypes();
        super.doStart();
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource resource) {
        this._baseResource = resource;
    }

    public void setResourceBase(String string) {
        try {
            this.setBaseResource(Resource.newResource((String)string));
        }
        catch (Exception exception) {
            LOG.warn(exception.toString(), new Object[0]);
            LOG.debug((Throwable)exception);
            throw new IllegalArgumentException(string);
        }
    }

    public Resource getStylesheet() {
        if (this._stylesheet != null) {
            return this._stylesheet;
        }
        if (this._defaultStylesheet == null) {
            this._defaultStylesheet = Resource.newResource((URL)this.getClass().getResource("/jetty-dir.css"));
        }
        return this._defaultStylesheet;
    }

    public void setStylesheet(String string) {
        try {
            this._stylesheet = Resource.newResource((String)string);
            if (!this._stylesheet.exists()) {
                LOG.warn("unable to find custom stylesheet: " + string, new Object[0]);
                this._stylesheet = null;
            }
        }
        catch (Exception exception) {
            LOG.warn(exception.toString(), new Object[0]);
            LOG.debug((Throwable)exception);
            throw new IllegalArgumentException(string);
        }
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String string) {
        this._cacheControl = string;
    }

    public Resource getResource(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} getResource({})", new Object[]{this._context == null ? this._baseResource : this._context, this._baseResource, string});
        }
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        try {
            Resource resource = this._baseResource;
            if (resource == null) {
                if (this._context == null) {
                    return null;
                }
                return this._context.getResource(string);
            }
            Resource resource2 = resource.addPath(string = URIUtil.canonicalPath((String)string));
            if (resource2 != null && resource2.isAlias() && (this._context == null || !this._context.checkAlias(string, resource2))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resource={} alias={}", new Object[]{resource2, resource2.getAlias()});
                }
                return null;
            }
            return resource2;
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        Boolean bl = httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null;
        if (bl != null && bl.booleanValue()) {
            string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (string2 == null && string == null) {
                string2 = httpServletRequest.getServletPath();
                string = httpServletRequest.getPathInfo();
            }
        } else {
            string2 = httpServletRequest.getServletPath();
            string = httpServletRequest.getPathInfo();
        }
        String string3 = URIUtil.addPaths((String)string2, (String)string);
        return this.getResource(string3);
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public void setWelcomeFiles(String[] stringArray) {
        this._welcomeFiles = stringArray;
    }

    protected Resource getWelcome(Resource resource) {
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            Resource resource2 = resource.addPath(this._welcomeFiles[i]);
            if (!resource2.exists() || resource2.isDirectory()) continue;
            return resource2;
        }
        return null;
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        long l;
        String string2;
        Object object;
        if (request.isHandled()) {
            return;
        }
        boolean bl = false;
        if (!HttpMethod.GET.is(httpServletRequest.getMethod())) {
            if (!HttpMethod.HEAD.is(httpServletRequest.getMethod())) {
                super.handle(string, request, httpServletRequest, httpServletResponse);
                return;
            }
            bl = true;
        }
        Resource resource = this.getResource(httpServletRequest);
        if (LOG.isDebugEnabled()) {
            if (resource == null) {
                LOG.debug("resource=null", new Object[0]);
            } else {
                LOG.debug("resource={} alias={} exists={}", new Object[]{resource, resource.getAlias(), resource.exists()});
            }
        }
        if (resource == null || !resource.exists()) {
            if (string.endsWith("/jetty-dir.css")) {
                resource = this.getStylesheet();
                if (resource == null) {
                    return;
                }
                httpServletResponse.setContentType("text/css");
            } else {
                super.handle(string, request, httpServletRequest, httpServletResponse);
                return;
            }
        }
        request.setHandled(true);
        if (resource.isDirectory()) {
            String string3 = httpServletRequest.getPathInfo();
            boolean bl2 = (string3 == null ? httpServletRequest.getServletPath() : string3).endsWith("/");
            if (!bl2) {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URIUtil.addPaths((String)httpServletRequest.getRequestURI(), (String)"/")));
                return;
            }
            object = this.getWelcome(resource);
            if (object != null && object.exists()) {
                resource = object;
            } else {
                this.doDirectory(httpServletRequest, httpServletResponse, resource);
                request.setHandled(true);
                return;
            }
        }
        long l2 = resource.lastModified();
        object = null;
        if (this._etags) {
            string2 = httpServletRequest.getHeader(HttpHeader.IF_NONE_MATCH.asString());
            object = resource.getWeakETag();
            if (string2 != null && resource != null && string2.equals(object)) {
                httpServletResponse.setStatus(304);
                request.getResponse().getHttpFields().put(HttpHeader.ETAG, (String)object);
                return;
            }
        }
        if (l2 > 0L && (l = httpServletRequest.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())) > 0L && l2 / 1000L <= l / 1000L) {
            httpServletResponse.setStatus(304);
            return;
        }
        string2 = this._mimeTypes.getMimeByExtension(resource.toString());
        if (string2 == null) {
            string2 = this._mimeTypes.getMimeByExtension(httpServletRequest.getPathInfo());
        }
        this.doResponseHeaders(httpServletResponse, resource, string2);
        if (this._etags) {
            request.getResponse().getHttpFields().put(HttpHeader.ETAG, (String)object);
        }
        if (l2 > 0L) {
            httpServletResponse.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), l2);
        }
        if (bl) {
            return;
        }
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            servletOutputStream = new WriterOutputStream((Writer)httpServletResponse.getWriter());
        }
        if (!(servletOutputStream instanceof HttpOutput)) {
            resource.writeTo((OutputStream)servletOutputStream, 0L, resource.length());
        } else {
            int n;
            int n2 = n = this._minAsyncContentLength == 0 ? httpServletResponse.getBufferSize() : this._minAsyncContentLength;
            if (httpServletRequest.isAsyncSupported() && n > 0 && resource.length() >= (long)n) {
                final AsyncContext asyncContext = httpServletRequest.startAsync();
                asyncContext.setTimeout(0L);
                Callback callback = new Callback(){

                    public void succeeded() {
                        asyncContext.complete();
                    }

                    public void failed(Throwable throwable) {
                        LOG.warn(throwable.toString(), new Object[0]);
                        LOG.debug(throwable);
                        asyncContext.complete();
                    }
                };
                if (this._minMemoryMappedContentLength > 0 && resource.length() > (long)this._minMemoryMappedContentLength && resource.length() < Integer.MAX_VALUE && resource instanceof PathResource) {
                    ByteBuffer byteBuffer = BufferUtil.toMappedBuffer((File)resource.getFile());
                    ((HttpOutput)servletOutputStream).sendContent(byteBuffer, callback);
                } else {
                    ReadableByteChannel readableByteChannel = resource.getReadableByteChannel();
                    if (readableByteChannel != null) {
                        ((HttpOutput)servletOutputStream).sendContent(readableByteChannel, callback);
                    } else {
                        ((HttpOutput)servletOutputStream).sendContent(resource.getInputStream(), callback);
                    }
                }
            } else if (this._minMemoryMappedContentLength > 0 && resource.length() > (long)this._minMemoryMappedContentLength && resource instanceof PathResource) {
                ByteBuffer byteBuffer = BufferUtil.toMappedBuffer((File)resource.getFile());
                ((HttpOutput)servletOutputStream).sendContent(byteBuffer);
            } else {
                ReadableByteChannel readableByteChannel = resource.getReadableByteChannel();
                if (readableByteChannel != null) {
                    ((HttpOutput)servletOutputStream).sendContent(readableByteChannel);
                } else {
                    ((HttpOutput)servletOutputStream).sendContent(resource.getInputStream());
                }
            }
        }
    }

    protected void doDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Resource resource) {
        if (this._directory) {
            String string = resource.getListHTML(httpServletRequest.getRequestURI(), httpServletRequest.getPathInfo().lastIndexOf("/") > 0);
            httpServletResponse.setContentType("text/html;charset=utf-8");
            httpServletResponse.getWriter().println(string);
        } else {
            httpServletResponse.sendError(403);
        }
    }

    protected void doResponseHeaders(HttpServletResponse httpServletResponse, Resource resource, String string) {
        if (string != null) {
            httpServletResponse.setContentType(string);
        }
        long l = resource.length();
        if (httpServletResponse instanceof Response) {
            HttpFields httpFields = ((Response)httpServletResponse).getHttpFields();
            if (l > 0L) {
                ((Response)httpServletResponse).setLongContentLength(l);
            }
            if (this._cacheControl != null) {
                httpFields.put(HttpHeader.CACHE_CONTROL, this._cacheControl);
            }
        } else {
            if (l > Integer.MAX_VALUE) {
                httpServletResponse.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(l));
            } else if (l > 0L) {
                httpServletResponse.setContentLength((int)l);
            }
            if (this._cacheControl != null) {
                httpServletResponse.setHeader(HttpHeader.CACHE_CONTROL.asString(), this._cacheControl);
            }
        }
    }
}

