/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;

public class MovedContextHandler
extends ContextHandler {
    final Redirector _redirector;
    String _newContextURL;
    boolean _discardPathInfo;
    boolean _discardQuery;
    boolean _permanent;
    String _expires;

    public MovedContextHandler() {
        this._redirector = new Redirector();
        this.setHandler(this._redirector);
        this.setAllowNullPathInfo(true);
    }

    public MovedContextHandler(HandlerContainer handlerContainer, String string, String string2) {
        super(handlerContainer, string);
        this._newContextURL = string2;
        this._redirector = new Redirector();
        this.setHandler(this._redirector);
    }

    public boolean isDiscardPathInfo() {
        return this._discardPathInfo;
    }

    public void setDiscardPathInfo(boolean bl) {
        this._discardPathInfo = bl;
    }

    public String getNewContextURL() {
        return this._newContextURL;
    }

    public void setNewContextURL(String string) {
        this._newContextURL = string;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    public void setPermanent(boolean bl) {
        this._permanent = bl;
    }

    public boolean isDiscardQuery() {
        return this._discardQuery;
    }

    public void setDiscardQuery(boolean bl) {
        this._discardQuery = bl;
    }

    public String getExpires() {
        return this._expires;
    }

    public void setExpires(String string) {
        this._expires = string;
    }

    private class Redirector
    extends AbstractHandler {
        private Redirector() {
        }

        @Override
        public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            if (MovedContextHandler.this._newContextURL == null) {
                return;
            }
            String string2 = MovedContextHandler.this._newContextURL;
            if (!MovedContextHandler.this._discardPathInfo && httpServletRequest.getPathInfo() != null) {
                string2 = URIUtil.addPaths((String)string2, (String)httpServletRequest.getPathInfo());
            }
            StringBuilder stringBuilder = URIUtil.hasScheme((String)string2) ? new StringBuilder() : request.getRootURL();
            stringBuilder.append(string2);
            if (!MovedContextHandler.this._discardQuery && httpServletRequest.getQueryString() != null) {
                stringBuilder.append('?');
                String string3 = httpServletRequest.getQueryString();
                string3 = string3.replaceAll("\r\n?&=", "!");
                stringBuilder.append(string3);
            }
            httpServletResponse.setHeader(HttpHeader.LOCATION.asString(), stringBuilder.toString());
            if (MovedContextHandler.this._expires != null) {
                httpServletResponse.setHeader(HttpHeader.EXPIRES.asString(), MovedContextHandler.this._expires);
            }
            httpServletResponse.setStatus(MovedContextHandler.this._permanent ? 301 : 302);
            httpServletResponse.setContentLength(0);
            request.setHandled(true);
        }
    }
}

