/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ManagedAttributeListener
implements ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOG = Log.getLogger(ManagedAttributeListener.class);
    final Set<String> _managedAttributes = new HashSet<String>();
    final ContextHandler _context;

    public ManagedAttributeListener(ContextHandler contextHandler, String ... stringArray) {
        this._context = contextHandler;
        for (String string : stringArray) {
            this._managedAttributes.add(string);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("managedAttributes {}", new Object[]{this._managedAttributes});
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this._managedAttributes.contains(servletContextAttributeEvent.getName())) {
            this.updateBean(servletContextAttributeEvent.getName(), servletContextAttributeEvent.getValue(), servletContextAttributeEvent.getServletContext().getAttribute(servletContextAttributeEvent.getName()));
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this._managedAttributes.contains(servletContextAttributeEvent.getName())) {
            this.updateBean(servletContextAttributeEvent.getName(), servletContextAttributeEvent.getValue(), null);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this._managedAttributes.contains(servletContextAttributeEvent.getName())) {
            this.updateBean(servletContextAttributeEvent.getName(), null, servletContextAttributeEvent.getValue());
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Enumeration enumeration = servletContextEvent.getServletContext().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this._managedAttributes.contains(string)) continue;
            this.updateBean(string, null, servletContextEvent.getServletContext().getAttribute(string));
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Enumeration<String> enumeration = this._context.getServletContext().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!this._managedAttributes.contains(string)) continue;
            this.updateBean(string, servletContextEvent.getServletContext().getAttribute(string), null);
        }
    }

    protected void updateBean(String string, Object object, Object object2) {
        LOG.info("update {} {}->{} on {}", new Object[]{string, object, object2, this._context});
        if (LOG.isDebugEnabled()) {
            LOG.debug("update {} {}->{} on {}", new Object[]{string, object, object2, this._context});
        }
        this._context.updateBean(object, object2, false);
    }
}

