/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class IdleTimeoutHandler
extends HandlerWrapper {
    private long _idleTimeoutMs = 1000L;
    private boolean _applyToAsync = false;

    public boolean isApplyToAsync() {
        return this._applyToAsync;
    }

    public void setApplyToAsync(boolean bl) {
        this._applyToAsync = bl;
    }

    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }

    public void setIdleTimeoutMs(long l) {
        this._idleTimeoutMs = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpChannel httpChannel = request.getHttpChannel();
        long l = request.getHttpChannel().getIdleTimeout();
        httpChannel.setIdleTimeout(this._idleTimeoutMs);
        try {
            super.handle(string, request, httpServletRequest, httpServletResponse);
        }
        catch (Throwable throwable) {
            if (this._applyToAsync && httpServletRequest.isAsyncStarted()) {
                httpServletRequest.getAsyncContext().addListener(new AsyncListener(httpChannel, l){
                    final /* synthetic */ HttpChannel val$channel;
                    final /* synthetic */ long val$idle_timeout;
                    {
                        this.val$channel = httpChannel;
                        this.val$idle_timeout = l;
                    }

                    public void onTimeout(AsyncEvent asyncEvent) {
                    }

                    public void onStartAsync(AsyncEvent asyncEvent) {
                    }

                    public void onError(AsyncEvent asyncEvent) {
                        this.val$channel.setIdleTimeout(this.val$idle_timeout);
                    }

                    public void onComplete(AsyncEvent asyncEvent) {
                        this.val$channel.setIdleTimeout(this.val$idle_timeout);
                    }
                });
            } else {
                httpChannel.setIdleTimeout(l);
            }
            throw throwable;
        }
        if (this._applyToAsync && httpServletRequest.isAsyncStarted()) {
            httpServletRequest.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
        } else {
            httpChannel.setIdleTimeout(l);
        }
    }
}

