/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IPAddressMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class IPAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(IPAccessHandler.class);
    PathMap<IPAddressMap<Boolean>> _white = new PathMap(true);
    PathMap<IPAddressMap<Boolean>> _black = new PathMap(true);
    boolean _whiteListByPath = false;

    public IPAccessHandler() {
    }

    public IPAccessHandler(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray.length > 0) {
            this.setWhite(stringArray);
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            this.setBlack(stringArray2);
        }
    }

    public void addWhite(String string) {
        this.add(string, this._white);
    }

    public void addBlack(String string) {
        this.add(string, this._black);
    }

    public void setWhite(String[] stringArray) {
        this.set(stringArray, this._white);
    }

    public void setBlack(String[] stringArray) {
        this.set(stringArray, this._black);
    }

    public void setWhiteListByPath(boolean bl) {
        this._whiteListByPath = bl;
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        InetSocketAddress inetSocketAddress;
        EndPoint endPoint;
        HttpChannel httpChannel = request.getHttpChannel();
        if (httpChannel != null && (endPoint = httpChannel.getEndPoint()) != null && (inetSocketAddress = endPoint.getRemoteAddress()) != null && !this.isAddrUriAllowed(inetSocketAddress.getHostString(), request.getPathInfo())) {
            httpServletResponse.sendError(403);
            request.setHandled(true);
            return;
        }
        this.getHandler().handle(string, request, httpServletRequest, httpServletResponse);
    }

    protected void add(String string, PathMap<IPAddressMap<Boolean>> pathMap) {
        if (string != null && string.length() > 0) {
            IPAddressMap iPAddressMap;
            String string2;
            int n;
            boolean bl = false;
            if (string.indexOf(124) > 0) {
                n = string.indexOf(124);
            } else {
                n = string.indexOf(47);
                bl = n >= 0;
            }
            String string3 = n > 0 ? string.substring(0, n) : string;
            String string4 = string2 = n > 0 ? string.substring(n) : "/*";
            if (string3.endsWith(".")) {
                bl = true;
            }
            if (string2 != null && (string2.startsWith("|") || string2.startsWith("/*."))) {
                string2 = string2.substring(1);
            }
            if ((iPAddressMap = (IPAddressMap)pathMap.get((Object)string2)) == null) {
                iPAddressMap = new IPAddressMap();
                pathMap.put(string2, (Object)iPAddressMap);
            }
            if (string3 != null && !"".equals(string3)) {
                iPAddressMap.put(string3, (Object)true);
            }
            if (bl) {
                LOG.debug(this.toString() + " - deprecated specification syntax: " + string, new Object[0]);
            }
        }
    }

    protected void set(String[] stringArray, PathMap<IPAddressMap<Boolean>> pathMap) {
        pathMap.clear();
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                this.add(string, pathMap);
            }
        }
    }

    protected boolean isAddrUriAllowed(String string, String string2) {
        if (this._white.size() > 0) {
            boolean bl = false;
            boolean bl2 = false;
            for (Map.Entry entry : this._white.getMatches(string2)) {
                bl2 = true;
                IPAddressMap iPAddressMap = (IPAddressMap)entry.getValue();
                if (iPAddressMap == null || iPAddressMap.size() != 0 && iPAddressMap.match(string) == null) continue;
                bl = true;
                break;
            }
            if (this._whiteListByPath ? bl2 && !bl : !bl) {
                return false;
            }
        }
        if (this._black.size() > 0) {
            for (Map.Entry entry : this._black.getMatches(string2)) {
                IPAddressMap iPAddressMap = (IPAddressMap)entry.getValue();
                if (iPAddressMap == null || iPAddressMap.size() != 0 && iPAddressMap.match(string) == null) continue;
                return false;
            }
        }
        return true;
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString());
        stringBuilder.append(" WHITELIST:\n");
        this.dump(stringBuilder, this._white);
        stringBuilder.append(this.toString());
        stringBuilder.append(" BLACKLIST:\n");
        this.dump(stringBuilder, this._black);
        return stringBuilder.toString();
    }

    protected void dump(StringBuilder stringBuilder, PathMap<IPAddressMap<Boolean>> pathMap) {
        for (String string : pathMap.keySet()) {
            for (String string2 : ((IPAddressMap)pathMap.get((Object)string)).keySet()) {
                stringBuilder.append("# ");
                stringBuilder.append(string2);
                stringBuilder.append("|");
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
    }
}

