/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Parameter handler is null.");
        }
        try {
            this.updateBean(this._handler, handler, true);
            this._handler = handler;
            Server server = this.getServer();
            handler.setServer(server);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void doStart() {
        super.doStart();
    }

    @Override
    protected void doStop() {
        super.doStop();
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(string, request, httpServletRequest, httpServletResponse);
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> clazz) {
        this.expandHandler(this._handler, list, clazz);
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler handler = this.getHandler();
        if (handler != null) {
            this.setHandler(null);
            handler.destroy();
        }
        super.destroy();
    }
}

