/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Handler wrapping another Handler")
public class HandlerWrapper
extends AbstractHandlerContainer {
    protected Handler _handler;

    @ManagedAttribute(value="Wrapped Handler", readonly=true)
    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        if (this._handler == null) {
            return new Handler[0];
        }
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        if (handler != null) {
            handler.setServer(this.getServer());
        }
        Handler handler2 = this._handler;
        this._handler = handler;
        this.updateBean(handler2, this._handler, true);
    }

    public void insertHandler(HandlerWrapper handlerWrapper) {
        if (handlerWrapper == null || handlerWrapper.getHandler() != null) {
            throw new IllegalArgumentException();
        }
        handlerWrapper.setHandler(this.getHandler());
        this.setHandler(handlerWrapper);
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Handler handler = this._handler;
        if (handler != null) {
            handler.handle(string, request, httpServletRequest, httpServletResponse);
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> clazz) {
        this.expandHandler(this._handler, list, clazz);
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler handler = this.getHandler();
        if (handler != null) {
            this.setHandler(null);
            handler.destroy();
        }
        super.destroy();
    }
}

