/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Handler of multiple handlers")
public class HandlerCollection
extends AbstractHandlerContainer {
    private final boolean _mutableWhenRunning;
    private volatile Handler[] _handlers;

    public HandlerCollection() {
        this._mutableWhenRunning = false;
    }

    public HandlerCollection(boolean bl) {
        this._mutableWhenRunning = bl;
    }

    @Override
    @ManagedAttribute(value="Wrapped handlers", readonly=true)
    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlerArray) {
        if (!this._mutableWhenRunning && this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        if (handlerArray != null) {
            for (Handler handler : handlerArray) {
                if (handler.getServer() == this.getServer()) continue;
                handler.setServer(this.getServer());
            }
        }
        Object[] objectArray = this._handlers;
        this._handlers = handlerArray;
        this.updateBeans(objectArray, handlerArray);
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this._handlers != null && this.isStarted()) {
            MultiException multiException = null;
            for (int i = 0; i < this._handlers.length; ++i) {
                try {
                    this._handlers[i].handle(string, request, httpServletRequest, httpServletResponse);
                    continue;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    if (multiException == null) {
                        multiException = new MultiException();
                    }
                    multiException.add((Throwable)exception);
                }
            }
            if (multiException != null) {
                if (multiException.size() == 1) {
                    throw new ServletException(multiException.getThrowable(0));
                }
                throw new ServletException((Throwable)multiException);
            }
        }
    }

    public void addHandler(Handler handler) {
        this.setHandlers((Handler[])ArrayUtil.addToArray((Object[])this.getHandlers(), (Object)handler, Handler.class));
    }

    public void removeHandler(Handler handler) {
        Object[] objectArray = this.getHandlers();
        if (objectArray != null && objectArray.length > 0) {
            this.setHandlers((Handler[])ArrayUtil.removeFromArray((Object[])objectArray, (Object)handler));
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> clazz) {
        if (this.getHandlers() != null) {
            for (Handler handler : this.getHandlers()) {
                this.expandHandler(handler, list, clazz);
            }
        }
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler[] handlerArray = this.getChildHandlers();
        this.setHandlers(null);
        for (Handler handler : handlerArray) {
            handler.destroy();
        }
        super.destroy();
    }

    public String toString() {
        Handler[] handlerArray = this.getHandlers();
        return super.toString() + (handlerArray == null ? "[]" : Arrays.asList(this.getHandlers()).toString());
    }
}

