/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ErrorHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(ErrorHandler.class);
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    boolean _showStacks = true;
    boolean _showMessageInTitle = true;
    String _cacheControl = "must-revalidate,no-cache,no-store";

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2;
        String string3;
        String string4 = httpServletRequest.getMethod();
        if (!(HttpMethod.GET.is(string4) || HttpMethod.POST.is(string4) || HttpMethod.HEAD.is(string4))) {
            request.setHandled(true);
            return;
        }
        if (this instanceof ErrorPageMapper && (string3 = ((ErrorPageMapper)((Object)this)).getErrorPage(httpServletRequest)) != null && httpServletRequest.getServletContext() != null && ((string2 = (String)httpServletRequest.getAttribute(ERROR_PAGE)) == null || !string2.equals(string3))) {
            httpServletRequest.setAttribute(ERROR_PAGE, (Object)string3);
            Dispatcher dispatcher = (Dispatcher)httpServletRequest.getServletContext().getRequestDispatcher(string3);
            try {
                if (dispatcher != null) {
                    dispatcher.error((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                LOG.warn("No error page " + string3, new Object[0]);
            }
            catch (ServletException servletException) {
                LOG.warn("EXCEPTION ", (Throwable)servletException);
                return;
            }
        }
        request.setHandled(true);
        httpServletResponse.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.asString());
        if (this._cacheControl != null) {
            httpServletResponse.setHeader(HttpHeader.CACHE_CONTROL.asString(), this._cacheControl);
        }
        string3 = new ByteArrayISO8859Writer(4096);
        string2 = httpServletResponse instanceof Response ? ((Response)httpServletResponse).getReason() : null;
        this.handleErrorPage(httpServletRequest, (Writer)((Object)string3), httpServletResponse.getStatus(), string2);
        string3.flush();
        httpServletResponse.setContentLength(string3.size());
        string3.writeTo((OutputStream)httpServletResponse.getOutputStream());
        string3.destroy();
    }

    protected void handleErrorPage(HttpServletRequest httpServletRequest, Writer writer, int n, String string) {
        this.writeErrorPage(httpServletRequest, writer, n, string, this._showStacks);
    }

    protected void writeErrorPage(HttpServletRequest httpServletRequest, Writer writer, int n, String string, boolean bl) {
        if (string == null) {
            string = HttpStatus.getMessage((int)n);
        }
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(httpServletRequest, writer, n, string);
        writer.write("</head>\n<body>");
        this.writeErrorPageBody(httpServletRequest, writer, n, string, bl);
        writer.write("\n</body>\n</html>\n");
    }

    protected void writeErrorPageHead(HttpServletRequest httpServletRequest, Writer writer, int n, String string) {
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"/>\n");
        writer.write("<title>Error ");
        writer.write(Integer.toString(n));
        if (this._showMessageInTitle) {
            writer.write(32);
            this.write(writer, string);
        }
        writer.write("</title>\n");
    }

    protected void writeErrorPageBody(HttpServletRequest httpServletRequest, Writer writer, int n, String string, boolean bl) {
        String string2 = httpServletRequest.getRequestURI();
        this.writeErrorPageMessage(httpServletRequest, writer, n, string, string2);
        if (bl) {
            this.writeErrorPageStacks(httpServletRequest, writer);
        }
        Request.getBaseRequest((ServletRequest)httpServletRequest).getHttpChannel().getHttpConfiguration().writePoweredBy(writer, "<hr>", "<hr/>\n");
    }

    protected void writeErrorPageMessage(HttpServletRequest httpServletRequest, Writer writer, int n, String string, String string2) {
        writer.write("<h2>HTTP ERROR ");
        writer.write(Integer.toString(n));
        writer.write("</h2>\n<p>Problem accessing ");
        this.write(writer, string2);
        writer.write(". Reason:\n<pre>    ");
        this.write(writer, string);
        writer.write("</pre></p>");
    }

    protected void writeErrorPageStacks(HttpServletRequest httpServletRequest, Writer writer) {
        for (Throwable throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception"); throwable != null; throwable = throwable.getCause()) {
            writer.write("<h3>Caused by:</h3><pre>");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            this.write(writer, stringWriter.getBuffer().toString());
            writer.write("</pre>\n");
        }
    }

    public ByteBuffer badMessageError(int n, String string, HttpFields httpFields) {
        if (string == null) {
            string = HttpStatus.getMessage((int)n);
        }
        httpFields.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.TEXT_HTML_8859_1.asString());
        return BufferUtil.toBuffer((String)("<h1>Bad Message " + n + "</h1><pre>reason: " + string + "</pre>"));
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String string) {
        this._cacheControl = string;
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean bl) {
        this._showStacks = bl;
    }

    public void setShowMessageInTitle(boolean bl) {
        this._showMessageInTitle = bl;
    }

    public boolean getShowMessageInTitle() {
        return this._showMessageInTitle;
    }

    protected void write(Writer writer, String string) {
        if (string == null) {
            return;
        }
        writer.write(StringUtil.sanitizeXmlString((String)string));
    }

    public static ErrorHandler getErrorHandler(Server server, ContextHandler contextHandler) {
        ErrorHandler errorHandler = null;
        if (contextHandler != null) {
            errorHandler = contextHandler.getErrorHandler();
        }
        if (errorHandler == null && server != null) {
            errorHandler = (ErrorHandler)server.getBean(ErrorHandler.class);
        }
        return errorHandler;
    }

    public static interface ErrorPageMapper {
        public String getErrorPage(HttpServletRequest var1);
    }
}

