/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class DefaultHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(DefaultHandler.class);
    final long _faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    byte[] _favicon;
    boolean _serveIcon = true;
    boolean _showContexts = true;

    public DefaultHandler() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource("org/eclipse/jetty/favicon.ico");
            if (uRL != null) {
                Resource resource = Resource.newResource((URL)uRL);
                this._favicon = IO.readBytes((InputStream)resource.getInputStream());
            }
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
        }
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletResponse.isCommitted() || request.isHandled()) {
            return;
        }
        request.setHandled(true);
        String string2 = httpServletRequest.getMethod();
        if (this._serveIcon && this._favicon != null && HttpMethod.GET.is(string2) && httpServletRequest.getRequestURI().equals("/favicon.ico")) {
            if (httpServletRequest.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString()) == this._faviconModified) {
                httpServletResponse.setStatus(304);
            } else {
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType("image/x-icon");
                httpServletResponse.setContentLength(this._favicon.length);
                httpServletResponse.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), this._faviconModified);
                httpServletResponse.setHeader(HttpHeader.CACHE_CONTROL.toString(), "max-age=360000,public");
                httpServletResponse.getOutputStream().write(this._favicon);
            }
            return;
        }
        if (!(this._showContexts && HttpMethod.GET.is(string2) && httpServletRequest.getRequestURI().equals("/"))) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType(MimeTypes.Type.TEXT_HTML.toString());
        try (ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer(1500);){
            Object object;
            byteArrayISO8859Writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
            byteArrayISO8859Writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
            byteArrayISO8859Writer.write("No context on this server matched or handled this request.<BR>");
            byteArrayISO8859Writer.write("Contexts known to this server are: <ul>");
            Server server = this.getServer();
            Handler[] handlerArray = server == null ? null : server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
                object = (ContextHandler)handlerArray[i];
                if (object.isRunning()) {
                    byteArrayISO8859Writer.write("<li><a href=\"");
                    if (((ContextHandler)object).getVirtualHosts() != null && ((ContextHandler)object).getVirtualHosts().length > 0) {
                        byteArrayISO8859Writer.write(httpServletRequest.getScheme() + "://" + ((ContextHandler)object).getVirtualHosts()[0] + ":" + httpServletRequest.getLocalPort());
                    }
                    byteArrayISO8859Writer.write(((ContextHandler)object).getContextPath());
                    if (((ContextHandler)object).getContextPath().length() > 1 && ((ContextHandler)object).getContextPath().endsWith("/")) {
                        byteArrayISO8859Writer.write("/");
                    }
                    byteArrayISO8859Writer.write("\">");
                    byteArrayISO8859Writer.write(((ContextHandler)object).getContextPath());
                    if (((ContextHandler)object).getVirtualHosts() != null && ((ContextHandler)object).getVirtualHosts().length > 0) {
                        byteArrayISO8859Writer.write("&nbsp;@&nbsp;" + ((ContextHandler)object).getVirtualHosts()[0] + ":" + httpServletRequest.getLocalPort());
                    }
                    byteArrayISO8859Writer.write("&nbsp;--->&nbsp;");
                    byteArrayISO8859Writer.write(((ContextHandler)object).toString());
                    byteArrayISO8859Writer.write("</a></li>\n");
                    continue;
                }
                byteArrayISO8859Writer.write("<li>");
                byteArrayISO8859Writer.write(((ContextHandler)object).getContextPath());
                if (((ContextHandler)object).getVirtualHosts() != null && ((ContextHandler)object).getVirtualHosts().length > 0) {
                    byteArrayISO8859Writer.write("&nbsp;@&nbsp;" + ((ContextHandler)object).getVirtualHosts()[0] + ":" + httpServletRequest.getLocalPort());
                }
                byteArrayISO8859Writer.write("&nbsp;--->&nbsp;");
                byteArrayISO8859Writer.write(((ContextHandler)object).toString());
                if (object.isFailed()) {
                    byteArrayISO8859Writer.write(" [failed]");
                }
                if (object.isStopped()) {
                    byteArrayISO8859Writer.write(" [stopped]");
                }
                byteArrayISO8859Writer.write("</li>\n");
            }
            byteArrayISO8859Writer.write("</ul><hr>");
            request.getHttpChannel().getHttpConfiguration().writePoweredBy((Appendable)byteArrayISO8859Writer, "<a href=\"http://eclipse.org/jetty\"><img border=0 src=\"/favicon.ico\"/></a>&nbsp;", "<hr/>\n");
            byteArrayISO8859Writer.write("\n</BODY>\n</HTML>\n");
            byteArrayISO8859Writer.flush();
            httpServletResponse.setContentLength(byteArrayISO8859Writer.size());
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            object = null;
            try {
                byteArrayISO8859Writer.writeTo((OutputStream)servletOutputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (servletOutputStream != null) {
                    if (object != null) {
                        try {
                            servletOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        servletOutputStream.close();
                    }
                }
            }
        }
    }

    public boolean getServeIcon() {
        return this._serveIcon;
    }

    public void setServeIcon(boolean bl) {
        this._serveIcon = bl;
    }

    public boolean getShowContexts() {
        return this._showContexts;
    }

    public void setShowContexts(boolean bl) {
        this._showContexts = bl;
    }
}

