/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper
implements Connection.Listener {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Response response = request.getResponse();
        Thread thread = Thread.currentThread();
        String string2 = thread.getName();
        boolean bl = false;
        boolean bl2 = false;
        String string3 = (String)httpServletRequest.getAttribute("org.eclipse.jetty.thread.name");
        if (string3 == null) {
            string3 = string2 + ":" + request.getHttpURI();
        } else {
            bl2 = true;
        }
        String string4 = null;
        try {
            if (bl2) {
                this.print(string3, "RESUME");
            } else {
                this.print(string3, "REQUEST " + request.getRemoteAddr() + " " + httpServletRequest.getMethod() + " " + request.getHeader("Cookie") + "; " + request.getHeader("User-Agent"));
            }
            thread.setName(string3);
            this.getHandler().handle(string, request, httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            try {
                string4 = iOException.toString();
                throw iOException;
                catch (ServletException servletException) {
                    string4 = servletException.toString() + ":" + servletException.getCause();
                    throw servletException;
                }
                catch (RuntimeException runtimeException) {
                    string4 = runtimeException.toString();
                    throw runtimeException;
                }
                catch (Error error) {
                    string4 = error.toString();
                    throw error;
                }
            }
            catch (Throwable throwable) {
                thread.setName(string2);
                bl = request.getHttpChannelState().isSuspended();
                if (bl) {
                    httpServletRequest.setAttribute("org.eclipse.jetty.thread.name", (Object)string3);
                    this.print(string3, "SUSPEND");
                    throw throwable;
                }
                this.print(string3, "RESPONSE " + response.getStatus() + (string4 == null ? "" : "/" + string4) + " " + response.getContentType());
                throw throwable;
            }
        }
        thread.setName(string2);
        bl = request.getHttpChannelState().isSuspended();
        if (bl) {
            httpServletRequest.setAttribute("org.eclipse.jetty.thread.name", (Object)string3);
            this.print(string3, "SUSPEND");
            return;
        }
        this.print(string3, "RESPONSE " + response.getStatus() + (string4 == null ? "" : "/" + string4) + " " + response.getContentType());
    }

    private void print(String string, String string2) {
        long l = System.currentTimeMillis();
        String string3 = this._date.formatNow(l);
        int n = (int)(l % 1000L);
        this._print.println(string3 + (n > 99 ? "." : (n > 9 ? ".0" : ".00")) + n + ":" + string + " " + string2);
    }

    @Override
    protected void doStart() {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            ((AbstractConnector)connector).addBean(this, false);
        }
        super.doStart();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this._print.close();
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            ((AbstractConnector)connector).removeBean(this);
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._out = outputStream;
    }

    public void onOpened(Connection connection) {
        this.print(Thread.currentThread().getName(), "OPENED " + connection.toString());
    }

    public void onClosed(Connection connection) {
        this.print(Thread.currentThread().getName(), "CLOSED " + connection.toString());
    }
}

