/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private final ConcurrentMap<ContextHandler, Handler> _contextBranches = new ConcurrentHashMap<ContextHandler, Handler>();
    private volatile Trie<Map.Entry<String, Branch[]>> _pathBranches;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    @ManagedOperation(value="update the mapping of context path to context")
    public void mapContexts() {
        ArrayTernaryTrie arrayTernaryTrie;
        this._contextBranches.clear();
        if (this.getHandlers() == null) {
            this._pathBranches = new ArrayTernaryTrie(false, 16);
            return;
        }
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        for (Handler object : this.getHandlers()) {
            Branch branch = new Branch(object);
            for (String string : branch.getContextPaths()) {
                Object[] objectArray = (Branch[])hashMap.get(string);
                hashMap.put(string, ArrayUtil.addToArray((Object[])objectArray, (Object)branch, Branch.class));
            }
            for (ContextHandler contextHandler : branch.getContextHandlers()) {
                this._contextBranches.putIfAbsent(contextHandler, branch.getHandler());
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Branch[] branchArray = (Branch[])entry.getValue();
            Branch[] branchArray2 = new Branch[branchArray.length];
            int n = 0;
            for (Branch branch : branchArray) {
                if (!branch.hasVirtualHost()) continue;
                branchArray2[n++] = branch;
            }
            for (Branch branch : branchArray) {
                if (branch.hasVirtualHost()) continue;
                branchArray2[n++] = branch;
            }
            entry.setValue(branchArray2);
        }
        int n = 512;
        block6: while (true) {
            arrayTernaryTrie = new ArrayTernaryTrie(false, n);
            for (Map.Entry entry : hashMap.entrySet()) {
                if (arrayTernaryTrie.put(((String)entry.getKey()).substring(1), entry)) continue;
                n += 512;
                continue block6;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            for (String string : arrayTernaryTrie.keySet()) {
                LOG.debug("{}->{}", new Object[]{string, Arrays.asList((Object[])((Map.Entry)arrayTernaryTrie.get(string)).getValue())});
            }
        }
        this._pathBranches = arrayTernaryTrie;
    }

    @Override
    public void setHandlers(Handler[] handlerArray) {
        super.setHandlers(handlerArray);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ContextHandler contextHandler;
        Handler[] handlerArray = this.getHandlers();
        if (handlerArray == null || handlerArray.length == 0) {
            return;
        }
        HttpChannelState httpChannelState = request.getHttpChannelState();
        if (httpChannelState.isAsync() && (contextHandler = httpChannelState.getContextHandler()) != null) {
            Handler handler = (Handler)this._contextBranches.get(contextHandler);
            if (handler == null) {
                contextHandler.handle(string, request, httpServletRequest, httpServletResponse);
            } else {
                handler.handle(string, request, httpServletRequest, httpServletResponse);
            }
            return;
        }
        if (string.startsWith("/")) {
            Map.Entry entry;
            int n = string.length() - 1;
            while (n >= 0 && (entry = (Map.Entry)this._pathBranches.getBest(string, 1, n)) != null) {
                int n2 = ((String)entry.getKey()).length();
                if (n2 == 1 || string.length() == n2 || string.charAt(n2) == '/') {
                    for (Branch branch : (Branch[])entry.getValue()) {
                        branch.getHandler().handle(string, request, httpServletRequest, httpServletResponse);
                        if (!request.isHandled()) continue;
                        return;
                    }
                }
                n = n2 - 2;
            }
        } else {
            for (int i = 0; i < handlerArray.length; ++i) {
                handlerArray[i].handle(string, request, httpServletRequest, httpServletResponse);
                if (!request.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String string, String string2) {
        try {
            ContextHandler contextHandler = this._contextClass.newInstance();
            contextHandler.setContextPath(string);
            contextHandler.setResourceBase(string2);
            this.addHandler(contextHandler);
            return contextHandler;
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            throw new Error(exception);
        }
    }

    public Class<?> getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class<? extends ContextHandler> clazz) {
        if (clazz == null || !ContextHandler.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = clazz;
    }

    private static final class Branch {
        private final Handler _handler;
        private final ContextHandler[] _contexts;

        Branch(Handler handler) {
            this._handler = handler;
            if (handler instanceof ContextHandler) {
                this._contexts = new ContextHandler[]{(ContextHandler)handler};
            } else if (handler instanceof HandlerContainer) {
                Handler[] handlerArray = ((HandlerContainer)((Object)handler)).getChildHandlersByClass(ContextHandler.class);
                this._contexts = new ContextHandler[handlerArray.length];
                System.arraycopy(handlerArray, 0, this._contexts, 0, handlerArray.length);
            } else {
                this._contexts = new ContextHandler[0];
            }
        }

        Set<String> getContextPaths() {
            HashSet<String> hashSet = new HashSet<String>();
            for (ContextHandler contextHandler : this._contexts) {
                hashSet.add(contextHandler.getContextPath());
            }
            return hashSet;
        }

        boolean hasVirtualHost() {
            for (ContextHandler contextHandler : this._contexts) {
                if (contextHandler.getVirtualHosts() == null || contextHandler.getVirtualHosts().length <= 0) continue;
                return true;
            }
            return false;
        }

        ContextHandler[] getContextHandlers() {
            return this._contexts;
        }

        Handler getHandler() {
            return this._handler;
        }

        public String toString() {
            return String.format("{%s,%s}", this._handler, Arrays.asList(this._contexts));
        }
    }
}

